<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// stars.php - record locking ZIM example
// use this URL as a reference when coding:
// https://zimjs.com/base/commands.php

// ZIM BASE - Database Simplified
// connection, insert, update, select, delete, query, reply, lock
// https://zimjs.com/base/
// https://zimjs.com/base/zim_base.zip
// Free to use - donations welcome - https://zimjs.com/donate/

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// ZIM BASE
// Import ZIM Base which connects to database
// and provides easy database queries on the variable $base.
// This file includes your server and database access settings.
// A specific database can be specified here if desired:
// $database = "database_name";

require_once('zim_base.php');

// ID
// In this case there is one ID - "stars"
// This is a case where we just store all our data as JSON in one field.
// If you want reporting, we could insert new records
// in that case the id might be autoincrementing, etc.
// Or if we were wanting data for a certain id
// then we can pass that in the extra parameter of ZIM Bind
// and ZIM Base will provide that as $extra - so use: $id = $extra;
$id = "stars";

// THIS EXAMPLE
// In this example we receive data from ZIM Bind.
// ZIM Base will automatically process this and provide a $data variable.

// We are using toLock() in ZIM Bind
// This is a system that gets the latest data just before the user sends data.
// The latest data is added to or updated on the client
// and then sent back to the database for updating.
// So we will receive a "from" command first at which point we will lock the record
// and then we will receive a "to" command where we update and unlock the record.
// The command is automatically processed by ZIM Base and available as $command.

// LOCK ID
// ZIM Bind sends a lock variable
// which ZIM Base automatically collects and provides as $lock
// lock is a keyword in SQL so use $lockid
$lockid = $lock;

if ($command == "from") {

    // LOCKING
    // waits for unlocked record then sets lock
    // if desired, these parameters can be set
    // setLock(table, idvalue, lockvalue, idfield, lockfield);
    // the defaults are $id, $lockid, "id", "lockid"
    // Our table should have an id and lockid fields to use the defaults
    // Note - the id can be any type but the lockid should be of type varchar.
    // Do not need the $lockid check in this case but here is how you would do it
    // if there were other from calls that are not locking
    if ($lockid != "") $base->setLock("zim_base_stars", $id, $lockid);

    // SELECTING
    // ZIM Bind.from() will send a JSON data property requesting data
    // If the ZIM Bind full parameter is set to true (default)
    // then the data will be the JSON string 'full'
    // so return the JSON string stored at the id.
    // In this case - we know it is full so we don't even bother checking.

    // -- If full is not set to true in Bind then separate fields can be used.
    // -- Parse the JSON data request - it will have the format:
    // -- '{"id":["prop1","prop2"], "id2":["prop3"]}'
    // -- and then return the data for the fields requested as a JSON string:
    // -- '{"id1":{"prop1":"value", "prop2":"value"}, "id2":{"prop3":"value"}}'

    $result = $base->select("zim_base_stars", "json", ["id"=>$id]);
    if ($result->error) $base->reply("error","could not connect");
    $base->reply($result->json);

    // without error checking:
    // $base->reply($base->select("zim_base_stars", "json", [id=>$id])->json);

} else if ($command == "to") {

    // ZIM Bind.to() will send a data property in JSON format:
    // '{"id1":{"prop1":"value", "prop2":"value"}, "id2":{"prop3":"value"}}'
    // if full is set to true (default) then this will be all the bind data
    // so the JSON string can be stored at the id in the database
    // If separate fields are desired then set full to false in the Bind object
    // and parse the JSON data accordingly, loop and fill specific fields

    // CLEAR LOCK
    // we will clear the lockid by passing in ""
    // we could apply an extra argument here: [lockid=>$lockid]
    // that would update where the lock id matches but it is not necessary.

    // INSERT / UPDATE
    // insert(table, fields, update, where, more)
    // this will insert if not there otherwise update - something like this:
    // INSERT INTO zim_base_stars (id, lockid, json) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE lockid=?, json=?
    $result = $base->insert("zim_base_stars", ["id"=>$id, "lockid"=>"", "json"=>$data], ["lockid"=>"", "json"=>$data]);

    if ($result->affected_rows < 1) {
        $base->reply("error","could not add data");
    } else {
        $base->reply("success","data added");
    }

}

?>
