<?php

// shapes.php - simple ZIM example updating a shared Blob and Squiggle
// use this URL as a reference when coding:
// https://zimjs.com/base/commands.php

// ZIM BASE - Database Simplified
// connection, insert, update, select, delete, query, reply, lock
// https://zimjs.com/base/
// https://zimjs.com/base/zim_base.zip
// Free to use - donations welcome - https://zimjs.com/donate/

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// ZIM BASE
// Import ZIM Base which connects to database
// and provides easy database queries on the variable $base.
// This file includes your server and database access settings.
// A specific database can be specified here if desired:
// $database = "database_name";

require_once('zim_base.php');

// THIS EXAMPLE
// In this example we receive data from ZIM Bind.
// ZIM Bind will send command and data variables
// which are automatically processed by ZIM Base and provided as $command and $data.

// ID
// In this case there is one ID - "shapes" for both our shapes.
// We could handle multiple objects and multiple ids.
// To do this, send the id in the "extra" parameter in ZIM Bind to() and from()
// The extra variable is automatically captured by ZIM Base and provided as $extra
// at which point you could use $id = $extra;
$id = "shapes";

// ZIM Bind.to() will send a data property in JSON format:
// '{"id1":{"prop1":"value", "prop2":"value"}, "id2":{"prop3":"value"}}'
// if full is set to true (default) then this will be all the bind data
// so the JSON string can be stored at the id in the database
// If separate fields are desired then set full to false in the Bind object
// and parse the JSON data accordingly, loop and fill specific fields
if ($command == "to") {

    // INSERT / UPDATE
    // insert(table, fields, update, where, more)
    // this will insert if not there otherwise update - something like this:
    // INSERT INTO zim_base_shapes (id, json) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE lockid=?, data=?
    $result = $base->insert("zim_base_shapes", ["id"=>$id, "json"=>$data], ["json"=>$data]);

    if ($result->affected_rows < 0) {
        $base->reply("error","could not add data");
    } else {
        $base->reply("success","data added");
    }

} else if ($command == "from") {

    // SELECTING
    // ZIM Bind.from() will send a JSON data property requesting data
    // If the ZIM Bind full parameter is set to true (default)
    // then the data will be the JSON string 'full'
    // so return the JSON string stored at the id.
    // In this case there is only one record
    // so the WHERE id is $id is not really needed

    // -- If full is not set to true in Bind then separate fields can be used.
    // -- Parse the JSON data request - it will have the format:
    // -- '{"id":["prop1","prop2"], "id2":["prop3"]}'
    // -- and then return the data for the fields requested as a JSON string:
    // -- '{"id1":{"prop1":"value", "prop2":"value"}, "id2":{"prop3":"value"}}'

    $result = $base->select("zim_base_shapes", "json", ["id"=>$id]);
    if ($result->errorCode) $base->reply("error","could not connect");
    $base->reply($result->json);

    // without error checking:
    // $base->reply($base->select("zim_base_shapes", "json", [id=>$id])->json);

}

?>
