<?php

// example.php - simple HTML form results page
// use this URL as a reference when coding:
// https://zimjs.com/base/commands.php

// ZIM BASE - Database Simplified
// connection, insert, update, select, delete, query, reply, lock
// https://zimjs.com/base/
// https://zimjs.com/base/zim_base.zip
// Free to use - donations welcome - https://zimjs.com/donate/

?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
    <head>
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-GSHN2BZVKW"></script>
        <script>window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', 'G-GSHN2BZVKW');</script>
        <meta charset="utf-8">
        <title>ZIM_Base - Example HTML Form Results Page</title>
        <link href="base.css" rel="stylesheet" type="text/css" />
    </head>
    <body>
        <h1><a class="plain" href="example.html"><img id=topIcon src="base_icon.png" alt="ZIM BASE - Database Simplified"></a>ZIM BASE - Database Simplified</h1>

<?php

// ZIM BASE
// Import ZIM Base which connects to database
// and provides easy database queries on the variable $base.
// This file includes your server and database access settings.
// A specific database can be specified here if desired:
// $database = "database_name";

require_once('zim_base.php');

// THIS EXAMPLE
// In this example we receive POST data from the form.
// We will input this into the database and echo back a results table.

// INPUT
$base->makeVars("person", "occupation");
$result = $base->insert("zim_base_example", ["person"=>$person, "occupation"=>$occupation, "date"=>"NOW()"]);
if ($result->affected_rows > 0) {
    echo "Data successfully added.<br><br>";
} else {
    echo "Sorry, data not added.<br><br>";
}

// SELECT
echo "<div class=heading>Last FIVE entries for the submitted person</div>";
$result = $base->select("zim_base_example", "*", ["person"=>$person], "ORDER BY date DESC LIMIT 5");
if ($result->num_rows < 1) {
    echo "Sorry - no data for this person.<br><br>";
} else {
    echo "<table><tr><th>Person</th><th>Occupation</th>\n";
    foreach ($result->assoc as $record) {
        echo "<tr><td>".$record["person"]."</td><td>".$record["occupation"]."</td></tr>\n";
    }
    echo "</table>";
}

echo "<br><div class=heading>Last FORTY entries</div>";
$result = $base->select("zim_base_example", "*", null, "ORDER BY date DESC LIMIT 40");
if ($result->num_rows < 1) {
    echo "Sorry - no data.<br><br>";
} else {
    echo "<table><tr><th>Person</th><th>Occupation</th>\n";
    // Demonstrating that we can use the array() method rather than the assoc() method
    // at which point the result is an array of arrays rather than an array of associative arrays
    // Note that $row[0] is the id
    foreach ($result->array as $row) {
        echo "<tr><td>".$row[1]."</td><td>".$row[2]."</td></tr>\n";
    }
    echo "</table>";
}


?>

<br><br>
<a class="plain" href="https://zimjs.com" target=_blank><img id="bottomIcon" src="base_icon.png" alt="ZIM BASE - easy MySQLi"></a>
<br>
<footer><a href="https://zimjs.com" target=_blank>zimjs.com</a></footer>
</body>
</html>
