
<?php

    ini_set('display_errors', '1');
    ini_set('display_startup_errors', '1');
    error_reporting(E_ALL);

// commands.php - demonstrates commands with ZIM BASE
// use this URL as a reference when coding:
// https://zimjs.com/base/commands.php

// ZIM BASE - Database Simplified
// connection, insert, update, select, delete, query, reply, lock
// https://zimjs.com/base/
// https://zimjs.com/base/zim_base.zip
// Free to use - donations welcome - https://zimjs.com/donate/

// SEE BELOW HTML for more information

?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
    <head>
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-GSHN2BZVKW"></script>
        <script>window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', 'G-GSHN2BZVKW');</script>
        <meta charset="utf-8">
        <title>ZIM Base - Database Simplified - easy PHP MySQLi</title>
        <link href="base.css" rel="stylesheet" type="text/css" />
    </head>
    <body>
        <h1><a class="plain" href="https://zimjs.com/base.html"><img id="topIcon" src="base_icon.png" alt="ZIM BASE - Database Simplified"></a>ZIM BASE - Database Simplified</h1>
        <p>ZIM Base lets you easily query MySQL database tables with PHP.
            <br>It runs MySQLi prepared statements for security at about 1/3 the size of MySQLi.
            <br>Parameters are in <em style="font-family:verdana; background-color:#eeeeee; padding-left:5px; padding-right:5px; margin-bottom:0px;">(light)</em>, commands are in <font color=#a00>red</font>, secondary commands are in <em style=" padding-left:5px; padding-right:5px; margin-bottom:0px;">grey</em>.
            <br>These are followed by ZIM Base result properties where applicable.
            <br><br>Get the <a href="https://zimjs.com/base.zip">ZIP&nbsp;FILE</a>
        </p>
<?php


// EMULATING DATA COMING IN
// You can collect whatever variables you want and still use ZIM Base.
// In which case, you would not have hard-coded variables like below.
// This example emulates data coming from ZIM Bind (more on this down below).
// Toggle between "get" and "post" by setting the value below
// do not change anything else - just the value.

$_GET["type"] = "get"; // toggle value to "get" or "post"

$_GET["data"] = "my GET content";
$_GET["extra"] = 123;

$_POST["data"] = "my POST content";
$_POST["extra"] = 999;


// ZIM BASE
// Import ZIM Base which connects to database
// and provides easy database queries on the variable $base.
// This file includes your server and database access settings.
// A specific database can be specified here if desired:
// $database = "database_name";

require_once('zim_base.php');

// ZIM
// https://zimjs.com - JavaScript canvas framework - code creativity!
// ZIM Base can be used with or without ZIM.
// Setting $zim to false will prevent the making of a half dozen global variables
// that ZIM uses to handle binding and reply headers for async calls.
// These are harmless - but if never using ZIM, set this to false.
// See inside the ZIM_Base class for more information on the following globals:
// ZIM GLOBALS: $type, $master, $data, $command, $extra, $lock, $unique

// See https://codepen.io/danzen/pen/oNjgMNX - for an example using ZIM
// See the hero.php in the zim_base.zip for the backend for this example
// See https://zimjs.com/docs.html?item=Bind for Bind() docs in ZIM
// See https://zimjs.com/docs.html?item=async for async() docs in ZIM
// See https://zimjs.com/docs.html?item=Ajax for Ajax() docs in ZIM

// THIS EXAMPLE
// In this example we will emulate ZIM
// but we are acutally just outputing HTML rather than sending data back to ZIM.
// We will leave the default $zim which is true.
// If you never use ZIM then you can set this to false in the zim_bind.php file
// or override the setting here.

// $zim = false;

// ZIM Bind will send a GET variable called type
// this will have a value of "get" or "post"
// ZIM_Base reads that in automatically.
// We have collected sample GET or POST data up above.
// See the hero.php code for a real example with ZIM Bind.
// REMEMBER:
// ZIM Base works with any variables - with or without ZIM.
// This example is emulating ZIM Bind results.

// ZIM Bind passes extra information as a variable called extra
// Usually this is an id (but it is up to you)
// matching the variable name to our database field name makes it easier:
$id = $extra;
echo "<div class=bar>CONNECT</div>";
echo "<span>require_once('zim_base.php');</span><br>";
if ($base->error) {echo "error connecting"; exit;}
echo "<em>if (\$base->error) {echo \"error connecting\"; exit;}</em><br>";


// VARIABLES

echo "<div class=bar>VARIABLES - (name1, name2, etc.)</div>";
echo "<span>\$base->makeVars(\"id\", \"data\");</span><br>";
echo "This method makes global variables from GET or POST.<br>";
echo "Note: if using ZIM Bind see \$base->simplify() in zim_bind.php internal docs<br>";
echo "In this case we have:<br>";
echo "\$id: \"$id\"<br>";
echo "\$data: \"$data\"<br>";


// TABLE
// Use PHPMyAdmin for instance to
// create a table in your database called zim_base
// set an id field type int and primary key
// set a data field type text

// INSERT
// this will add if id is not taken
// this will NOT add if id is taken and -1 will be returned for affected_rows
$result = $base->insert("zim_base", ["id"=>$id, "data"=>$data]);


echo "<div class=bar>INSERT - (table, variables, update, where, more)</div>";
echo "<span>\$result = \$base->insert(\"zim_base\", [\"id\"=>\$id, \"data\"=>\$data]);<br>";
echo "\$result = \$base->insert(\"zim_base\", [\"id\"=>\$id, \"data\"=>\$data, \"date\"=>\"NOW()\"]);</span> // if date<br>";
echo "<em>if (\$result->error || \$result->affected_rows < 1) {echo \"error\"; exit;}</em><br>";
echo "\$result->query: $result->query // for the non-date command above<br>";
echo "\$result->values: ".join(", ", $result->values)." (values used for the ? above)<br>";
echo "\$result->types: ".join("", $result->types)." (i for integer, s for string - types used for the ? above)<br>";
echo "\$result->success: $result->success<br>"; // 1 if success false (blank) if not
echo "\$result->error: $result->error<br>"; // 1 if error false (blank) if not
echo "\$result->affected_rows: $result->affected_rows (1 if new, 2 if updated, 0 if repeat update, -1 if unsuccessful)<br>";

// INSERT OR UPDATE
// this will insert of id is not taken
// but will update if the id is taken - yay - we use this alot
// the second array is what to update as we do not always want to update everything
// note the 0 for affected_rows if it is an update
$result = $base->insert("zim_base", ["id"=>$id, "data"=>$data], ["data"=>$data]);

echo "<div class=bar>INSERT > UPDATE - (table, variables, update, where, more)</div>";
echo "<span>\$result = \$base->insert(\"zim_base\", [\"id\"=>\$id, \"data\"=>\$data], [\"data\"=>\$data]);</span><br>";
echo "<em>if (\$result->error || \$result->affected_rows < 0) {echo \"error\"; exit;}</em><br>";
echo "\$result->query: $result->query<br>";
echo "\$result->values: ".join(", ", $result->values)." (values used for the ? above)<br>";
echo "\$result->types: ".join("", $result->types)." (i for integer, s for string - types used for the ? above)<br>";
echo "\$result->success: $result->success<br>"; // 1 if success false (blank) if not
echo "\$result->error: $result->error<br>"; // 1 if error false (blank) if not
echo "\$result->affected_rows: $result->affected_rows (1 if new, 2 if updated, 0 if repeat update, -1 if unsuccessful)<br>";

// UPDATE
// this will update a record based on a where clause
// the first array is what to update
// the second array is the where clause
$result = $base->update("zim_base", ["data"=>"Client's new Data"], ["id"=>$id]);


echo "<div class=bar>UPDATE - (table, update, where, more)</div>";
echo "<span>\$result = \$base->update(\"zim_base\", [\"data\"=>\"Client's new Data\"], [\"id\"=>\$id]);<br>";
echo "\$result = \$base->update(\"zim_base\", [\"data\"=>\"increased score\", \"score\"=>\"\\score+1\"], [\"id\"=>\$id]);</span> // \ to escape binding<br>";
echo "<em>if (\$result->error || \$result->affected_rows < 1) {echo \"error\"; exit;}</em><br>";
echo "\$result->query: $result->query<br>";
echo "\$result->values: ".join(", ", $result->values)." (values used for the ? above)<br>";
echo "\$result->types: ".join("", $result->types)." (i for integer, s for string - types used for the ? above)<br>";
echo "\$result->success: $result->success<br>"; // 1 if success false (blank) if not
echo "\$result->error: $result->error<br>"; // 1 if error false (blank) if not
echo "\$result->affected_rows: $result->affected_rows<br>"; // 1 if new, 0 if update, -1 if unsuccessful

// SELECT
$result = $base->select("zim_base", ["id", "data"], ["id"=>$id]);

echo "<div class=bar>SELECT > SINGLE - (table, fields, where, more)</div>";
echo "<span>\$result = \$base->select(\"zim_base\", [\"id\", \"data\"], [\"id\"=>\$id]);<br>";
echo "\$result = \$base->select(\"zim_base\", \"*\", [\"id\"=>\$id]);</span><br>";
?>
<em>if ($result->error || $result->num_rows < 1) {echo "error"; exit;}<br>
$record = $result->record;</em><br>
<em>if ($result->success && $result->num_rows > 0) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;$record = $result->record;<br>
&nbsp;&nbsp;&nbsp;&nbsp;echo $record["data"];<br>
}
</em><br>
<em>if ($result->error || $result->num_rows < 1) {echo "error"; exit;}<br>
$row = $result->row;</em>
</em><br>
<em>if ($result->success && $result->num_rows > 0) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;$row = $result->row;<br>
&nbsp;&nbsp;&nbsp;&nbsp;echo $row[1];<br>
}<br>
</em><br>
<?php
echo "\$result->query: $result->query<br>";
echo "\$result->values: ".join(", ", $result->values)." (values used for the ? above)<br>";
echo "\$result->types: ".join("", $result->types)." (i for integer, s for string - types used for the ? above)<br>";
echo "\$result->success: $result->success<br>"; // 1 if success false (blank) if not
echo "\$result->error: $result->error<br>"; // 1 if error false (blank) if not
echo "\$result->num_rows: $result->num_rows<br>"; // number of rows selected
echo "\$result->metadata->field_count: ".$result->metadata->field_count."<br>";
echo "\$result->metadata->fetch_field()->name: ".  $result->metadata->fetch_field()->name ."<br>";
echo "\$result->metadata->fetch_field()->name: ".  $result->metadata->fetch_field()->name ."<br>";
echo "\$result->record - the first record as an associative array with field name and value:";

echo "<pre>";
print_r($result->record);
echo "</pre>";

echo "\$result->row - the first record as an array of data:";
echo "<pre>";
print_r($result->row);
echo "</pre>";

echo "\$result->json - first field value - assumes single-field JSON data:";
echo "<pre>";
print_r($result->json);
echo "</pre>";

echo "\$result->json_array - decodes json first fields and encodes array of their values:";
echo "<pre>";
print_r($result->json_array);
echo "</pre>";

echo "\$result->assoc - an array of records each as an associative array with field name and value:";
echo "<pre>";
print_r($result->assoc);
echo "</pre>";

echo "\$result->array - an array of records each as an array with field values:";
echo "<pre>";
print_r($result->array);
echo "</pre>";

// SELECT ALL
$result = $base->select("zim_base");

echo "<div class=bar>SELECT > MULTIPLE - (table, fields, where, more)</div>";
echo "<span>\$result = \$base->select(\"zim_base\", \"*\", [\"status\"=>\"1\"]);<br>";
echo "\$result = \$base->select(\"zim_base\", [\"id\", \"data\"], [\"data\"=>[\"NOT\", \"=\", \"\"]], \"ORDER BY id\");<br>";
echo "\$result = \$base->select(\"zim_base\", [\"id\", \"data\"], [\"data\"=>[\"OR\", null, [\"option 1\",\"option 2\",\"option 3\"]]], \"ORDER BY id\");<br>";
echo "\$result = \$base->select(\"zim_base\", [\"data\", \"COUNT(*)\"], [\"id\"=>[null, \">\" 100]], \"GROUP BY data\"); <font color=#333>// then use \$record[\"COUNT(*)\"]</font><br>";
echo "\$result = \$base->select(\"zim_base\", \"*\", [\"status\"=>\"1\"], \"AND custom='override'\");<br>";
echo "\$result = \$base->select(\"zim_base, zim_users\", \"*\", [\"zim_base.id\"=>\$id, \"zim_users.id\"=>\$id]); <font color=#333>// join</font><br>";
echo "\$result = \$base->select(\"zim_base\", [\"id\", \"data\"]);<br>";
echo "\$result = \$base->select(\"zim_base\");</span><br>";
?>
<em>
if ($result->error || $result->num_rows < 1) {echo "error"; exit;}<br>
foreach ($result->assoc as $record) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;echo $record["data"];<br>
}<br>
</em><br>
<em>
if ($result->success && $result->num_rows > 0) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;foreach ($result->assoc as $record) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;echo $record["data"];<br>
&nbsp;&nbsp;&nbsp;&nbsp;}<br>
}<br>
</em><br>
<em>
if ($result->error || $result->num_rows < 1) {echo "error"; exit;}<br>
foreach ($result->array as $row) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;echo $row[1];<br>
}<br>
</em><br>
<em>
if ($result->success && $result->num_rows > 0) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;foreach ($result->array as $row) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;echo $row[1];<br>
&nbsp;&nbsp;&nbsp;&nbsp;}<br>
}<br>
</em><br>

<?php
echo "\$result->query: $result->query<br>";
echo "\$result->values: ".join(", ", $result->values)." (values used for the ? above)<br>";
echo "\$result->types: ".join("", $result->types)." (i for integer, s for string - types used for the ? above)<br>";
echo "\$result->success: $result->success<br>"; // 1 if success false (blank) if not
echo "\$result->error: $result->error<br>"; // 1 if error false (blank) if not
echo "\$result->num_rows: $result->num_rows<br>"; // number of rows selected
echo "\$result->assoc:";
echo "<pre>";
print_r($result->assoc);
echo "</pre>";

echo "\$result->array:";
echo "<pre>";
print_r($result->array);
echo "</pre>";

echo "\$result->json_array: - all the records as JSON (assuming JSON is stored in single first field)";
echo "<pre>";
print_r($result->json_array);
echo "</pre>";

echo "\$result->json: - just the first record as JSON (assuming JSON is stored in single first field)";
echo "<pre>";
print_r($result->json);
echo "</pre>";

echo "\$result->record: - just the first record as associative array";
echo "<pre>";
print_r($result->record);
echo "</pre>";


// DELETE
$last_id = $result->assoc[$result->num_rows-1]["id"];
$result = $base->delete("zim_base", ["id"=>$last_id]);

echo "<div class=bar>DELETE - (table, where)</div>";
echo "<span>\$last_id = \$result->assoc[\$result->num_rows-1][\"id\"];<br>";
echo "\$result = \$base->delete(\"zim_base\", [\"id\"=>\$last_id]);</span><br>";
echo "<em>if (\$result->error || \$result->affected_rows < 1) {echo \"error\"; exit;}</em><br>";
echo "\$result->query: $result->query<br>";
echo "\$result->values: ".join(", ", $result->values)." (values used for the ? above)<br>";
echo "\$result->types: ".join("", $result->types)." (i for integer, s for string - types used for the ? above)<br>";
echo "\$result->success: $result->success<br>"; // 1 if success false (blank) if not
echo "\$result->error: $result->error<br>"; // 1 if error false (blank) if not
echo "\$result->affected_rows: $result->affected_rows<br>";

// QUERY
echo "<div class=bar>QUERY - (SQL)</div>";
echo "<span>\$result = \$base->query(\"TRUNCATE TABLE zim_base\");</span><br>";
echo "Not a prepared statement so no binding - and not really executed for this example<br>";
echo "\$result->query: TRUNCATE TABLE zim_base<br>";
echo "\$result->native: [original mysqli result of statement]<br>";
echo "\$result->success: 1<br>"; // 1 if success false (blank) if not
echo "\$result->error:<br>"; // 1 if error false (blank) if not


// REPLY
echo "<div class=bar>REPLY - (messageType, message)</div>";
echo "<span>\$base->reply(\"error\", \"cannot get data\"); <font color=#666666>// echoes JSON: {error:\"cannot get data\"} then exits</font><br>";
echo "\$base->reply(\"success\", \"data added\"); <font color=#666666>// echoes JSON: {success:\"data added\"} then exits</font><br>";
echo "\$base->reply(\"success - data added\"); <font color=#666666>// echoes String: \"success - data added\" then exits</font></span><br>";

// SETLOCK
echo "<div class=bar>SETLOCK - (table, id, lockid, idfield, lockfield)</div>";
echo "<span>\$base->setLock(\"zim_base\", \$id, \$lockid);</span><br>";
echo "Assuming table has id and lockid fields - this will enforce record locking:<br>";
echo "<em>if (\$lockid != \"\") \$base->setLock(\"zim_base\", \$id, \$lockid);</em><br>";

?>

<br><br>
<a class="plain" href="https://zimjs.com" target=_blank><img id="bottomIcon" src="base_icon.png" alt="ZIM BASE - easy MySQLi"></a>
<br>
<footer><a href="https://zimjs.com" target=_blank>zimjs.com</a></footer>
</body>
</html>
