import java.sql.SQLException;

public class Main {
    public static void main(String[] args) {
        try (var connection = SQLServerConnection.connect()) {
            var authorDB = new AuthorDB(connection);

            // find author by Id
            var author = authorDB.findById(-1);
            System.out.println(author);

        } catch (SQLException | DBException e) {
            System.err.println(e.getMessage());
        }
    }
}