# Local Synchro 2.0
# (c) 2007-2014 By Kim Haskell
# www.scriptol.com

include "path.sol"
include "filecopy.js"   // for js only

boolean DISPLAY = false
boolean VERBOSE = false
int counter

boolean filecompare(text a, text b)
	array x, y
	x.load(a)
	y.load(b)
return x = y	

void filecopy(text a, text b)
	print a, "copied in", b
	if DISPLAY = true return
	copy(a, b)
	counter + 1
return

boolean identical(text a, text b)
	if not file_exists(b) return false
	if filesize(a) <> filesize(b) return false
return filecompare(a, b)

void synchro(text source, text sync)

	array content = scanDir(source)
	text a, b, c
	boolean any = false
	
	if not file_exists(sync) 
		if VERBOSE or DISPLAY print "CREATED $sync"
		if not DISPLAY let mkdir(sync)
		any = true
	/if	
	
	if content.empty() return
	
	// processing files
	
	for text name in content
		a = Path.merge(source, name)
		if DISPLAY or VERBOSE	print "Processing $a"
		if filetype(a) = "file"
			b = Path.merge(sync, name)
			if any = true
				filecopy(a, b)
				continue
			/if
			if identical(a, b) = false
				filecopy(a, b)
			/if
		/if
	/for

	// processing subdirs
	
	for text name in content
    if name[0]="." continue
		a = Path.merge(source, name)	
		if filetype(a) = "dir"
			synchro(a, Path.merge(sync, name))
		/if
	/for	


return


void usage()
	print
	print "Local Synchro - Scriptol.com"
	print "----------------------------"
	print "Syntax:"
	print "  synchro [-d | -v] sourcedir syncdir"
	print "Options:"
	print "  -d display only, do nothing."
	print "  -v verbose, display more infos."
	print "Arguments:"
	print "  1 sourcedir: a directory to backup"
	print "  2 syncdir: must be synchronized with the source"
	exit(0)
return


int main(int argc, array argv)

	if argc < 3 
		usage()
	/if	

	text source, sync
	for text opt in argv[ 1 .. ]
		if opt[ .. 1] = "-d" 
			DISPLAY = true
			continue
		/if	
		if opt[ .. 1] = "-v" 
			VERBOSE = true
			continue
		/if	
		
		if opt[0] = "-" let usage()
		
		if source = nil
			source = opt
		else
			if sync = nil
				sync = opt
			else
				usage()
			/if
		/if	
	/for		
	
	print "Synchronizing from $source to $sync"
	synchro(source, sync)
	print text(counter) + " files copied."

return 0

main($argc, $argv)