<?php
// Local Synchro 2.0
// (c) 2007-2014 By Kim Haskell
// www.scriptol.com
include_once("path.php");

$DISPLAY=false;
$VERBOSE=false;
$counter=0;
function filecompare($a,$b)
{
   $x=array();
   $y=array();
   $x=file($a);
   $y=file($b);
   return $x ==$y;
}

function filecopy($a,$b)
{
   echo $a, " ", "copied in", " ", $b, "\n";
   global $DISPLAY;
   if($DISPLAY===true)
   {
      return;
   }
   copy($a,$b);
   global $counter;
   $counter+=1;
   return;
}

function identical($a,$b)
{
   if(!file_exists($b))
   {
      return false;
   }
   if(filesize($a)!=filesize($b))
   {
      return false;
   }
   return filecompare($a,$b);
}

function synchro($source,$sync)
{
   $content=scandir($source);
   $a="";
   $b="";
   $c="";
   $any=false;
   if(!file_exists($sync))
   {
      global $VERBOSE;
      global $DISPLAY;
      if($VERBOSE||$DISPLAY)
      {
         echo "CREATED $sync", "\n";
      }
      if(!$DISPLAY)
      {
         mkdir($sync);
      }
      $any=true;
   }
   if(empty($content))
   {
      return;
   }
   foreach($content as $name)
   {
      $a=Path::merge($source,$name);
      global $DISPLAY;
      global $VERBOSE;
      if($DISPLAY||$VERBOSE)
      {
         echo "Processing $a", "\n";
      }
      if(filetype($a)==="file")
      {
         $b=Path::merge($sync,$name);
         if($any===true)
         {
            filecopy($a,$b);
            continue;
         }
         if(identical($a,$b)===false)
         {
            filecopy($a,$b);
         }
      }
   }
   foreach($content as $name)
   {
      if($name{0}===".")
      {
         continue;
      }
      $a=Path::merge($source,$name);
      if(filetype($a)==="dir")
      {
         synchro($a,Path::merge($sync,$name));
      }
   }
   return;
}

function usage()
{
   echo "\n";
   echo "Local Synchro - Scriptol.com", "\n";
   echo "----------------------------", "\n";
   echo "Syntax:", "\n";
   echo "  synchro [-d | -v] sourcedir syncdir", "\n";
   echo "Options:", "\n";
   echo "  -d display only, do nothing.", "\n";
   echo "  -v verbose, display more infos.", "\n";
   echo "Arguments:", "\n";
   echo "  1 sourcedir: a directory to backup", "\n";
   echo "  2 syncdir: must be synchronized with the source", "\n";
   exit(0);
   return;
}

function main($argc,$argv)
{
   if($argc<3)
   {
      usage();
   }
   $source="";
   $sync="";
   foreach(array_slice($argv,1) as $opt)
   {
      if(substr($opt,0,2)==="-d")
      {
         global $DISPLAY;
         $DISPLAY=true;
         continue;
      }
      if(substr($opt,0,2)==="-v")
      {
         global $VERBOSE;
         $VERBOSE=true;
         continue;
      }
      if($opt{0}==="-")
      {
         usage();
      }
      if($source==="")
      {
         $source=$opt;
      }
      else
      {
         if($sync==="")
         {
            $sync=$opt;
         }
         else
         {
            usage();
         }
      }
   }
   echo "Synchronizing from $source to $sync", "\n";
   synchro($source,$sync);
   global $counter;
   echo strval($counter)." files copied.", "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
