# Double Synchro 1.3
# (c) 2007-2014 By Kim Haskell
# www.scriptol.com


include "path.sol"


boolean DISPLAY = false
boolean VERBOSE = false
boolean UPDATE = false
int counter

boolean filecompare(text a, text b)
	array x, y
	x.load(a)
	y.load(b)
return x = y	

void filecopy(text a, text b, text c)
	print a, "copied in", b, "and", c
	if DISPLAY = true return
	copy(a, b)
	copy(a, c)
	counter + 1
return

boolean identical(text a, text b)
	if not file_exists(b) return false
	if filesize(a) <> filesize(b) return false
return filecompare(a, b)

void clearDir(text x)
	array y = scanDir(x)
	for text t in y
		text z = Path.merge(x, t)
		if filetype(z) = "file" let unlink(z)
	/for	
return

void synchro(text source, text sync, text diff)

	array content = scanDir(source)
	text a, b, c
	boolean any = false
	
	if not file_exists(sync) 
		if VERBOSE or DISPLAY print "CREATED $sync"
		if not DISPLAY let mkdir(sync)
		any = true
	/if	
	
	if not file_exists(diff) 	
		if VERBOSE or DISPLAY print "CREATED $diff"
		if not DISPLAY let mkdir(diff)
	else
		if not UPDATE
			clearDir(diff)	// don't upload content again
		/if	
	/if		
	
	if content.empty() return
	// processing files
	
	for text name in content
		a = Path.merge(source, name)
		if DISPLAY or VERBOSE	print "Processing $a"
		if filetype(a) = "file"
			b = Path.merge(sync, name)
			//print "IDENT $a $b =", identical(a, b) = false
			if any = true
				filecopy(a, b, Path.merge(diff, name))
				continue
			/if
			if identical(a, b) = false
				filecopy(a, b, Path.merge(diff, name))
			/if
		/if
	/for

	// processing subdirs
	
	for text name in content
		a = Path.merge(source, name)	
		if filetype(a) = "dir"
			synchro(a, Path.merge(sync, name), Path.merge(diff, name))
		/if
	/for	


return


void usage()
	print
	print "Double Synchro - Scriptol.com"
	print "-----------------------------"
	print "Syntax:"
	print "  dsyn [-d | -v] sourcedir syncdir diffdir"
	print "Options:"
	print "  -d display only, do nothing."
	print "  -v verbose, display more infos."
	print "  -u update, don't delete target files."
	print "Arguments:"
	print "  1 sourcedir: a directory to backup"
	print "  2 syncdir: must be synchronized with the source"
	print "  3 diffdir: will store the differences."
	exit(0)
return


int main(int argc, array argv)

	if argc < 4 
		usage()
	/if	
	
	text source, diff, sync
	
		
	for text opt in argv[ 1 .. ]
		if opt[ .. 1] 
		= "-d" 
			DISPLAY = true
			continue
		= "-v" 
			VERBOSE = true
			continue
		= "-u"
			UPDATE = true
			continue
		/if	
		
		if opt[0] = "-" let usage()
		
		if source = nil
			source = opt
		else
			if sync = nil
				sync = opt
			else
				if diff = nil
					diff = opt
				else
					usage()
				/if	
			/if
		/if	
	/for		
	
	print "Synchronizing from $source to $sync and $diff"
	synchro(source, sync, diff)
	print counter, "files copied."

return 0

main($argc, $argv)