<?php
// Double Synchro 1.3
// (c) 2007-2014 By Kim Haskell
// www.scriptol.com
include_once("path.php");
$DISPLAY=false;
$VERBOSE=false;
$UPDATE=false;
$counter=0;
function filecompare($a,$b)
{
   $x=array();
   $y=array();
   $x=file($a);
   $y=file($b);
   return $x ==$y;
}

function filecopy($a,$b,$c)
{
   echo $a, " ", "copied in", " ", $b, " ", "and", " ", $c, "\n";
   global $DISPLAY;
   if($DISPLAY===true)
   {
      return;
   }
   copy($a,$b);
   copy($a,$c);
   global $counter;
   $counter+=1;
   return;
}

function identical($a,$b)
{
   if(!file_exists($b))
   {
      return false;
   }
   if(filesize($a)!=filesize($b))
   {
      return false;
   }
   return filecompare($a,$b);
}

function clearDir($x)
{
   $y=scandir($x);
   foreach($y as $t)
   {
      $z=Path::merge($x,$t);
      if(filetype($z)==="file")
      {
         unlink($z);
      }
   }
   return;
}

function synchro($source,$sync,$diff)
{
   $content=scandir($source);
   $a="";
   $b="";
   $c="";
   $any=false;
   if(!file_exists($sync))
   {
      global $VERBOSE;
      global $DISPLAY;
      if($VERBOSE||$DISPLAY)
      {
         echo "CREATED $sync", "\n";
      }
      if(!$DISPLAY)
      {
         mkdir($sync);
      }
      $any=true;
   }
   if(!file_exists($diff))
   {
      global $VERBOSE;
      global $DISPLAY;
      if($VERBOSE||$DISPLAY)
      {
         echo "CREATED $diff", "\n";
      }
      if(!$DISPLAY)
      {
         mkdir($diff);
      }
   }
   else
   {
      global $UPDATE;
      if(!$UPDATE)
      {
         clearDir($diff);
      }
   }
   if(empty($content))
   {
      return;
   }
   foreach($content as $name)
   {
      $a=Path::merge($source,$name);
      global $DISPLAY;
      global $VERBOSE;
      if($DISPLAY||$VERBOSE)
      {
         echo "Processing $a", "\n";
      }
      if(filetype($a)==="file")
      {
         $b=Path::merge($sync,$name);

         if($any===true)
         {
            filecopy($a,$b,Path::merge($diff,$name));
            continue;
         }
         if(identical($a,$b)===false)
         {
            filecopy($a,$b,Path::merge($diff,$name));
         }
      }
   }
   foreach($content as $name)
   {
      $a=Path::merge($source,$name);
      if(filetype($a)==="dir")
      {
         synchro($a,Path::merge($sync,$name),Path::merge($diff,$name));
      }
   }
   return;
}

function usage()
{
   echo "\n";
   echo "Double Synchro - Scriptol.com", "\n";
   echo "-----------------------------", "\n";
   echo "Syntax:", "\n";
   echo "  dsyn [-d | -v] sourcedir syncdir diffdir", "\n";
   echo "Options:", "\n";
   echo "  -d display only, do nothing.", "\n";
   echo "  -v verbose, display more infos.", "\n";
   echo "  -u update, don't delete target files.", "\n";
   echo "Arguments:", "\n";
   echo "  1 sourcedir: a directory to backup", "\n";
   echo "  2 syncdir: must be synchronized with the source", "\n";
   echo "  3 diffdir: will store the differences.", "\n";
   exit(0);
   return;
}

function main($argc,$argv)
{
   if($argc<4)
   {
      usage();
   }
   $source="";
   $diff="";
   $sync="";
   foreach(array_slice($argv,1) as $opt)
   {
      
      $_I1=substr($opt,0,2);
      if($_I1==="-d")
      {
         global $DISPLAY;
         $DISPLAY=true;
         continue;
      }
      else
      {
         if($_I1==="-v")
         {
            global $VERBOSE;
            $VERBOSE=true;
            continue;
         }
      else
      {
         if($_I1==="-u")
         {
            global $UPDATE;
            $UPDATE=true;
            continue;
         }
      }}
      if($opt{0}==="-")
      {
         usage();
      }
      if($source==="")
      {
         $source=$opt;
      }
      else
      {
         if($sync==="")
         {
            $sync=$opt;
         }
         else
         {
            if($diff==="")
            {
               $diff=$opt;
            }
            else
            {
               usage();
            }
         }
      }
   }
   echo "Synchronizing from $source to $sync and $diff", "\n";
   synchro($source,$sync,$diff);
   global $counter;
   echo $counter, " ", "files copied.", "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
