

include "libphp.sol"
include "path.sol"



/**
 *	Change Extension
 *	Builds a list of object files from the list if sources,
 *	by changing the last extension
 *	and puts this list into an array and into a text.
 *	Returns the new list both as array and string. 
 */   

array, text changeExtensions(array sources, text extension, boolean keepath)
	text objString = ""
	array objects = {}
   
	for text x in sources
		x = x.trim()
		if x = "" continue		
        if extension <> nil
    		if not keepath
	       	  text pth
		      pth, x = Path.splitFile(x)
		    /if
            x = Path.changeExt(x, extension)
        /if    
		objects.push(x) 
		objString + x
		objString + " "
	/for  

return objects, objString.rtrim()

/*
	Content To Array
	Puts a list of files, stored inside a tag, into an array,
	and changes extension if required.
*/	

array contentToArray(text content, text extension)

	array newlist = {}
	
	array innerlist = content.split("\n")         //convert text to array

	for text name in innerlist
		name = name.trim()                  // remove blanks and linefeeds
		if name = "" continue
		if extension <> nil 
			name = Path.changeExt(name, extension)    // change extension
		/if  
        newlist.push(name) 
	/for
 
return newlist		


/**
 *	Extract Name
 *	get the name of a variable inside a command and a replacing extension
 *	input: 	the command, 
 *			the first position in the command
 *	output:	the name
 *			the replacing extension if one
 *			the now position in the string   
 *	  
 */  

text, int, text extractName(text program, int start)
	text name
	text ext = ""
	int pos = start

	while program[pos] not in " ;+-*[<,\t\n" let pos + 1
	name = program[start -- pos]
    //print "EXTRACT ($name) ($pos)", program[pos], program[pos - 1], program	
	if program[pos] = "["
		start = pos + 1
		while program[pos] not in " ]" let pos + 1
		ext = program[start -- pos]
		pos + 1
	/if	

return name, pos - 1, ext		

/**
 *	Purge
 *	remove spaces, tags, EOL codes.
 */	  

text purge(text content)
	array x = content.split(" \t\n")
return x.join(" ")	
		

text prettyDate(text iso)
	text d = iso[ .. 9]
	text h = iso[11 .. 12]
	text m = iso[14.. 15]
	text s = iso[17..18]
return d + " " + h + "h " + m + "m " + s + "s"	 
