/**
 *	Smklib.sol - (c) Kim Haskell
 *  http://www.scriptol.com/
 *
 *  Freeware under the GNU GPL 2.0 Licence.
 *	FUNCTIONS
 */	 


include "path.sol"

boolean VERBOSE		// Display more messages.
boolean SILENT		// No display.
boolean DEBUG		// Display infos for debugging purpose.
boolean BUILDALL	// Build all, compile all sources.

enum STATE_COMPILED, STATE_UNCOMPILED 

/**
 *	Ext List
 *	Recognized extensions of header files,
 *	and corresponding extensions of source files.
 */	   

dict extList = {".h":".c", ".hpp":".cpp", ".hxx":".cxx" }

/**
 *	Build Date
 *	Last build date, as a number.
 */
number buildDate

/**
 *	Source List
 *	List of sources to compile
 *	and associated compiled flags. 
 */
 
array sourceList
dict compiledList	  

void feedback(text t)
	if VERBOSE or DEBUG	print t
return	


/**
 *	Get Included
 *	Extract the file path from an include statement
 *	the start integer must slip the "include" keyword
 */	  

text getIncluded(text statement, int start)

	text str = statement[ start .. ]

	// remove spaces and trailing semi-colon
	str = trim(str)
	if str[ -1 ..] = ";" let str = str[ .. -1]

	if str[0] in "(_" return "";     // a PHP function
 	
 	// remove quotes
 	text c = str[0]
 	if (c = "\"") or (c = '<') or (c = "\'")
     int l = strlen(str) - 2
		 str = str[1 .. l]	// remove first and last chars
	/if	 

 	// test if the file exists
 	if DEBUG
	   if not file_exists(str)
	       print str, "source not found."
	   /if
	/if   

return str


/**
 *	Newer
 *	Check if the file is newer than last build
 *	Output: a boolean value, true if newer  
 */
 
boolean newer(number fdate)
	if BUILDALL return true
	if fdate > buildDate return true
return false	
 	 
number parseFile(text fname)

	array source
	text ext
	number fdate		// time of current file
	number bestDate		// newer date
	int pos
	text iname
		
	fname = trim(fname)	
	if fname = nil return 0
	if DEBUG print "Parsing", fname	
	if @in_array(fname, sourceList) return buildDate
	if not file_exists(fname)
		print fname, "no found" 
		return buildDate
	/if	

	source.load(fname)
	
	for text line in source
		if line[ ..7] <> "#include" continue
		iname = getIncluded(line, pos + 8)
	
		if iname = "" continue
		if iname in sourceList continue
		ext = Path.getExtension(iname)
        if ext.trim() = nil continue
		if extList[ext] <> nil	// extension of header in list or valid extensions
			iname = Path.changeExt(iname, extList[ext])	// replace by ext of source
		else
			if ext not in extList continue	
		/if
		if iname = fname continue	
		if @file_exists(iname)
			fdate = parseFile(iname)
			if fdate > bestDate
				bestDate = fdate
			/if
		/if			
	/for
	
	fdate = @filetime(fname)
	if fdate > bestDate
		bestDate = fdate
	else
		fdate = bestDate	// must return the bestdate	
	/if
	
	sourceList.push(fname)

	if newer(bestDate)
		compiledList[fname] = STATE_UNCOMPILED
	else
		compiledList[fname] = STATE_COMPILED	
	/if			 
	
	//sourceList.display()

return fdate	


/**
 *	Parse List
 */	 

array parseList(array lst)
	sourceList = {}
	
	for text t in lst
		parseFile(t)
	/for
	
return sourceList	


/**
 *	Is Source
 *	Check a file to be removed of the list, because:
 *	1) it is a source file, according to its extension
 *	2) it is already compiled, according to the flag  
 */
 
boolean isRemoved(text fname)
	if Path.getExtension(fname) not in extList
		return false
	/if
	
return compiledList[trim(fname)] = STATE_COMPILED		   

/**
 *	Remove Compiled
 *	Rebuild the list of file,
 *	removed already compiled sources
 */
 
array removeCompiled(array a)
	array b
	for text t in a
	    if trim(t) = nil continue
		if DEBUG
			print t, "removed=", isRemoved(t)
		/if	
		if isRemoved(t) continue
		b.push(t)
	/for
return b		 	     

