<?php

include_once("path.php");
$VERBOSE=0;
$SILENT=0;
$DEBUG=0;
$BUILDALL=0;
$extList=array(".h"=>".c",".hpp"=>".cpp",".hxx"=>".cxx");
$buildDate=0;
$sourceList=array();
$compiledList=array();
function feedback($t)
{
   global $VERBOSE;
   global $DEBUG;
   if($VERBOSE||$DEBUG)
   {
      echo $t, "\n";
   }
   return;
}

function getIncluded($statement,$start)
{
   $str=substr($statement,$start);
   $str=trim($str);
   if(substr($str,-1)===";")
   {
      $str=substr($str,0);
   }
   if(strstr("(_",$str{0}))
   {
      return "";
   }
   $c=$str{0};
   if(($c==='"')||($c==="<")||($c==="'"))
   {
      $str=substr($str,1,-1);
   }
   global $DEBUG;
   if($DEBUG)
   {
      if(!file_exists($str))
      {
         echo $str, " ", "source not found.", "\n";
      }
   }
   return $str;
}

function newer($fdate)
{
   global $BUILDALL;
   if($BUILDALL)
   {
      return true;
   }
   global $buildDate;
   if($fdate>$buildDate)
   {
      return true;
   }
   return false;
}

function parseFile($fname)
{
   $source=array();
   $ext="";
   $fdate=0;
   $bestDate=0;
   $pos=0;
   $iname="";
   $fname=trim($fname);
   if($fname ==false)
   {
      return 0;
   }
   global $DEBUG;
   if($DEBUG)
   {
      echo "Parsing", " ", $fname, "\n";
   }
   global $sourceList;
   if(@in_array($fname,$sourceList))
   {
      global $buildDate;
      return $buildDate;
   }
   if(!file_exists($fname))
   {
      echo $fname, " ", "no found", "\n";
      global $buildDate;
      return $buildDate;
   }
   $source=file($fname);
   reset($source);
   do
   {
      $line= current($source);
      if(substr($line,0,8)!="#include")
      {
         continue;
      }
      $iname=getIncluded($line,$pos+8);

      if($iname==="")
      {
         continue;
      }
      if(in_array($iname,$sourceList))
      {
         continue;
      }
      $ext=Path::getExtension($iname);
      if(trim($ext) ==false)
      {
         continue;
      }
      global $extList;
      if($extList[$ext]!=false)
      {
         $iname=Path::changeExt($iname,$extList[$ext]);
      }
      else
      {
         if(!in_array($ext,$extList))
         {
            continue;
         }
      }
      if($iname===$fname)
      {
         continue;
      }
      if(@file_exists($iname))
      {
         $fdate=parseFile($iname);
         if($fdate>$bestDate)
         {
            $bestDate=$fdate;
         }
      }
   }
   while(!(next($source) === false));

   $fdate=@filemtime($fname);
   if($fdate>$bestDate)
   {
      $bestDate=$fdate;
   }
   else
   {
      $fdate=$bestDate;
   }
   array_push($sourceList,$fname);
   if(newer($bestDate))
   {
      global $compiledList;
      $compiledList[$fname]=1;
   }
   else
   {
      global $compiledList;
      $compiledList[$fname]=0;
   }
   return $fdate;
}

function parseList($lst)
{
   global $sourceList;
   $sourceList=array();

   reset($lst);
   do
   {
      $t= current($lst);
      parseFile($t);
   }
   while(!(next($lst) === false));

   return $sourceList;
}

function isRemoved($fname)
{
   global $extList;
   if(!in_array(Path::getExtension($fname),$extList))
   {
      return false;
   }
   global $compiledList;
   return $compiledList[trim($fname)]===0;
}

function removeCompiled($a)
{
   $b=array();
   reset($a);
   do
   {
      $t= current($a);
      if(trim($t) ==false)
      {
         continue;
      }
      global $DEBUG;
      if($DEBUG)
      {
         echo $t, " ", "removed=", " ", isRemoved($t), "\n";
      }
      if(isRemoved($t))
      {
         continue;
      }
      array_push($b,$t);
   }
   while(!(next($a) === false));

   return $b;
}


?>
