
/*****************************************************
 *    Speedy Make 
 *    (c) 2006-2014 by Kim Haskell &  Denis Sureau
 *	
 *    http://www.scriptol.com/
 *
 *    Freeware under the GNU GPL 2.0 Licence.
 *    Requirements: 
 *   - The Scriptol compiler to rebuild the executable.
 ******************************************************/
 

include "libphp.sol"
include "path.sol"
include "tools.sol"
include "smklib.sol"
include "dom.sol"

text makeName
DOMDocument make
array tagList
array sources
array objects
array actions

dict excludeList			// pair: exclude tag name and tag of list of files 		
array actionList
dict sourceLists
array commName
array commData
text sourcesString
text objectsString
text libsString
text upperAction = ""
int counter

xml deptree 
/xml

boolean NORUN 		// Test only.
boolean STOPFLAG	// Exit on first error encountered.
boolean KEEPATH      // No path for object file, stored in current dir

enum INTERNAL_COMMAND, EXTERNAL_PROGRAM

void howto()
	print "Speedy Make 2.0 (c) 2006-2014 Kim Haskell - Scriptol.com"
	print "Command:"
	print "  php smake.php [options]"
	print "  php smake.php [options] makefile.sm"
	print "Options:"
	print "  no option   use the default file makefile.sm"
	print "  -h          display this help."
	print "  -b          rebuild all sources."
	print "  -t          test the makefile, do not execute commands."
	print "  -i          interrupt, stop at first error."
	print "  -v          verbose, display more info."
	print "  -s          silent, do not print commands."
	print "  -p          keep path for object files."
	print "  -name=\"value\"  assign a value to the variable \"name\"."
	print "  -name       execute the action \"name\"."   
	exit(0)
return



/**
 *	Verify Files
 *	For each source file, check if it exists.
 */	 

int verifyFiles(text dirname)
	int count = 0
   
	for text t in sources
		if t.find(dirname) = nil let t = Path.merge(dirname, t)
		if not file_exists(t) 
			echo "\"",  t , "\"", " not found.\n"
			count + 1
		/if 
	/for	 
return count

/**
 * Tag Exists?
 * Return true if the tag exists
 */
 
 boolean tagExists(text name)
    DOMNodeList dnl = make.getElementsByTagName(name)
 return dnl.length > 0  


/**
 *	Get Content
 *	Returns content of a tag (usually the list of sources) as a text.
 */	 

text getContent(text name)
	text content

	DOMNodeList dnl = make.getElementsByTagName(name)
	DOMElement e = dnl.item(0)
    content = e.textContent
return content


/**
 *	Create List  
 *	For a tag that holds a list of files,
 *	gets the list of sources, puts it into an array.
 */	 

array createList(DOMElement xe)
	text data = xe.textContent    // get it from the dom
	array srcs = explode("\n", data)
	text srcString = data.trim()
	array newarr = {}
	scan srcs  
	   text x = srcs[].trim()
	   if x <> nil let newarr.push(x)
    /scan    
	sourceLists[xe.tagName] = newarr
return newarr


/**
 *	Get Tag Content
 *	Retrieve the content of a tag
 *	previously expanded with included files
 */
 
array getTagContent(text name)
	array clist

	DOMNodeList dnl = make.getElementsByTagName(name)
	DOMElement e = dnl.item(0)
    text content = e.textContent

    if content <> nil 
		clist = content.split("\n")
    /if	
 
return clist	    

/**
 *	Add Program
 *	Add a command to the list of programs to execute
 */	  

void addProgram(text prog)
	commName.push("run")
	commData.push(prog)
	//print "ADD PROG RUN", prog
return	


/**
 *	Subst Action
 *	replaces a variable by its content
 *	- by a list is the symbol is $
 *	- create a command for each element if the symbol is *
 */	    

		
void expandVariable(text program)
	array tokens
	text srcname
	text extension
	text objString
	int pos = 1
	int start
	int size = sources.size()
	int len = program.length()
	boolean flag = false	// set when variable has content or no variable used

	while pos <> 0
		pos = program.find("$")
		if pos = 0  
			pos = program.find("*", pos)
			if pos <> 0
				addProgram(program) 
				break
			/if	
			start = pos
			srcname, pos, extension = extractName(program, pos + 1)

			sources	= sourceLists[srcname]
			if sources = nil return
					
			if extension <> nil
				if sources.size() = 0	break	// nothing to do
				objects, objString = changeExtensions(sources, extension, KEEPATH)
			else
				sources = removeCompiled(sources)
				if sources.size() = 0	break	// nothing to do	
			/if
			for int i in 0 -- size
				text comm = program
				text name = objects[i]	
				comm [start .. pos] = name
				addProgram(program)
			/for	
			return	// only one subst of this kind allowed
		/if
		
		// A $ prefixed variable was found
			
		start = pos
		srcname, pos, extension = extractName(program, pos + 1)
		sources = getTagContent(srcname)	// return the content of the tag
		// if empty, nothing to insert, but continue

		if extension = nil		// original sources
			sources = removeCompiled(sources)
		/if
		
		objects, objString = changeExtensions(sources, extension, KEEPATH)
	
		// if replacement string empty, add the command anyway
         
		//if objString <> nil let flag = true
		program [start .. pos] = objString
 
		pos = program.find("$")
		if pos < 1
			addProgram(program)
		/if	
			
	/while		

return 


/**
 *	Process One Tag (action or variable)
 *	Builds a command from a tag
 *	Argument:
 *	- the tag to process
 */	

void parseOneTag(text name)
	array srcs
	text content
	int intag // number of file in the original tag
   
   	DOMNodeList dnl = make.getElementsByTagName(name)
   	if dnl.length = 0
   	    print name, "tag not found"
        return 
   	/if
   	
    DOMNode node = dnl.item(0)

    DOMElement xe = node
	text prog = xe.getAttribute("action")   
   
   	if prog	= null return

	text comm = xe.getAttribute("action")
	if DEBUG print "Parse", name, "for", comm
	if comm in { "parse", "build", "none", "" , "exclude"}
   		srcs = createList(xe)	// make an array of filesname from the content
   		intag = srcs.size()
   		echo intag, " file" , plural(srcs.size()), " in <", xe.tagName, ">\n"
   		//srcs.display()
   		if comm
		= "parse": 
		    array x = parseList(srcs)
			srcs  = srcs | parseList(srcs)	// add included files
			print srcs.size() - intag ,"included in the list"
		= "exclude":
			text target = xe.getAttribute("target")
			if target = nil
				print "Error, target required in", prog
			else	
				excludeList[target] = prog
				print srcs.size() ,"to exclude"
			/if	
		/if
		
   		//srcs.display()
   		content = srcs.join(" ")
   		xe.textContent = content
   		if DEBUG print "All sources:", xe.textContent
	   	
	/if   
   
	counter + 1
   
return



/**
 *	Parse Tags
 *	Parse the whole XML document.
 *	Process each tag according to the "action" attribute.
 */	  

void parseTags()
	
	if DEBUG print "Parse Tags"
	
	for text name in tagList
		parseOneTag(name)
	/for

	if counter = 0  print "Nothing to do..."
	
return


/**
 *	Exclude
 *	Parse the whole XML document.
 *	Process exclusion according to the list of sources and target
 */	  

void exclude()

	array sourceData
	array targetData
	DOMElement xes = null
	DOMElement xet = null
	
	if DEBUG print "Exclude"

	if excludeList.empty()
		feedback("No file to exclude...")
		return
	/if	
	
	for text source, text target in excludeList
   		if not tagExists(source) continue
   		if not tagExists(target) continue
		
		sourceData = contentToArray(xes.textContent, nil)
		if sourceData.size() = 0 continue
		targetData = contentToArray(xet.textContent, nil)
		if targetData.size() = 0 continue
		
		for text x in sourceData
			int pos = targetData.find(x)
			if pos <> nil let targetData[pos .. pos] = nil
		/for
   		text content = targetData.join(" ")
   		xet.textContent = content
   		
	/for

	
return


/**
 *	Make Internal Command
 *	Convert an XML action to command for the emake intepreter,
 *	push name of the command and body on the stack.
 */	

void makeInternalCommand(DOMElement xe)
	
	text comm = xe.getAttribute("action")
	text content = xe.textContent

	if comm 
	=	"display" :
		commName.push("display")
		commData.push(content)
	/if
	
return

/**
 *	Make External Program
 *	Convert an XML action to a system command
 *	add content to program name or
  */	

void makeExternalProgram(DOMElement xe)

	text content = xe.textContent
	text name = xe.tagName
	expandVariable(purge(content))

return



/**
 *	Build Command List
 *	Process dependencies of actions in the makefile, 
 *	recursively from the top to deeper ones.
 *	- if the tag is a terminal, build a command
 *	- else call the function with each item in the list  
 */   

void buildCommand(text actionName)
	array innerList
	text content
	text ename
	// action already in list
	if actionName in actionList return
	actionList.push(actionName)

	DOMNodeList dnl = make.getElementsByTagName(actionName)
    DOMElement currelem = dnl.item(0)
	
	if currelem = null
		print "Err", actionName, "tag not found."
		return 
	/if

	if DEBUG
		print currelem.tagName, "tag, attempting to make command:"
	/if	
	
	// check if the tag is a terminal
	
	if currelem.hasAttribute("action")
		text val = currelem.getAttribute("action") 
	    if DEBUG print "Terminal tag, action=", currelem.getAttribute("action")
		if val.compare("run") = 0
			makeExternalProgram(currelem)
			return
		/if
		makeInternalCommand(currelem)	
		return
	/if	
	
	// not a terminal, process the content

	if DEBUG print "Non terminal tag..."
	content = currelem.textContent
	innerList = contentToArray(content, "")
	if innerList.empty() return
	if DEBUG let innerList.display()

	for ename in innerList
		buildCommand(ename)
	/for		
	
	if DEBUG
		print "List of commands:"
		commData.display()	
	/if
	
	if  "run" not in commName
		print "No RUN action, nothing to do."
		exit(1)
	/if
   
return	
	
	
/**
 *	Process Binary
 *	Get the date of the file to build if exists
 *	else the date is zero.
 *	Assign the date to included.buildDate
 */    	
 
void processBinary(DOMElement xe)

	text prog = xe.textContent
	prog = prog.trim()
	buildDate = 0

	if BUILDALL = false
		if file_exists(prog)
			buildDate = filetime(prog) 
		/if
	/if

	if VERBOSE
		if buildDate = 0
			echo " - first build"
		else	
			text d = date("c", buildDate)
			echo " - last build "  + prettyDate(d)
		/if	
	/if			
	
return 
	
/**
 *	Get upper action, get dependencies,
 *	including variables in content (not in attributes)
 *	Take the content of each tag providing it is not terminal
 *	build a list of the content, add this list to a main list
 *	if the name of the tag is in this list, it is not upper
 *	returns:
 *	- candidates the list of all tags  
 */  

void getUpper()
	text ename
	text content
	array candidates = {}
	array localList = {}

	DOMNode node = null
    boolean bTag = false
	

   	DOMNodeList dnl = make.getElementsByTagName("makefile")
   	DOMElement currelem = dnl.item(0)
   	node = currelem
	
	text name = currelem.getAttribute("name")
	echo "Processing \"", name, "\" (", makeName, ")\n" 
    
	// parse the top XML level
	dnl = currelem.getElementsByTagName("*")
    if VERBOSE print dnl.length, "tags"
    
	if not node.hasChildNodes()
		print "Empty makefile..."
		exit(0)
	/if

	for int i in 0 -- dnl.length
        currelem = dnl.item(i)
        ename = currelem.tagName       // get the name
        if ename = nil continue
        
		if VERBOSE
			echo "* ", ename
		/if	
        		
		tagList.push(ename)

		// if internal command, skip it
		if currelem.hasAttribute("action")
			text cact = currelem.getAttribute("action") 
			if VERBOSE
				echo " (", cact, ")"
			/if	
			if cact = "build"
				processBinary(currelem)
				bTag = true 
			/if
			if VERBOSE print
			continue
		/if	
		
		if VERBOSE print

		// now processing a non-terminal tag

		candidates.push(ename)	// add element to list as already parsed
		content = currelem.textContent	// get content
		localList = contentToArray(content, "")	// build a list

		if localList.size() > 0
			if VERBOSE
			    int n = localList.size() 
				echo n, " tag", plural(n), " in ", currelem.tagName,"\n"
				if DEBUG		
					print "List of tags:"
					scan localList print localList[]
				/if	
			/if			
		else
			print "No action found."
		/if
				
		// scan this local list, if tag name already in main list
		// remove it 
		scan localList
			text item = localList[].toText()
			int index = candidates.find(item)
			if index <> nil
				candidates[index] = nil
			/if
		/scan
		
	/for

	if candidates.empty()
		print "No top action found, please create one..."
		exit(0)
	/if
	if candidates.size() > 1
		print "Several top actions found, please make only one..."
		scan candidates let print candidates[]
		exit(0)
	/if

	upperAction = candidates.pop()
	if VERBOSE
		print "Top action:", upperAction
	/if	

	if not bTag
		print "Error, no build action, nothing to build."
	/if

return


/**
 *	Test Conformity
 *	Check for the presence of one-letter tags that are forbidden.
 */	 

void testConformity()
	
	if VERBOSE	echo "Checking for conformity..."
	
	DOMNodeList dnl = make.getElementsByTagName("*")
	for int i in 0 -- dnl.length
	   DOMElement e = dnl.item(i)
	   text name = e.tagName
       if name.length() = 0 continue
	   if name.length() < 2
			print
			echo "\"", name, "\""
			print " only one letter is not a valid element name..."
			exit(0)
		/if
	/for
	feedback(" ok.")      
return



/**	
 *	Execute Commands
 *	Execute the list of commands
 *	in the array 
 */	 

void executeCommands()
	int res = 0
	text name
	text content
	text type
	
	scan commName, commData
		if commName[]
		= "display"
			text t = commData[]
			for text x in t
				if x = "\t" continue
				echo x
			/for	
			print
		
		= "run"
			if  NORUN return
            text comm = trim(commData[])
            comm = str_replace("\n", "", comm)
            comm = str_replace("  ", "", comm)
			int exres = exec(comm)
			res + exres
			if STOPFLAG
				if res <> 0 let die("Stopped on error.")
			/if	
		/if	
	/scan
	
	if res <> 0
		print "Errors encountered in external programs."
	/if		
return 

/**
 *	Main function
 */	 

int main(int argc, array argv)

	boolean PENDING = false    // Waiting for parameter completion.
	text name = ""
	text value = ""
	 
	BUILDALL = false 
	NORUN = false
	VERBOSE = false
	SILENT = false
	DEBUG = false
	STOPFLAG = false
    KEEPATH = false
	// Options at command line

	if argc > 1
		int i = 1
		while i < argc
			text temp = argv[i]
			//print temp
			if temp in {"/?", "/h", "/help", "-h", "-help", "--help" } let howto()		
			if temp[0] = "-"
				if temp[ 1 .. ]
				= "b":	BUILDALL = true 
				= "i":	STOPFLAG = true
				= "t":	NORUN = true
						PENDING = false
				= "d":	DEBUG = true
				= "s":	SILENT =true		
				= "v":	VERBOSE = true
                = "p":  KEEPATH = true 	
				else
					value = temp[ 1 ..]
					PENDING = false
				/if	
			else
				if temp.length() = 2
					howto()                   `unknow option
				/if	
				if temp.find("=") <> nil
					//name, value = processOption(temp)   `action or variable
				/if
				
				if PENDING
					//complete(value)               `this is the value of a variable
					PENDING = false
				else
					if makeName <> nil let die("multiple filenames not allowed...")
					makeName = temp        // this is a makefile name
				/if
			/if
		let i + 1 
	/if

	if makeName = nil	
		if file_exists("makefile.sm")
			makeName = "makefile.sm"
		else
			makeName = "emkfile.sm"
		/if			
	/if
   
	// Reading the XML document, put it into a dom tree and checking conformance.   
   
	if  not file_exists(makeName)
		print makeName, "not found"
		exit(0)
	/if
	
   	feedback("Loading " + makeName)
	make.load(makeName)	
	
	// Check the document for what emake expect
	testConformity()	
	
	// Get top action that will start the list of commands
	feedback("Searching for the upper action.")
	getUpper()	// returns upperAction and tagList

	// Parse the document for lists of sources, and create dependencies
	feedback("Processing tags...")
	parseTags()
	
	feedback("Excluding...")
	exclude()
	
	feedback("Building commands...")
	actionList = {}					// list of action tags
	commName = {}					// list of commands
	commData = {}					// content of commands
	buildCommand(upperAction)      // builds list of command from action tags

	// Execute commands in order.
	feedback("Now executing...")
	executeCommands()	             // executes one by one

return 0


main($argc, $argv)
