<?php
include_once("libphp.php");
include_once("path.php");
include_once("tools.php");
include_once("smklib.php");
include_once("dom.php");
$makeName="";
$make=new DOMDocument();
$tagList=array();
$sources=array();
$objects=array();
$actions=array();
$excludeList=array();
$actionList=array();
$sourceLists=array();
$commName=array();
$commData=array();
$sourcesString="";
$objectsString="";
$libsString="";
$upperAction="";
$counter=0;

;

$NORUN=0;
$STOPFLAG=0;
$KEEPATH=0;
function howto()
{
   echo "Speedy Make 2.0 (c) 2006-2008 Kim Haskell - Scriptol.org", "\n";
   echo "Command:", "\n";
   echo "  php smake.php [options]", "\n";
   echo "  php smake.php [options] makefile.sm", "\n";
   echo "Options:", "\n";
   echo "  no option   use the default file makefile.sm", "\n";
   echo "  -h          display this help.", "\n";
   echo "  -b          rebuild all sources.", "\n";
   echo "  -t          test the makefile, do not execute commands.", "\n";
   echo "  -i          interrupt, stop at first error.", "\n";
   echo "  -v          verbose, display more info.", "\n";
   echo "  -s          silent, do not print commands.", "\n";
   echo "  -p          keep path for object files.", "\n";
   echo "  -name=\"value\"  assign a value to the variable \"name\".", "\n";
   echo "  -name       execute the action \"name\".", "\n";
   exit(0);
   return;
}

function verifyFiles($dirname)
{
   $count=0;
   global $sources;
   reset($sources);
   do
   {
      $t= current($sources);
      if(strpos($t,$dirname)===false)
      {
         $t=Path::merge($dirname,$t);
      }
      if(!file_exists($t))
      {
         echo "\"",$t,"\""," not found.\n";
         $count+=1;
      }
   }
   while(!(next($sources) === false));

   return $count;
}

function tagExists($name)
{
   global $make;
   $dnl=$make->getElementsByTagName($name);
   return $dnl->length>0;
}

function getContent($name)
{
   $content="";
   global $make;
   $dnl=$make->getElementsByTagName($name);
   $e=$dnl->item(0);
   $content=$e->textContent;
   return $content;
}

function createList($xe)
{
   $data=$xe->textContent;
   $srcs=explode("\n",$data);
   $srcString=trim($data);
   $newarr=array();
   reset($srcs);
   do
   {
      $x=trim(current($srcs));
      if($x!=false)
      {
         array_push($newarr,$x);
      }
   }
   while(!(next($srcs)===false));
   global $sourceLists;
   $sourceLists[$xe->tagName]=$newarr;
   return $newarr;
}

function getTagContent($name)
{
   $clist=array();
   global $make;
   $dnl=$make->getElementsByTagName($name);
   $e=$dnl->item(0);
   $content=$e->textContent;
   if($content!=false)
   {
      $clist=explode("\n",$content);
   }
   return $clist;
}

function addProgram($prog)
{
   global $commName;
   array_push($commName,"run");
   global $commData;
   array_push($commData,$prog);
   return;
}

function expandVariable($program)
{
   $tokens=array();
   $srcname="";
   $extension="";
   $objString="";
   $pos=1;
   $start=0;
   global $sources;
   $size=count($sources);
   $len=strlen($program);
   $flag=false;
   while($pos!=0)
   {
      do
      {
         $pos=strpos($program,"$");
         if($pos===0)
         {
            $pos=strpos($program,"*",$pos);
            if($pos!=0)
            {
               addProgram($program);
               break 2;
            }
            $start=$pos;
            $_I1=extractName($program,$pos+1);
            $srcname=reset($_I1);
            $pos=next($_I1);
            $extension=next($_I1);

            global $sourceLists;
            $sources=$sourceLists[$srcname];
            if($sources ==false)
            {
               return;
            }
            if($extension!=false)
            {
               if(count($sources)===0)
               {
                  break 2;
               }
               global $objects;
               global $KEEPATH;
               $_I1=changeExtensions($sources,$extension,$KEEPATH);
               $objects=reset($_I1);
               $objString=next($_I1);
            }
            else
            {
               $sources=removeCompiled($sources);
               if(count($sources)===0)
               {
                  break 2;
               }
            }
            for($i=0;$i<$size;$i++)
            {
               $comm=$program;
               global $objects;
               $name=$objects[$i];
               $comm=substr($comm,0,$start).$name.substr($comm,$pos+1);
               addProgram($program);
            }
            return;
         }
         $start=$pos;
         $_I1=extractName($program,$pos+1);
         $srcname=reset($_I1);
         $pos=next($_I1);
         $extension=next($_I1);
         $sources=getTagContent($srcname);

         if($extension ==false)
         {
            $sources=removeCompiled($sources);
         }
         global $objects;
         global $KEEPATH;
         $_I1=changeExtensions($sources,$extension,$KEEPATH);
         $objects=reset($_I1);
         $objString=next($_I1);

         $program=substr($program,0,$start).$objString.substr($program,$pos+1);

         $pos=strpos($program,"$");
         if($pos<1)
         {
            addProgram($program);
         }
      } while(false);
   }
   return;
}

function parseOneTag($name)
{
   $srcs=array();
   $content="";
   $intag=0;
   global $make;
   $dnl=$make->getElementsByTagName($name);
   if($dnl->length===0)
   {
      echo $name, " ", "tag not found", "\n";
      return;
   }
   $node=$dnl->item(0);

   $xe=$node;
   $prog=$xe->getAttribute("action");
   if($prog===null)
   {
      return;
   }
   $comm=$xe->getAttribute("action");
   global $DEBUG;
   if($DEBUG)
   {
      echo "Parse", " ", $name, " ", "for", " ", $comm, "\n";
   }
   if(in_array($comm,array("parse","build","none","","exclude")))
   {
      $srcs=createList($xe);
      $intag=count($srcs);
      echo $intag," file",(count($srcs)>1?"s":"")," in <",$xe->tagName,">\n";
      
      if($comm==="parse")
      {
         $x=parseList($srcs);
         $srcs=array_splice(array_unique(array_merge($srcs,parseList($srcs))),0);
         echo count($srcs)-$intag, " ", "included in the list", "\n";
      }
      else
      {
         if($comm==="exclude")
         {
            $target=$xe->getAttribute("target");
            if($target ==false)
            {
               echo "Error, target required in", " ", $prog, "\n";
            }
            else
            {
               global $excludeList;
               $excludeList[$target]=$prog;
               echo count($srcs), " ", "to exclude", "\n";
            }
         }
      }
      $content=implode(" ",$srcs);
      $xe->textContent=$content;
      if($DEBUG)
      {
         echo "All sources:", " ", $xe->textContent, "\n";
      }
   }
   global $counter;
   $counter+=1;

   return;
}

function parseTags()
{
   global $DEBUG;
   if($DEBUG)
   {
      echo "Parse Tags", "\n";
   }
   global $tagList;
   reset($tagList);
   do
   {
      $name= current($tagList);
      parseOneTag($name);
   }
   while(!(next($tagList) === false));

   global $counter;
   if($counter===0)
   {
      echo "Nothing to do...", "\n";
   }
   return;
}

function exclude()
{
   $sourceData=array();
   $targetData=array();
   $xes=null;
   $xet=null;

   global $DEBUG;
   if($DEBUG)
   {
      echo "Exclude", "\n";
   }
   global $excludeList;
   if(empty($excludeList))
   {
      feedback("No file to exclude...");
      return;
   }
   reset($excludeList);
   do
   {
      $source= key($excludeList);
      $target= current($excludeList);
      if(!tagExists($source))
      {
         continue;
      }
      if(!tagExists($target))
      {
         continue;
      }
      $sourceData=contentToArray($xes->textContent,false);
      if(count($sourceData)===0)
      {
         continue;
      }
      $targetData=contentToArray($xet->textContent,false);
      if(count($targetData)===0)
      {
         continue;
      }
      reset($sourceData);
      do
      {
         $x= current($sourceData);
         $pos=array_search($x,$targetData);
         if($pos!=false)
         {
            array_splice($targetData,$pos,$pos-($pos)+count($targetData)*(($pos<0)-($pos<0))+1);
         }
      }
      while(!(next($sourceData) === false));

      $content=implode(" ",$targetData);
      $xet->textContent=$content;

   }
   while(!(next($excludeList) === false));

   return;
}

function makeInternalCommand($xe)
{
   $comm=$xe->getAttribute("action");
   $content=$xe->textContent;
   
   if($comm==="display")
   {
      global $commName;
      array_push($commName,"display");
      global $commData;
      array_push($commData,$content);
   }
   
   return;
}

function makeExternalProgram($xe)
{
   $content=$xe->textContent;
   $name=$xe->tagName;
   expandVariable(purge($content));
   return;
}

function buildCommand($actionName)
{
   $innerList=array();
   $content="";
   $ename="";
   global $actionList;
   if(in_array($actionName,$actionList))
   {
      return;
   }
   array_push($actionList,$actionName);
   global $make;
   $dnl=$make->getElementsByTagName($actionName);
   $currelem=$dnl->item(0);

   if($currelem===null)
   {
      echo "Err", " ", $actionName, " ", "tag not found.", "\n";
      return;
   }
   global $DEBUG;
   if($DEBUG)
   {
      echo $currelem->tagName, " ", "tag, attempting to make command:", "\n";
   }
   if($currelem->hasAttribute("action"))
   {
      $val=$currelem->getAttribute("action");
      if($DEBUG)
      {
         echo "Terminal tag, action=", " ", $currelem->getAttribute("action"), "\n";
      }
      if(strcasecmp($val,"run")===0)
      {
         makeExternalProgram($currelem);
         return;
      }
      makeInternalCommand($currelem);
      return;
   }
   if($DEBUG)
   {
      echo "Non terminal tag...", "\n";
   }
   $content=$currelem->textContent;
   $innerList=contentToArray($content,"");
   if(empty($innerList))
   {
      return;
   }
   if($DEBUG)
   {
      print_r($innerList);
   }
   reset($innerList);
   do
   {
      $ename= current($innerList);
      buildCommand($ename);
   }
   while(!(next($innerList) === false));

   if($DEBUG)
   {
      echo "List of commands:", "\n";
      global $commData;
      print_r($commData);
   }
   global $commName;
   if(!in_array("run",$commName))
   {
      echo "No RUN action, nothing to do.", "\n";
      exit(1);
   }
   return;
}

function processBinary($xe)
{
   $prog=$xe->textContent;
   $prog=trim($prog);
   global $buildDate;
   $buildDate=0;

   global $BUILDALL;
   if($BUILDALL===false)
   {
      if(file_exists($prog))
      {
         $buildDate=filemtime($prog);
      }
   }
   global $VERBOSE;
   if($VERBOSE)
   {
      if($buildDate===0)
      {
         echo " - first build";
      }
      else
      {
         $d=date("c",intVal($buildDate));
         echo " - last build ".prettyDate($d);
      }
   }
   return;
}

function getUpper()
{
   $ename="";
   $content="";
   $candidates=array();
   $localList=array();
   $node=null;
   $bTag=false;
   global $make;
   $dnl=$make->getElementsByTagName("makefile");
   $currelem=$dnl->item(0);
   $node=$currelem;

   $name=$currelem->getAttribute("name");
   global $makeName;
   echo "Processing \"",$name,"\" (",$makeName,")\n";
   $dnl=$currelem->getElementsByTagName("*");
   global $VERBOSE;
   if($VERBOSE)
   {
      echo $dnl->length, " ", "tags", "\n";
   }
   if(!$node->hasChildNodes())
   {
      echo "Empty makefile...", "\n";
      exit(0);
   }
   for($i=0;$i<$dnl->length;$i++)
   {
      $currelem=$dnl->item($i);
      $ename=$currelem->tagName;
      if($ename ==false)
      {
         continue;
      }
      if($VERBOSE)
      {
         echo "* ",$ename;
      }
      global $tagList;
      array_push($tagList,$ename);
      if($currelem->hasAttribute("action"))
      {
         $cact=$currelem->getAttribute("action");
         if($VERBOSE)
         {
            echo " (",$cact,")";
         }
         if($cact==="build")
         {
            processBinary($currelem);
            $bTag=true;
         }
         if($VERBOSE)
         {
            echo "\n";
         }
         continue;
      }
      if($VERBOSE)
      {
         echo "\n";
      }
      array_push($candidates,$ename);
      $content=$currelem->textContent;
      $localList=contentToArray($content,"");

      if(count($localList)>0)
      {
         if($VERBOSE)
         {
            $n=count($localList);
            echo $n," tag",($n>1?"s":"")," in ",$currelem->tagName,"\n";
            global $DEBUG;
            if($DEBUG)
            {
               echo "List of tags:", "\n";
               reset($localList);
               do
               {
                  echo current($localList), "\n";
               }
               while(!(next($localList)===false));
            }
         }
      }
      else
      {
         echo "No action found.", "\n";
      }
      reset($localList);
      do
      {
         $item=strval(current($localList));
         $index=array_search($item,$candidates);
         if($index!=false)
         {
            array_splice($candidates,$index,1);
         }
      }
      while(!(next($localList)===false));
   }
   if(empty($candidates))
   {
      echo "No top action found, please create one...", "\n";
      exit(0);
   }
   if(count($candidates)>1)
   {
      echo "Several top actions found, please make only one...", "\n";
      reset($candidates);
      do
      {
         echo current($candidates), "\n";
      }
      while(!(next($candidates)===false));
      exit(0);
   }
   global $upperAction;
   $upperAction=array_pop($candidates);
   if($VERBOSE)
   {
      echo "Top action:", " ", $upperAction, "\n";
   }
   if(!$bTag)
   {
      echo "Error, no build action, nothing to build.", "\n";
   }
   return;
}

function testConformity()
{
   global $VERBOSE;
   if($VERBOSE)
   {
      echo "Checking for conformity...";
   }
   global $make;
   $dnl=$make->getElementsByTagName("*");
   for($i=0;$i<$dnl->length;$i++)
   {
      $e=$dnl->item($i);
      $name=$e->tagName;
      if(strlen($name)===0)
      {
         continue;
      }
      if(strlen($name)<2)
      {
         echo "\n";
         echo "\"",$name,"\"";
         echo " only one letter is not a valid element name...", "\n";
         exit(0);
      }
   }
   feedback(" ok.");
   return;
}

function executeCommands()
{
   $res=0;
   $name="";
   $content="";
   $type="";
   global $commName;
   global $commData;
   reset($commName);
   reset($commData);
   do
   {
      
      $_I1=current($commName);
      if($_I1==="display")
      {
         $t=current($commData);
         $_L4=strlen($t);
         for($__4 = 0; $__4 < $_L4; $__4++)
         {
            $x=$t{$__4};
            if($x==="\t")
            {
               continue;
            }
            echo $x;
         }
         echo "\n";
      }
      else
      {
         if($_I1==="run")
         {
            global $NORUN;
            if($NORUN)
            {
               return;
            }
            $comm=trim(current($commData));
            $comm=str_replace("\n","",$comm);
            $comm=str_replace("  ","",$comm);
            echo "\n";
            $exres=system($comm);
            $res+=$exres;
            global $STOPFLAG;
            if($STOPFLAG)
            {
               if($res!=0)
               {
                  die("Stopped on error.");
               }
            }
         }
      }
   }
   while(!(next($commData)===false)&&!(next($commName)===false));
   if($res!=0)
   {
      echo "Errors encountered in external programs.", "\n";
   }
   return;
}

function main($argc,$argv)
{
   $PENDING=false;
   $name="";
   $value="";
   global $BUILDALL;
   $BUILDALL=false;
   global $NORUN;
   $NORUN=false;
   global $VERBOSE;
   $VERBOSE=false;
   global $SILENT;
   $SILENT=false;
   global $DEBUG;
   $DEBUG=false;
   global $STOPFLAG;
   $STOPFLAG=false;
   global $KEEPATH;
   $KEEPATH=false;

   if($argc>1)
   {
      $i=1;
      while($i<$argc)
      {
         do
         {
            $temp=$argv[$i];
            if(in_array($temp,array("/?","/h","/help","-h","-help","--help")))
            {
               howto();
            }
            if($temp{0}==="-")
            {
               
               $_I1=substr($temp,1);
               if($_I1==="b")
               {
                  $BUILDALL=true;
               }
               else
               {
                  if($_I1==="i")
                  {
                     $STOPFLAG=true;
                  }
               else
               {
                  if($_I1==="t")
                  {
                     $NORUN=true;
                     $PENDING=false;
                  }
               else
               {
                  if($_I1==="d")
                  {
                     $DEBUG=true;
                  }
               else
               {
                  if($_I1==="s")
                  {
                     $SILENT=true;
                  }
               else
               {
                  if($_I1==="v")
                  {
                     $VERBOSE=true;
                  }
               else
               {
                  if($_I1==="p")
                  {
                     $KEEPATH=true;
                  }
               else
               {
                  $value=substr($temp,1);
                  $PENDING=false;
               }
               }}}}}}
            }
            else
            {
               if(strlen($temp)===2)
               {
                  howto();
               }
               if(strpos($temp,"=")!=false)
               {
               }
               if($PENDING)
               {
                  $PENDING=false;
               }
               else
               {
                  global $makeName;
                  if($makeName!=false)
                  {
                     die("multiple filenames not allowed...");
                  }
                  $makeName=$temp;
               }
            }
         } while(false);
         $i+=1;
      }
   }
   global $makeName;
   if($makeName ==false)
   {
      if(file_exists("makefile.sm"))
      {
         $makeName="makefile.sm";
      }
      else
      {
         $makeName="emkfile.sm";
      }
   }
   if(!file_exists($makeName))
   {
      echo $makeName, " ", "not found", "\n";
      exit(0);
   }
   feedback("Loading ".$makeName);
   global $make;
   $make->load($makeName);
   testConformity();
   feedback("Searching for the upper action.");
   getUpper();
   feedback("Processing tags...");
   parseTags();
   feedback("Excluding...");
   exclude();
   feedback("Building commands...");
   global $actionList;
   $actionList=array();
   global $commName;
   $commName=array();
   global $commData;
   $commData=array();
   global $upperAction;
   buildCommand($upperAction);
   feedback("Now executing...");
   executeCommands();
   return 0;
}

main(intVal($argc),$argv);

?>
