
` Search and Replace - Freeware (c) 2004-2009  by Denis G. Sureau
` www.scriptol.com


` This program searches and (optionally) replaces a string in a file,
` or in a set of files matching a pattern.
` The pattern for files may contain MS-DOS and Unix  *  and  ?  wilcards.
` It doesn't use regular expressions.
` The search can be performed case-sensitive or not.
` One can search for identifiers in C, Scriptol or other sources,
` or any string in any pure ASCII text.

` By changing the "delimiters" string, you may specify what are identifiers.

include "path.sol"
include "dirlist.sol"
include "pattern.sol"
include "strtools.sol"


` Global declarations

DirList dirtools
StrTools stringtools

boolean TEXTCASE = false
boolean QUIET = false
boolean FILECASE = false
boolean PURETEXT = true
boolean RECURSE = false
boolean VERBOSE = false

constant int PADLEFT = $(STR_PAD_LEFT)

int TOTAL = 0       ` Total files
int MATCHES = 0     ` Total selected files
number COUNTER = 0  ` Occurences

text pattern
text searching = ""
text replacing = ""

void syntax()
	print "Search and replace  1.4 - www.scriptol.com."
	print "Syntax:   search [option] search-string [replacing-string] file."
	print "    or:   search [option] search-string [replacing-string] pattern."
	print "    or:   php -q search.php etc..."
	print "Options:"
	print "  -i   ignore case for strings (default case-sensitive)."
	print "  -c   search identifiers inside code (default string in text)."
	print "  -u   unix style, filename case sensitive (default ignore case)."
	print "  -q   quiet, don't display matches (default display)."
	print "  -r   recursively scan subdirectories."
    print "  -v   verbose, display more infos." 
	print "  -icurv is the format for multiple options"
	exit()
return


text heading(text name)
    if RECURSE return getcwd() + "/" +  name 
return name 
   
        

` Replace words in string
` as text.replace(), but case-sensitive or no, and count occurences

text replace(text line):

	number sealen =  searching.len()
	number replen =  replacing.len()
	number linelen = line.length()

	if TEXTCASE = false               ` Ignore case
		searching  = searching.lower()
		line = line.lower()
	/if

	int idx = 0
	text idr = ""

	while (idx + sealen) < linelen:
		idx = line.find(searching, idx)       ` Is "searching" inside line?
		if idx = nil ?  break                 ` No more occurence, exit
		if idx = 0 : line = replacing + line[idx + sealen..]
		else
			line = line[0--idx] + replacing + line[idx+sealen..]
		/if

		idx + replen                          ` Skipping scanned part of iline
		linelen = line.length()
		COUNTER + 1
	/while
 return line



` Open a file

file openfile(text filename, text mode):
	file f
	f.open(filename, mode)
	error
		print "Enable to open ", filename
		return nil
	/error
return f



` Replaces a file
` Makes it ".bak" and renames a temporary file to its name
` Change a temporary file into original file
` the original file become a .bak file

void replacefile(text srcname, text dstname):

	` If source filename is node.ext it becomes node.bak
	` but if node itself is the name of an existing file,
	` source file will be renamed rather node.ext.bak

	text node, ext
	node, ext = Path.splitExt(srcname)
	if Path.exists(node)
		if ext != "" ?  node = srcname
	/if

	text newname = node + ".bak"
	Path.erase(newname)
	Path.ren(srcname, newname)   ` Previous renamed as .bak
	Path.ren(dstname, srcname)   ` Temporary gets name of previous file
return



` Search identifier in file
` Print out lines of file "filename" that contains "searching"

number search(text filename):

	if VERBOSE print heading(filename), ":"

	file f2 = openfile(filename, "r")   ` Local function
	if f2 = nil ? return 0
	number linenum = 0

	while forever
		text line = f2.readline()
		if not line ? break
		linenum + 1
		number old = COUNTER

		array words = line.split(stringtools.cdelimiters)

		for text cmp in words:
			if searching = cmp :  COUNTER + 1
			else:
				if TEXTCASE = false:
					if searching.lower() = cmp.lower() ? COUNTER + 1
				/if
			 /if
		/for

		if COUNTER > old:
			if QUIET = false:
				` A trailing comma to avoid new line
				if not VERBOSE echo heading(filename), ":"
				echo pad(strval(linenum), 4, "0", PADLEFT) , ": ",  line
	       /if
   	   /if
	/while

	f2.close()
return COUNTER

boolean clean(text dstname)
	if Path.exists(dstname):
		if not Path.erase(dstname)
			print "Enable to clean", dstname, "replacing cancelled"
			return false
		/if
	/if
return true


` Replace identifier in file
` Replace occurence of "searching" by "replacing" in file "filename"

number replaceid(text srcname)

	if VERBOSE print "Replacing identifier" , searching , "by" , replacing , "in" , heading(srcname)

	` Making a temporary file
	text dstname = srcname + ".tmp"
	if not clean(dstname) ? return 0

	if TEXTCASE = false ? searching = searching.lower()
	array src
	src.load(srcname)

	number linenum = 0
	text lowsearch = searching.lower()

	for text line in src
		int oldcounter = COUNTER
		text newline = ""
		array srcwords = line.split(StrTools.cdelimiters)

		` Adding either same or replacing word
		for text cmp in srcwords:
			text word = cmp
			if searching = cmp:
				word = replacing
				COUNTER + 1
			else:
				if (TEXTCASE = false) and (lowsearch = cmp.lower()):
					word = replacing
					COUNTER + 1
				/if
			/if
			newline + word
		/for

		linenum + 1
		src[] = newline

		if (not QUIET) and (COUNTER > oldcounter):
			if not VERBOSE echo heading(srcname), ": "  
			echo pad(strval(linenum), 4, "0", PADLEFT) , ": ", newline
		/if
	 		
	/for

	` writing the content
	file dst
	dst.open(dstname, "w")
	error ? die("enable to write on " + dstname)
	for text line in src ? dst.write(line)
	dst.close()

	` Now replacing the old file with the new updated one
	replacefile(srcname, dstname)

return COUNTER



` Search string in ascii text
` Search occurences of string "searching" in file "filename"


int searchstr(text srcname)

	if VERBOSE print heading(srcname) + ": "

	file src = openfile(srcname, "r")
	if src = nil ? return 0

	int linenum = 0
	if TEXTCASE = false ? searching = searching.lower()

	while forever
		text line = src.readline()
		if not line ? break
		linenum + 1
		if TEXTCASE = false ? line = line.lower()

		` Locating, counting and displaying

		if line.find(searching) <> nil:
			if not VERBOSE echo heading(srcname), ": "
			if (not QUIET) echo pad(strval(linenum), 4, "0", PADLEFT) , ": ", line
				COUNTER = COUNTER + stringtools.count(line, searching)
		/if
	/while

	src.close()
return COUNTER


` Replace a string in an ascii file
` Replace occurences of "searching" by "replacing" in file "filename"

int replacestr(text srcname):

	if VERBOSE print "Replacing string \"" + searching + "\" by \"" + replacing + "\" in " + heading(srcname)

	` Making a temporary file
	text dstname = srcname + ".tmp"
	if not clean(dstname) ?  return 0

	array src
	src.load(srcname)

	int linenum = 1
 
	for text line in src
		int oldcounter = COUNTER
		line = replace(line)
		if (not QUIET) and (COUNTER > oldcounter)
			if not VERBOSE echo heading(srcname), ": "  
			echo pad(strval(linenum), 4, "0", PADLEFT), ": ", line
		/if
		linenum + 1
		src[] = line
	/for

	file dst = openfile(dstname, "wb")
	if dst = nil ? return 0
	for text line in src ? dst.write(line)
	dst.close()
	` Now replacing the old file with the new updated one
	replacefile(srcname, dstname)
	
return COUNTER


` Parsing the directory

void scanning(text thedir)

	array dirarray
	text filename
	text dirname
    
    text here = getcwd()
    if VERBOSE print '-'.dup(4), here, '-'.dup(56 - here.length())
 
    if Path.type(thedir) <> "dir" ? return

    dyn handle = opendir(thedir)	
    rewinddir(handle)

    do
        filename = readdir(handle)
        if filename = nil ? break
        if filename in (".", "..") ? continue
        
		if Path.isFile(filename)
			TOTAL + 1        ` Total files found
			if patmatch(pattern, filename, FILECASE):
				MATCHES + 1    ` Selected files count
				if replacing = "":
					if PURETEXT = false:
						search(filename)
					else:
						searchstr(filename)
					/if
				else:
					if PURETEXT = false:
						replaceid(filename)
					else:
						replacestr(filename)
					/if
				/if
			/if
		/if
   /do forever

    if RECURSE = false
        closedir(handle)
        return
    /if

   rewinddir(handle)

   do
        dirname = readdir(handle)
        if dirname = nil ? break
        if dirname in (".", "..") ? continue
 	
		if Path.isDir(dirname)
		     chdir(dirname)
                  scanning(".")
		     chdir("..")
		/if
   /do forever
   
   closedir(handle)
   
return

`---------------------------------------------------
`                   Main program
`---------------------------------------------------


int main(int argnum, array arglist)

	` The program requires 3 parameters plus one or two optionnals

	if arglist.size()  not in 3 .. 5 ? syntax()

	` Defaults

	TEXTCASE = true
	QUIET = false
	FILECASE = false
	PURETEXT = true
	RECURSE = false

	` Processing options

	arglist.shift()                 ` removing the script's name
	text optstr = arglist[0]
	text optchr = optstr[0]

	while (optchr = '-') or (optchr = '/'):
		text opt = optstr[1..]
		arglist.shift()               ` now removing the option list
		for text i in opt:
			if i
			= 'i': TEXTCASE = false     ` Ignore case for text
			= 'c': PURETEXT = false     ` Not pure text processing
			= 'u': FILECASE = true      ` Filenames case-sensitive
			= 'q': QUIET = true           ` Don't display found/changed lines
			= 'f': VERBOSE = true      ` Display parsed file
			= 'r': RECURSE = true       ` Scan subdirectories
			= 'v': VERBOSE = true       ` Display more infos
			else:
				print i , "bad option"
				syntax()
			/if
		/for
        optstr = arglist[0]
        optchr = optstr[0]
	/while

	if arglist.size() = 3        ` if there is a replacing string
		replacing = arglist[1]
		arglist[1..1] = ()         ` removing the replacing element 
	/if

	searching = arglist[0]
	pattern   = arglist[1]
    
    if (replacing[0] = "-") or (searching[0] = "-") or (pattern[0] = "-")
        print "Put options at beginning..."
        syntax()
    /if       
	
	//print "SEARCH $searching PAT $pattern"

	` Starting the search

    scanning(getcwd())

	if VERBOSE print '-'.dup(60)
	print TOTAL , "file" + plural(TOTAL) + ",",
		MATCHES, "file" + plural(MATCHES) , "matching," ,
		COUNTER, "occurence" + plural(COUNTER), "found"
return 0

main($argc, $argv)

