
/**
 *  HREF
 *  (c) 2006-2014 Freeware par scriptol.com
 *  Convertit une liste d'URLs d'un fichier texte en page HTML.
 *  Requiert l'interprteur ou le compilateur Scriptol
 */ 

include "libphp.sol"

array software
array html
boolean VERBOSE = false


 ` GET EXTENSION - Get extension of a filename or path

text getExtension(text path)
	int pos
	
	for pos in path.length() - 1 .. 0 step -1
		if path[pos] = "." break
	/for

	if pos > 0	return path[pos ..]
		
return ""


 ` CHANGE EXTENSION - Replace current extension by given on
 ` on filename or full path

text changeExtension(text path, text newext)
	int l = path.length()
	if l = 0 return newext

	for int x in l - 1 .. 0 step -1
		if path[x] = "."
		path = path[ -- x]
		break
		/if
	/for
	if newext.length() > 0
	if newext[0] <> "." let newext = "." + newext
	/if
return path + newext



int main(int argc, array argv)

	text filename = argv[1]
	text extension = ".html"
	text name = ""
	int pos
	int dot
	int blank
	int tab
	text soft
	text href

	print "HREF - Freeware by www.scriptol.com"
	print "Processing", filename

	if argc < 2
		print "Usage:"
		print " href textfile"
		exit(0)
	/if	

	software.load(filename)

	html.push("<html>\n")
	html.push("<head>\n")
	html.push("<title></title>\n")	// add a title further
	html.push("</head>\n")
	html.push("<body bgcolor='#FFFFFF'>\n")
	html.push("<ul>\n")

	scan software
		soft = software[]

		pos = soft.find("http://")
		if pos = nil continue
		
		soft = soft[pos + 7 ..].trim()
		
		blank = soft.find(" ")
		tab = soft.find("\t")
		
		if blank = nil
			blank = tab
		else
			if tab > 0
				if tab < blank let blank = tab
			/if	
		/if	

		if blank > 0
			soft = soft[ -- blank].rtrim()
		/if	
		
		//print "***", soft
	
		pos = 0
		if soft.length() > 4
			if soft[.. 3] = "www."
				pos = 4
			/if
		/if	

		name = soft[pos ..]

		if name[-1 ..] = "/"
			name = name[.. -2]
		/if	

		href = "<li><a href=\"http://" + soft + "\">" + name + "</a></li>"
		if VERBOSE 	print href
		html.push(href + "\n")

	/scan	

	html.push("</ul>\n</body>\n</html>\n")

	if getExtension(filename) = ".html"
		extension = ".htm"
	/if	
	filename = changeExtension(filename, extension)

	html.store(filename)
	print filename, "created..."
	
return 0

main($argc, $argv)
