#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <io.h>
#include <ctype.h>
#include <assert.h>
#include <math.h>
#include <string>
#include <vector>
#include <iostream>
#include <algorithm>
#include <scriptol/libsol.hpp>

#include "libphp.hpp"
#include "href.hpp"

array software=array();
array html=array();
bool VERBOSE=false;

text getExtension(text path)
{
    int pos=0;
    for(pos=path.length()-1;pos>=0;pos+=-1)
    {
        if((path[pos])==".")
        {
            break;
        }
    }
    if(pos>0)
    {
        return path.slice(pos,-1,1);
    }
    return "";
}


text changeExtension(text path,text newext)
{
    int l=path.length();
    if(l==0)
    {
        return newext;
    }
    for(int x=l-1;x>=0;x+=-1)
    {
        if((path[x])==".")
        {
            path=path.slice(0,x,0);
            break;
        }
    }
    if(newext.length()>0)
    {
        if((newext[0])!=".")
        {
            newext=text(".")+newext;
        }
    }
    return path+newext;
}


int main(int argc,char *_I_1[])
{
    array argv(_I_1);
    text filename=(argv.at(1)).toText();
    text extension=".html";
    text name="";
    int pos=0;
    int dot=0;
    int blank=0;
    int tab=0;
    text soft="";
    text href="";
    std::cout << "HREF - Freeware by www.scriptol.com"<< "\n";
    std::cout << "Processing"<< " " << filename<< "\n";
    if(argc<2)
    {
        std::cout << "Usage:"<< "\n";
        std::cout << " href textfile"<< "\n";
        exit(0);
    }
    software.load(filename.data);
    html.push(dyn("<html>\n"));
    html.push(dyn("<head>\n"));
    html.push(dyn("<title></title>\n"));
    html.push(dyn("</head>\n"));
    html.push(dyn("<body bgcolor='#FFFFFF'>\n"));
    html.push(dyn("<ul>\n"));
    software.reset();
    do
    {
        soft=dyn::toText((software.value()));
        pos=soft.find("http://");
        if(pos==-1)
        {
            continue;
        }
        soft=soft.slice(pos+7,-1,1).trim();
        blank=soft.find(" ");
        tab=soft.find("\t");
        if(blank==-1)
        {
            blank=tab;
        }
        else
        {
            if(tab>0)
            {
                if(tab<blank)
                {
                    blank=tab;
                }
            }
        }
        if(blank>0)
        {
            soft=soft.slice(0,blank,0).rTrim();
        }
        pos=0;
        if(soft.length()>4)
        {
            if(soft.slice(0,3,1)=="www.")
            {
                pos=4;
            }
        }
        name=soft.slice(pos,-1,1);
        if(name.slice(-1,-1,1)=="/")
        {
            name=name.slice(0,-2,1);
        }
        href=text(text("<li><a href=\"http://")+soft+"\">")+name+"</a></li>";
        if(VERBOSE)
        {
            std::cout << href<< "\n";
        }
        html.push(dyn(href+"\n"));
    }
    while(software.bound());
    html.push(dyn("</ul>\n</body>\n</html>\n"));
    if(getExtension(filename)==".html")
    {
        extension=".htm";
    }
    filename=changeExtension(filename,extension);
    dyn::error.set(html.store(filename.data));
    std::cout << filename<< " " << "created..."<< "\n";
    return 0;
}

;
