include "strtools.sol"


void usage()
  print
  print "Dictionary Sort - Freeware (c) 2002 by D.G. Sureau"
  print "Free BSD licence - www.freeprogrammer.com"
  print "Sort a dict of words with number of occurences"
  print "to the ascending order of values (occurences)"
  print "Syntax:  dsort dictfile [newfile]"
  exit()
return


int main (int argnum, array arg)
  file inPtr
  file outPtr
  text inName
  text outName

  text line
  dict words = ()

  if argnum not in 2..3 ?  usage()

  inName  = arg[1]
  if argnum = 3
    outName = arg[2]
  else
    outName = inName
  /if

  print "Reading", inName, "writing into", outName

  StrTools str
  text value
  text key

  inPtr.open(inName, "rt")
  error ? die("Cannot open " + inName)


  print "working... "
  while not inPtr.eof()
    line = inPtr.readLine()
    int pos = line.find(":")
    value = "1"
    if pos <> nil
       key   = line[ -- pos]
       value = line[ pos + 1 ..].trim()
    else
       key = line.trim()
    /if
    words[ key ] = value

  /while

  inPtr.close()

  words.sort()

  outPtr.open(outName,"wb")
  error ? die("Cannot open " + outName)

  for text k, text v in words
    outPtr.write(k + ":" + v.toText() + "\n")
  /for
  outPtr.close()

  print words.size(), "words written into", outName

return 0


main($argc, $argv)
