#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>

#include "../gui/head.h"
#include "../gui/message.h"
#include "../gui/zip.h"
#include "../gui/dirtools.h"
#include "../gui/winzip.h"
#include "listini.h"
#include "listgui.h"
#include "listdir.h"
#include "listit.h"

long TOTAL;
char ZIPNAME[13];
char PATH_IN_ZIP[81];
int  PATH_LEN;
int  ZIP_LEVEL_START[ZIP_MAX_LEVEL];
int  ZIP_LEVEL_NUM[ZIP_MAX_LEVEL];
int  ZIPlevel;
char ZIPBACK = 4;
char ZIPTEXT = 15;

char UNARCHIVERname[81];

#define ARRAYSIZE 2048

#define ZIP_LOCAL_SIG   0x04034b50          /* local file header signature */
#define CENTRAL_SIG     0x02014b50          /* central directory structure signature */
#define END_SIG         0x06054b50          /* end of central directory signature */


struct Central_Dir
{
    unsigned long   sig;                    /* local file header signature */
    unsigned short  made_by;                /* version made by */
    unsigned short  version;                /* version needed to extract */
    unsigned short  gen;                    /* general purpose bit flag */
    unsigned short  method;                 /* compression method */
    unsigned short  time;                   /* last mod file time */
    unsigned short  date;                   /* last mod file date */
    unsigned long   crc;                    /* CRC-32 */
    unsigned long   csize;                  /* compressed file size */
    unsigned long   size;                   /* uncompressed file size */
    unsigned short  fnamesize;              /* size of filename field */
    unsigned short  extra_field_len;        /* size of extra field */
    unsigned short  file_comment_length;    /* size of file comment */
    unsigned short  disk_no_start;          /* starting disk number */
    unsigned short  internal_attr;          /* internal file attributes */
    unsigned long   external_attr;          /* external file attributes */
    unsigned long   rel_offset_local_hdr;   /* relative offset to local file header */
};

struct End_Of_Central_Dir
{
    unsigned long   sig;
    unsigned short  disk_no;
    unsigned short  disk_with_central_dir_start;
    unsigned short  no_of_entries_this_disk;
    unsigned short  tot_entries;
    unsigned long   size_of_central_dir;
    unsigned long   offset_start_CD;
    unsigned short  comment_length;
};

union sigtest
{
    unsigned long   sig;
    char            ssig[4];
};

union ptr
{
    unsigned long huge *pl;
    unsigned char huge *pc;
};



int get_unarchiver()
{
    int l;
    int c;

    l = 0;

loop:
    c = (int) UNARCHIVER[l];
    UNARCHIVERname[l] = (char) c;
    if(c != ' ')
        if(c)
        {
            l++;
            goto loop;
        }
    UNARCHIVERname[l] = 0;
}

void zip_cat(char *second)
{
    int l;

    l = PATH_LEN - 1;
    if(PATH_IN_ZIP[l] =='\/')
        PATH_IN_ZIP[l] = 0;
    if(*second != '\/')
        strcat(PATH_IN_ZIP, "\/");
    strcat(PATH_IN_ZIP, second);
}


int seek_path(char *name)
{
    int c;

    if(!PATH_LEN)
        return(1);

    if(strnicmp(name, (char *) PATH_IN_ZIP, PATH_LEN) == 0)
    {
        c = name[PATH_LEN];
        if((c == '\\') || (c == '\/'))
            return(1);
    }
    return(0);
}

int ZMAX;

int already_in_zip(char *src, int len)
{
    int i;

    for(i = 0; i < ZMAX; i++)
    {
        if(!strnicmp(REPBUF[i], src, len))
            return(1);
    }

    return(0);
}


int extract_entry
(char *path, char *dest)
{
    int i;
    int c;
    char *src;


    if(strlen(path) <= PATH_LEN)
        return(0);

    src = path + PATH_LEN;
    c = (int) *src;
    if(c == '\\' || c == '\/')
        src++;
    i = -1;

loop:
    i++;
    c = (int) src[i];
    if(c != 0)
        if(c != '\\')
            if(c != '\/')
                if(i < 12)
                {
                    goto loop;
                }

    if(already_in_zip(src, i))
        return(-1);

    strncpy(dest, src, i);
    c = src[i];     /* non zero */
    dest[i] = 0;
    /* if(box("(%s) (%s) (%s) (%d)", path, src, dest, i) == 27) exit(0);*/

    return(c != 0);
}


int push_dir()
{
    if(PATH_LEN)
        zip_cat((char *) REPBUF[NUM]);
    else
        strcpy((char *) PATH_IN_ZIP, (char *) REPBUF[NUM]);

    PATH_LEN = strlen(PATH_IN_ZIP);
    /* box("%d %d %s", PATH_LEN, ZIPlevel, PATH_IN_ZIP);*/
    return(1);
}

int pull_dir()
{
    int l;
    int c;

    l = strlen(PATH_IN_ZIP);
    if(!l)
        return(0);

loop:
    if(--l)
    {
        c = (int) PATH_IN_ZIP[l];
        if(c != '\\')
            if(c != '\/')
                goto loop;
    }

ok:
    PATH_IN_ZIP[l] = 0;
    PATH_LEN = strlen(PATH_IN_ZIP);
    return(1);
}

int zip_opened(int fh)
{
    if(fh == -1)
    {
        BOXBACK = 4;
        box("Enable to open %s", ZIPNAME);
        return(0);
    }
    return(1);
}


void no_header()
{
    BOXBACK = 4;
    box("Header no found, perhaps spaned");
}

int zipit(char filetype[])
{
    int     fh, i, l;
    struct  End_Of_Central_Dir  EOCD;
    struct  Central_Dir         cd;
    char    fname[81];
    char huge *p;
    long    flen;
    long    file_size;
    union   sigtest sg;
    int     rmax;

    rmax = 0;
    TOTAL = 0;

    fh = open((char *) ZIPNAME, O_RDONLY | O_BINARY);
    if(!zip_opened(fh))
        return(-1);

    file_size =  (long) filelength(fh);
    flen =  max(0L , file_size - (long) ARRAYSIZE);
    if(flen)
        lseek(fh, flen, SEEK_SET);

    i = 0;
    l = read(fh, BOXBUF, ARRAYSIZE);
    p = (char huge *) ((long) BOXBUF + (long) l);


    while(l)
    {
        strncpy(sg.ssig, (char *) p, 4);
        if (sg.sig == END_SIG)
            goto skip;
        else
        {
            p--;
            i++;
            l--;
        }
    }

    no_header();
    rmax = -3;
    goto finish;

skip:
    flen = file_size - (long) i;
    lseek(fh, flen, SEEK_SET);

    read(fh, &EOCD, sizeof(struct End_Of_Central_Dir));
    lseek(fh, (long) EOCD.offset_start_CD, SEEK_SET);

    for (i = 0; i < EOCD.tot_entries; i++)
    {
        if(read(fh, &cd, (long) sizeof(struct Central_Dir))
                < sizeof(struct Central_Dir)
                || cd.sig != CENTRAL_SIG)
            goto finish;

        read(fh, (char *) fname, cd.fnamesize);
        fname[cd.fnamesize] = 0;

        if(dir_only((char *) fname))
            goto next;

        ZMAX = rmax;
        if(!seek_path((char *) fname))
            goto next;
        i = extract_entry
            ((char *) fname, REPBUF[rmax]);
        if(i < 0)
            goto next;
        if(i)
            strlwr(REPBUF[rmax]);
        filetype[rmax] = i;

        REPSIZE[rmax] = cd.size;
        TOTAL += cd.size;
        M[rmax] = (unsigned char) ((cd.date >> 5) & 0x0f)-1;
        D[rmax] = (unsigned char) cd.date & 0x1f;
        Y[rmax] = (unsigned char) (cd.date >> 9) & 0x7f;
        lockit[rmax] = ' ' + 10 * (cd.external_attr & 1);
        rmax++;
next:
        lseek(fh, (long) (cd.extra_field_len + cd.file_comment_length), SEEK_CUR);
    }

finish:
    close(fh);
    return(rmax);
}


int zip_size()
{
    int     fh, i, l;
    struct  End_Of_Central_Dir  EOCD;
    struct  Central_Dir         cd;
    char    fname[81];
    char huge *p;
    long    flen;
    long    file_size;
    union   sigtest sg;
    int     rmax;

    TOTAL = 0;
    rmax   = 0;

    fh = open((char *) ZIPNAME, O_RDONLY | O_BINARY);
    if(!zip_opened(fh))
        goto bye;

    file_size =  (long) filelength(fh);
    flen =  max(0L , file_size - (long) ARRAYSIZE);
    if(flen)
        lseek(fh, flen, SEEK_SET);

    i = 0;
    l = read(fh, BOXBUF, ARRAYSIZE);
    p = (char huge *) ((long) BOXBUF + (long) l);

    while(l)
    {
        strncpy(sg.ssig, (char *) p, 4);
        if (sg.sig == END_SIG)
            goto skip;
        else
        {
            p--;
            i++;
            l--;
        }
    }

    no_header();
    rmax = -3;
    goto bye;

skip:
    flen = file_size - (long) i;
    lseek(fh, flen, SEEK_SET);

    read(fh, &EOCD, sizeof(struct End_Of_Central_Dir));
    lseek(fh, (long) EOCD.offset_start_CD, SEEK_SET);

    for (i = 0; i < EOCD.tot_entries; i++)
    {
        if(read(fh, &cd, (long) sizeof(struct Central_Dir))
                < sizeof(struct Central_Dir)
                || cd.sig != CENTRAL_SIG)
            goto bye;

        read(fh, (char *) fname, cd.fnamesize);
        fname[cd.fnamesize] = 0;

        if(dir_only((char *) fname))
            goto next;

        TOTAL += cd.size;
        rmax++;

next:
        lseek(fh, (long) (cd.extra_field_len + cd.file_comment_length), SEEK_CUR);
    }

bye:
    close(fh);
    return(rmax);
}

