#include <stdlib.h>
#include <fcntl.h>
#include <conio.h>

#include "../gui/head.h"
#include "../gui/souris.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/gets18.h"
#include "../gui/vga.h"
#include "../gui/winmove.h"
#include "listgui.h"

int TOP_MOVE = 48;

void dispframe(int x, int y, int w, int h)
{
    mhide();
    xoutline(x, y , x + w - 1, y + h - 1);
    xoutline(x - 1, y - 1, w + x, y + h);
}



int w_adjust(int x, int w)
{
    w = mx - x + 1;
    if(( x + w - 1) > 639)
        w = 640 - x;
    return(w);
}

char move(int *LF, int *UP, int *WI, int *HI, int wmin, int hmin, int wmax, int hmax)
{
    int ch;
    int x, y, w, h;
    int xs, ys, ws, hs;
    int xr, yb;

    xs = min((*LF) << 3, 631);
    ys = min((*UP) << 4, 463);
    ws = (*WI) << 3;
    hs = (*HI) << 4;

    x = xs;
    y = ys;
    w = ws;
    h = hs;

    wmin = wmin << 3;
    hmin = hmin << 4;
    wmax = wmax << 3;
    hmax = hmax << 4;

    TOP_MOVE = (TOP_MOVE + 15) & 0xFFF0;

movloop:
    dispframe(xs, ys, ws , hs);
    yb = ys + hs - 1;
    xr = xs + ws - 1;
    ch = 0;

    if(WITH_MOUSE)
    {
        mshow();
        while(!kbhit())
        {
mloop:
            if(mclick() == 0)
            {
                ch = 13;
                goto cskip;
            }

            switch(MOUSIMAGE)
            {
            case MOUSE_MOVE:
                x = max(mx, 0);
                if(( x + w - 1) > 639)
                    x = 640 - w;
                y = max(my, TOP_MOVE);
                if((y + h - 1) > 479)
                    y = 480 - h;
                if(x == xs)
                    if(y == ys)
                        goto mloop;
                break;

            case  MOUSE_NW:
                x = mx;
                w = xr - x + 1;
                if(w < wmin)
                    x = xr - wmin + 1;
                if(w > wmax)
                    x = xr - wmax + 1;
                w = xr - x + 1;

            case  MOUSE_UP:
                y = max(my, TOP_MOVE);
                h = yb - y + 1;
                if(h < hmin)
                    y = yb - hmin + 1;
                if(h > hmax)
                    y = yb - hmax + 1;
                h = yb - y + 1;
                if(y == ys)
                    if(x == xs)
                        goto mloop;
                break;

            case MOUSE_LEFT:
                x = mx;
                w = xr - x + 1;
                if(w < wmin)
                    x = xr - wmin + 1;
                if(w > wmax)
                    x = xr - wmax + 1;
                w = xr - x + 1;
                if(x == xs)
                    goto mloop;
                break;

            case MOUSE_RIGHT:
                w = w_adjust(xs, w);
                if(w < wmin)
                    w = wmin;
                if(w > wmax)
                    w = wmax;
                if(w == ws)
                    goto mloop;
                break;

            case MOUSE_SE:
                w = w_adjust(xs, w);
                if(w < wmin)
                    w = wmin;
                if(w > wmax)
                    w = wmax;

            case MOUSE_DOWN:
                h = my - ys;
                if((y + h - 1) > 479)
                    h = 480 - y;
                if(h < hmin)
                    h = hmin;
                if(h > hmax)
                    h = hmax;
                if(h == hs)
                    if(w == ws)
                        goto mloop;
                break;
            default:
                break;
            }
            goto cskip;
        }
    }

    ch = get1000();

cskip:
    dispframe(xs, ys, ws, hs);

    if((MOUSIMAGE != MOUSE_MOVE) && (ch > 1000) )
        ch = ch + 1000;

    switch(ch)
    {
    case 1075:
        x = max( 0, x - 8);
        break;
    case 1077:
        if(( x + w - 1 ) < 632)
            x = x + 8;
        break;
    case 1072:
        y = max( y - 16, TOP_MOVE);
        break;
    case 1080:
        y = y + 16;
        if((y + h - 1) > 479)
            y = y - 16;
        break;
    case 2072:
    case 1152:
    case '-':
        h = max(hmin, h - 16);
        break;
    case 2080:
    case 1160:
    case '+':
        if((y + h - 1) < 464)
            h = min(hmax, h + 16);
        break;
    case 2075:
    case 1155:
    case '<':
        w = max( wmin, w - 8);
        break;
    case 1157:
    case 2077:
    case '>':
        if((x + w - 1) < 639)
            w = min( wmax, w + 8);
        break;
    case 9:
    case 27:
    case 13:
        goto suite;
    default:
        break;
    }

    xs = x;
    ys = y;
    ws = w;
    hs = h;
    goto movloop;

suite:
    ws = min(640, ws);
    *LF = xs >> 3;
    *UP = ys >> 4;
    *WI = (ws + 7) >> 3;
    *HI = (hs + 15) >> 4;

    TOP_MOVE = 16;
    WITH_MOUSE = 0;
    newcursor(0);
    return(ch);
}
