
#include <string.h>

#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/souris.h"
#include "../gui/gets18.h"
#include "../gui/drive.h"
#include "../gui/keys.h"
#include "../gui/vga.h"
#include "listgui.h"

int SOUNDFLG=0;
char COLOR16;
char RBACK=7;


void writedir(int x,int y,char *t)
{
    int dssv;
    int sisv;

    asm mov bl,0

    asm push ds

    asm mov ax,CHARSEG
    asm mov dssv,ax
    asm mov ax,CHAROFF
    asm mov sisv,ax


    asm mov dx,03ceh
    asm mov ax,0a05h
    asm out dx,ax

    asm lds si,t

    asm mov ax,y
    asm mov di,x
    asm shr di,3
    asm mov dx,80
    asm mul dx
    asm add di,ax
    asm mov ax,0A000h
    asm mov es,ax
    asm jmp short nextchar

newchar:
    asm push si
    asm push di
    asm push ds
    asm xor ah,ah
    asm shl ax,4
    asm mov si,sisv
    asm mov ds,dssv
    asm add si,ax
    asm mov al,8
    asm mov dx,03ceh
    asm mov cx,16

line:
asm mov  al,ds:
    [si]
    asm xor  ah,ah
    asm shl  ax,4
    asm push ax
    asm mov al,8
asm mov bh,es:
    [di]
    asm out dx,ax
asm mov es:
    [di],bl

    asm pop ax
    asm mov ah,al
    asm mov al,8
    asm out dx,ax
asm mov bh,es:
    [di+1]
    asm out dx,ax
asm mov es:
    [di+1],bl

    asm inc si
    asm add di,80
    asm loop line

    asm pop ds
    asm pop di
    asm pop si
    asm inc di

nextchar:
    asm lodsb
    asm test al,al
    asm jnz newchar
quit:
    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
    asm pop ds
}



void print11(char *txt)
{
    write18(78-strlen(txt), YLOC, txt);
    YLOC++;
}

/*
void BIOSscreen(int mode)
{
asm mov ax,mode
asm xor ah,ah
asm int 0x10
}
 
 
void BIOScolor(int col,int reg)
{
asm mov ax,reg
asm mov bh,al
asm mov ax,col
asm mov bl,al
asm mov ah,010h
asm mov al,0
asm int 010h
}
 
void BIOSborder(char color)
{
 asm mov al,1
 asm mov ah,010h
 asm mov bl,0
 asm mov bh,color
 asm int 010h
}
*/

char FCOLOR = 2;
int LCOL = 0;
char *PADR;

void fastprint(char *t)
{
    int gadr;
    int dssv;
    int sisv;
    unsigned char old;

    asm push ds

    asm mov ax,0A000h
    asm mov es,ax

    asm     mov     dx,03CEh
    asm     mov     ax,0805h
    asm     out     dx,ax
    asm     mov     ax,7
    asm     out     dx,ax
    asm     mov     ah,FCOLOR
    asm     mov     al,02h
    asm     mov     dx,03c4h
    asm     out     dx,ax

    asm mov  dx,LCOL
    asm push dx

    asm mov dx,CHARHIGH
    asm mov gadr,dx
    asm mov ax,CHARSEG
    asm mov dssv,ax
    asm mov ax,CHAROFF
    asm mov sisv,ax

    asm mov ax,YLOC
    asm lds si,t

    asm mul dx
    asm mov dx,80
    asm mul dx
    asm mov di,ax
    asm mov bx,di
    asm add bx,80
    asm pop dx
    asm mov dh,dl
    asm mov old,dl
    asm xor dl,dl
    asm jmp nextchar

newchar:
    asm test dh,dh
    asm jz  newchar1
    asm dec  dh
    asm inc  dl
    asm jmp  nextchar

padline:
    asm dec  si
    asm mov  al,' '

newchar1:
    asm push ds
    asm push si
    asm push di
    asm mov cx,gadr
    asm mul cl
    asm mov si,sisv
    asm mov ds,dssv
    asm add si,ax

line:
    asm movsb
    asm add di,79
    asm loop line

    asm pop di
    asm pop si
    asm pop ds
    asm inc di
    asm inc dl
    asm cmp di,bx
    asm jae quit

nextchar:
    asm  lodsb
    asm  test al,al
    asm  jz   padline

    asm  cmp  al,13
    asm  je   nextchar
    asm  cmp  al,10
    asm  je   nextchar
    asm  cmp  al,1ah
    asm  je   nextchar
    asm  cmp  al,9
    asm  jne  newchar

    asm  mov  al,old
    asm  test al,al
    asm  jz   skcoltab

    asm  mov  ah,dl        /* tab virtuel */
    asm  and  ah,7
    asm  xor  ah,7
    asm  inc  ah

    asm  test dh,dh        /* test si premire colonne */
    asm  jz  headtab

    asm  cmp  dh,ah
    asm  jb   cas2         /* col < 8, a tab */

    asm sub  dh,ah         /* col > 8, col = col - 8 */
    asm add  dl,ah
    asm jmp nextchar

cas2:                     /* col < tab, tab - col  et col = 0 */
    asm sub ah,dh
    asm add dl,dh
    asm xor dh,dh
    asm jmp headtab

skcoltab:
    asm mov ax,di
    asm and al,7
    asm xor al,7
    asm inc al
    asm mov ah,al

headtab:
    asm mov al,0

nextab:
    asm push di
    asm mov cx,gadr
linetab:
    asm stosb
    asm add di,79
    asm loop linetab
    asm pop di

    asm inc di
    asm inc dl
    asm cmp di,bx
    asm jae quit
    asm dec ah
    asm jnz nextab

    asm jmp nextchar

quit:
    asm     mov     dx,03c4h
    asm     mov     ax,0F02h
    asm     out     dx,ax
    asm     mov     dl,0ceh
    asm     mov     ax,0F07h
    asm     out     dx,ax
    asm     mov     ax,5
    asm     out     dx,ax

    asm xor dx,dx
    asm xor ax,ax
next:
asm mov bl,ds:
    [si]
    asm inc si
    asm cmp bl,0
    asm je  nul
    asm cmp bl,10
    asm je  next
    asm cmp bl,13
    asm je  next
    asm cmp bl,1ah
    asm je  nul
    asm mov dx,ds
    asm dec si
    asm mov ax,si
nul:
    asm pop ds
    asm mov word ptr PADR+2,dx
    asm mov word ptr PADR,ax

    asm mov XLOC,1
    asm inc word ptr YLOC

}


void clearback(int line)
{
    asm     .386
    asm 	mov 	ax, 0A000h
    asm 	mov 	es, ax

    asm     mov     dx, 03CEh
    asm     mov     ax, 0805h
    asm     out     dx, ax
    asm     mov     ax, 0007h
    asm     out     dx, ax
    asm     mov     al, 2
    asm	mov     ah, 8
    asm     mov     dx, 03c4h
    asm     out     dx, ax

    asm     mov	ax, line
    asm 	shl	ax, 4
    asm 	mov 	dx, 80
    asm 	mul 	dx
    asm 	mov 	di, ax

    asm	xor	eax, eax
    asm	mov	cx, 320
    asm 	rep 	stosd

quit:
    asm     mov     dx, 03c4h
    asm     mov     ax, 0F02h
    asm     out     dx, ax
    asm     mov     dl, 0ceh
    asm     mov     ax, 0F07h
    asm     out     dx, ax
    asm     mov     ax, 5
    asm     out     dx, ax
}


void fast_x(int x, char *t, char len)
{
    int sisv;

    asm	.386
    asm 	push 	ds

    asm 	mov 	ax, 0A000h
    asm 	mov 	es, ax

    asm     mov     dx, 03CEh
    asm     mov     ax, 0805h
    asm     out     dx, ax
    asm     mov     ax, 7
    asm     out     dx, ax
    asm     mov     ah, 8
    asm     mov     al, 02h
    asm     mov     dx, 03c4h
    asm     out     dx, ax

    asm 	mov  	dx, LCOL
    asm 	push 	dx

    asm 	lfs 	si, t

    asm 	mov 	ax, CHAROFF
    asm 	mov 	sisv, ax
    asm 	mov 	ax, YLOC
    asm 	mov 	ds, CHARSEG

    asm 	shl	ax, 4
    asm 	mov 	dx, 80
    asm 	mul 	dx
    asm 	mov 	di, ax
    asm 	mov 	bx, di
    asm	add	di, x
    asm 	add 	bx, 80
    asm 	pop 	dx

    asm 	mov 	dh, dl
    asm 	xor 	dl, dl
    asm 	jmp 	nextchar

dispchar:
    asm 	test 	dh,dh       /* on skip selon LCOL */
    asm 	jz  	dispchar1

    asm 	dec 	dh
    asm 	inc 	dl          /* colonne suivante */
    asm 	jmp 	nextchar

padline:
    asm 	dec 	si
    asm 	mov 	al, ' '

dispchar1:
    asm 	push	si
    asm 	push	di
    asm 	mov 	cx, 16
    asm	xor	ah, ah
    asm 	shl 	ax, 4
    asm 	mov 	si, sisv
    asm 	add 	si, ax

line:
    asm 	movsb
    asm 	add 	di, 79
    asm 	loop	line

    asm 	pop	di
    asm 	pop	si
    asm 	inc	di
    asm 	inc	dl
    asm 	cmp	di,bx
    asm 	jae	quit

nextchar:
    asm	cmp     byte ptr len, 0
    asm	je      quit
    asm	dec     byte ptr len
asm mov al, fs:
    [si]
    asm	inc	si
    asm 	test 	al, al
    asm 	jz   	padline
    asm 	cmp  	al, 9
    asm 	jne  	dispchar

    asm  	mov  	ah, dl        /* tab virtuel */
    asm  	and  	ah, 7
    asm  	xor  	ah, 7
    asm  	inc  	ah

    asm  	test 	dh, dh       /* test si premire colonne */
    asm  	jz  	headtab      /* LCOL mult de 8 donc ignore pos dp. */

    asm  	cmp  	dh, ah       /* code 9 pos non multiple 8 */
    asm  	jb   	cas2         /* plus de tab que col a passer */

    asm 	sub  	dh, ah       /* moins... dduire les tab */
    asm 	add  	dl, ah
    asm 	jmp 	nextchar

cas2:                        /* col < tab, tab - col  et col = 0 */
    asm 	sub 	ah, dh
    asm 	add 	dl, dh
    asm 	xor 	dh, dh
    asm	test	ah, ah
    asm	jz	nextchar

headtab:
    asm 	mov 	al, 0

nextab:
    asm 	push 	di
    asm 	mov 	cx, 16
linetab:
    asm 	stosb
    asm 	add 	di, 79
    asm 	loop 	linetab

    asm 	pop 	di
    asm 	inc 	di
    asm 	inc 	dl
    asm 	cmp 	di, bx
    asm 	jae 	quit
    asm 	dec 	ah
    asm 	jnz 	nextab
    asm 	jmp 	nextchar

quit:
    asm     mov     dx, 03c4h
    asm     mov     ax, 0F02h
    asm     out     dx, ax
    asm     mov     dl, 0ceh
    asm     mov     ax, 0F07h
    asm     out     dx, ax
    asm     mov     ax, 5
    asm     out     dx, ax
    asm 	pop 	ds
}



/*
   ICON9
   Draw an icon
   (color 9 is the mask)
 
   Affiche une icone
   (la couleur 9 est transparente)
*/



void icon9(int x,int y,char *buf)
{
    int line;
    unsigned char nline;
    unsigned int ctr;
    unsigned char shift;

    asm push ds

    asm lds si,buf
    asm lodsw
    asm mov nline,al
    asm lodsw
    asm mov ctr,ax
    asm inc si
    asm inc si

    asm mov ax,y
    asm mov dx,80
    asm mul dx
    asm mov di,095b0h
    asm sub di,ax
    asm mov ax,x
    asm mov cl,al
    asm shr ax,3
    asm add di,ax
    asm mov line,di
    asm and cl,7
    asm mov shift,cl

    asm mov dx, 03ceh
    asm mov ax, 0205h
    asm out dx, ax
    asm mov ax, 0a000h
    asm mov es, ax

    asm mov al,8

line:
    asm mov di,line
    asm mov cl,shift
    asm mov ah,128
    asm ror ah,cl
    asm mov cx,ctr

col:
    asm  out    dx,ax
asm  mov    bl,es:
    [di]
asm  mov    bl,ds:
    [si]
    asm  inc    si
    asm  mov    bh,bl
    asm  shr    bl,4
    asm  cmp    bl, 9
    asm  je     skip
asm  mov    es:
    [di],bl
skip:
    asm  ror    ah,1
    asm  adc    di,0

    asm  dec    cx
    asm  jz     fincol

    asm  out    dx,ax
asm  mov    bl,es:
    [di]
    asm  and    bh,0xf
    asm  cmp    bh, 9
    asm  je     skip2
asm  mov    es:
    [di],bh
skip2:
    asm  ror    ah,1
    asm  adc    di,0
    asm  loop   col

fincol:
    asm  sub    word ptr line,80
    asm  dec    byte ptr nline
    asm  jnz    line

okexit:
    asm mov ax, 5
    asm out dx, ax
    asm mov ax, 0ff08h
    asm out dx, ax
    asm pop ds
}



void setgreen()
{
    /* couleur 6  */
    asm mov ax,01010h
    asm mov bx,6
    asm mov dh,0
    asm mov ch,42
    asm mov cl,0
    asm int 010h


    asm mov ax,01000h
    asm mov bh,6
    asm mov bl,bh
    asm int 010h

    /* couleur 2 */
    asm mov ax,01010h
    asm mov bx,2
    asm mov dh,0
    asm mov ch,42
    asm mov cl,0
    asm int 010h

    asm mov ax,01000h
    asm mov bh,2
    asm mov bl,bh
    asm int 010h

    /* couleur 8 */
    asm mov ax,01010h
    asm mov bx,8
    asm mov dh,34
    asm mov ch,34
    asm mov cl,34
    asm int 010h

    asm mov ax,01000h
    asm mov bh,8
    asm mov bl,bh
    asm int 010h

    /* couleur 10 */
    asm mov ax,01010h
    asm mov bx,10
    asm mov dh,21
    asm mov ch,63
    asm mov cl,21
    asm int 010h

    asm mov ax,01000h
    asm mov bh,10
    asm mov bl,bh
    asm int 010h

}

void setamber()
{

    /* couleur 6  */
    asm mov ax,01010h
    asm mov bx,6
    asm mov dh,58
    asm mov ch,40
    asm mov cl,0
    asm int 010h

    asm mov ax,01000h
    asm mov bh,6
    asm mov bl,bh
    asm int 010h

    /* couleur 2  */
    asm mov ax,01010h
    asm mov bx,2
    asm mov dh,58
    asm mov ch,40
    asm mov cl,0
    asm int 010h

    asm mov ax,01000h
    asm mov bh,2
    asm mov bl,bh
    asm int 010h

    /* couleur 8 */
    asm mov ax,01010h
    asm mov bx,8
    asm mov dh,34
    asm mov ch,34
    asm mov cl,34
    asm int 010h

    asm mov ax,01000h
    asm mov bh,8
    asm mov bl,bh
    asm int 010h

    /* couleur 10 */
    asm mov ax,01010h
    asm mov bx,10
    asm mov dh,63
    asm mov ch,48
    asm mov cl,21
    asm int 010h

    asm mov ax,01000h
    asm mov bh,10
    asm mov bl,bh
    asm int 010h

}

void setpal(int col)
{
    switch(col)
    {
    case 1:
        setgreen();
        break;
    case 2:
        setamber();
        break;
    }
}


void clearpage(char FCOLOR)
{
    asm 	mov 	ax,	0A000h
    asm 	mov 	es,	ax

    asm     mov     dx,03CEh
    asm     mov     ax,0805h
    asm     out     dx,ax
    asm     mov     ax,7
    asm     out     dx,ax

    asm     mov     ah,FCOLOR
    asm     mov     al,02h
    asm     mov     dx,03c4h
    asm     out     dx,ax

    asm  	mov	di, 4320 - 80
    asm 	mov 	cx, 19200 - 2160 + 80
    asm 	xor 	ax, ax
    asm 	rep 	stosw

    asm     mov     ax,0F02h
    asm     out     dx,ax
    asm     mov     dl,0ceh
    asm     mov     ax,0F07h
    asm     out     dx,ax
    asm     mov     ax,5
    asm     out     dx,ax
}




void getBPsprite(int xl,int yb,int xr,int yt,char *BUFFER)
{

    asm     push    ds
    asm     mov     ax, yb
    asm     mov     cx, yt
    asm     cmp     ax, cx
    asm     jbe     skswap
    asm     xchg    ax, cx
skswap:
    asm     sub     cx, ax
    asm     inc     cx

    asm     mov     dx,80
    asm     mul     dx
    asm     mov     si, 095b0h
    asm     sub     si, ax
    asm     mov     dx, xl
    asm     mov     ax, dx
    asm     shr     ax, 3
    asm     add     si, ax

    asm     mov     ax, 0A000h
    asm     mov     ds, ax

    asm     les     di, BUFFER
    asm     mov     ax, cx
    asm     stosw
    asm     mov     ax, xr
    asm     sub     ax, dx
    asm     inc     ax
    asm     add     ax, 7
    asm     shr     ax, 3
    asm     mov     bp, ax
    asm     stosw
    asm     mov     al, 3
    asm     stosb
    asm     inc     di

    asm     mov     dx,03CEh

row:
    asm     push    cx
    asm     mov     ax, 0304h

page:
    asm     out     dx,ax
    asm     mov     cx, bp
    asm     push    si
    asm     shr     cx,1
    asm     rep     movsw
    asm     rcl     cx, 1
    asm     rep     movsb
    asm     pop     si

skipage:
    asm     dec     ah
    asm     jns     page

    asm     pop     cx
    asm     sub     si, 80
    asm     loop    row

    asm     pop     ds
};



void fastBPsprite(int x,int y,char *spriteadr)
{
    asm     mov     ax, 0A000h
    asm     mov     es, ax
    asm     push    ds

    asm     mov     ax, y
    asm     mov     dx, 80
    asm     mul     dx
    asm     mov     di, 095b0h
    asm     sub     di, ax
    asm     mov     dx, x
    asm     shr     dx, 3
    asm     add     di, dx

    asm     lds     si, spriteadr
    asm     lodsw
    asm     mov     cx, ax
    asm     lodsw
    asm     mov     bx, ax
    asm     inc     si
    asm     inc     si

    asm     mov     dx, 03CEh
    asm     mov     ax, 0805h
    asm     out     dx, ax
    asm     mov     ax, 7
    asm     out     dx, ax
    asm     mov     dx, 03c4h


line:
    asm     mov     bp, cx
    asm     mov     ax, 0802h

page:
    asm     out     dx, ax
    asm     mov     cx, bx
    asm     push    di
    asm     shr     cx, 1
    asm     rep     movsw
    asm     rcl     cx, 1
    asm     rep     movsb
    asm     pop     di
    asm     shr     ah, 1
    asm     jnz     page

    asm     mov     cx, bp
    asm     sub     di, 80
    asm     loop    line

    asm     mov     ah,0Fh
    asm     out     dx,ax

    asm     mov     dl,0ceh
    asm     mov     al,07
    asm     out     dx,ax
    asm     mov     ax,5
    asm     out     dx,ax

    asm     pop     ds
};



void mouse16(int col,int y,char *pointer)
{
    asm     mov     ax, 0a000h
    asm     mov     es,ax
    asm     push    ds

    asm     mov     di, col
    asm     mov     ax, 80
    asm     mul     word ptr y
    asm     add     di, ax

    asm     mov     dx, 03CEh
    asm     mov     ax, 0805h
    asm     out     dx, ax
    asm     mov     ax, 7
    asm     out     dx, ax
    asm     mov     dx, 03c4h

    asm     lds     si, pointer
    asm     mov     cx, 16

row:
asm     mov     bx, ds:
    [si]
asm     or      bx, ds:
    [si+32]
    asm     inc     si
    asm     inc     si
    asm     xchg    bh, bl
    asm     mov     ax, 0802h

page:
    asm     out     dx, ax
asm     mov     es:
    [di], bx
    asm     shr     ah,1
    asm     jnz     page

    asm     add     di, 80
    asm     loop    row


    asm     mov     ah, 0Fh
    asm     out     dx, ax
    asm     mov     dl, 0ceh
    asm     mov     al, 07
    asm     out     dx, ax
    asm     mov     ax, 5
    asm     out     dx, ax

    asm     pop     ds
};


void dispmouse()
{
    mouse16(LMOUSE8 + 4, TMOUSE, (char *) FLECHE);
    mouse16(LMOUSE8 + 8, TMOUSE, (char *) TAGMOUSE);
}


int testlong(int no)
{
    asm	mov bx,no
    asm	shl bx,1
asm	mov ax,word ptr DGROUP:
    longx[bx]
asm	mov dx,word ptr DGROUP:
    longy[bx]
    asm     mov bx,ax

    asm     mov ax,mx
    asm     cmp ax,bx
    asm     jb non

    asm     mov cx,bx
    asm     add cx,79
    asm     cmp ax,cx
    asm     ja  non

    asm     mov ax,my
    asm     cmp ax,dx
    asm     jb  non

    asm     mov cx,dx
    asm     add cx,19
    asm     cmp ax,cx
    asm     ja  non

    PRESS = 1;
    key8(no);
    delay2(200);
    PRESS = 0;
    key8(no);
    return(1);
non:
    return(0);
}

void bigc(int col,int line,char c)
{
    asm mov bl,PENCOL

    asm push ds

    asm  mov cx,CHARHIGH

    asm  mov  ax,line
    asm  mov  di,col
    asm  shl  ax,4
    asm  mov  dx,80
    asm  mul  dx
    asm  add  di,ax

    asm  mov si,CHAROFF
    asm  mov ds,CHARSEG
    asm  mov al,c
    asm  mul cl
    asm  add si,ax

    asm  mov  ax,0A000h
    asm  mov  es,ax

    asm  mov  dx,03ceh
    asm  mov  ax,0a05h
    asm  out  dx,ax

line:
    asm push cx
    asm push di
    asm lodsb
    asm mov bh,al
    asm mov ch,al
    asm shr bh,4
    asm shl ch,4
    asm or  bh,ch
    asm mov ch,8

column1:
    asm xor cl,cl
column:
    asm mov ah,bh
    asm shr bh,1
    asm and ah,1
    asm shl ah,cl
    asm mov al,ah
    asm shl ah,1
    asm or  ah,al

    asm mov al,8
    asm out dx,ax
asm or  es:
    [di],bl
asm or  es:
    [di+80],bl

    asm inc cl
    asm inc cl
    asm dec ch

    asm cmp cl,7
    asm jb  column
    asm inc di
    asm test ch,ch
    asm jnz column1

    asm pop di
    asm pop cx
    asm add di,160
    asm loop line

    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax

    asm pop ds
}



char dirtable[]={
                    0,1,2,3,4,5,6,7,8,9,0,11,12,0,14,15,
                    16,17,18,19,20,21,22,23,24,25,26,'','','','','',
                    ' ',
                    '!',
                    '\"',
                    '#',
                    '$',
                    '%',
                    '&',
                    '\'',
                    '(',
                    ')',
                    '*',
                    '+',
                    ',',
                    '-',
                    '.',
                    '/',
                    '0',
                    '1',
                    '2',
                    '3',
                    '4',
                    '5',
                    '6',
                    '7',
                    '8',
                    '9',
                    ':',
                    ';',
                    '<',
                    '=',
                    '>',
                    '?',
                    '@',
                    'a',
                    'b',
                    'c',
                    'd',
                    'e',
                    'f',
                    'g',
                    'h',
                    'i',
                    'j',
                    'k',
                    'l',
                    'm',
                    'n',
                    'o',
                    'p',
                    'q',
                    'r',
                    's',
                    't',
                    'u',
                    'v',
                    'w',
                    'x',
                    'y',
                    'z',
                    '[',
                    '\\',
                    ']',
                    '^',
                    '-',
                    '`',
                    'a',
                    'b',
                    'c',
                    'd',
                    'e',
                    'f',
                    'g',
                    'h',
                    'i',
                    'j',
                    'k',
                    'l',
                    'm',
                    'n',
                    'o',
                    'p',
                    'q',
                    'r',
                    's',
                    't',
                    'u',
                    'v',
                    'w',
                    'x',
                    'y',
                    'z',
                    '{',
                    '|',
                    '}',
                    '~',
                };


int BBS_cmp(const char *nomfic, const char *str2, int slen)
{
    asm     les    si, nomfic
    asm     mov    cx, es         /* cx = str1 segment */
    asm     les    di, str2
    asm     mov    dx, es         /* dx = str2 segment */

    asm     xor    ax, ax         /* zero until the end */
    asm     xor    bx, bx
    asm     mov    bp, slen

next:
    asm	test   bp, bp
    asm	jz     bye
    asm	dec    bp

    asm     mov   es, cx
asm     mov   bl, es:
    [si]
asm     mov   al, ds:
    [bx+dirtable]     /* al = str1[i]   */
    asm     inc   si

    asm     mov   es, dx
asm     mov   bl, es:
    [di]
asm     mov   bl, ds:
    [bx+dirtable]      /* bl = str2[i]   */
    asm     inc   di

    asm     test  al, al
    asm     jz    bye

    asm     cmp    al, bl        /* str1[i] == str2[i] */
    asm     je     next

bye:                         /*  ah, ch still 0 */
    asm     sub     ax, bx
}
