

extern char BACKCOL;  /*  Background writing color*/
extern char PENCOL;   /*  Text color              */

/* color for string input */
extern char TEXTBACK;
extern char TEXTCOL;

extern int CHARHIGH;
extern int CHARSEG;
extern int CHAROFF;
extern int XLOC;
extern int YLOC;


/*
   FONTDEFAULT
   Set the VGA standard font
*/

void fontdefault();

/*
   FONTSELECT
   Set an user font for writing functions of this library
   Input: font address
*/

void fontselect(unsigned char *font);

/*
   GETnXn
   SETxXn
   Get addresses of BIOS fonts,
   Set addresses to font variables
   Heights: 8, 14, 16 pix.
*/


void get8x8();
void set8x8();

void get8x14();
void set8x14();

void get8x16();
void set8x16();


/*
   WRITEONXY
   Write a string at x, y  keep background
   x = 0..632
   y = 0..464
   Use PENCOL
*/

void writeonxy(int x,int y,char *t);  /* with underline */
void writeonxy2(int, int, char *);    /* no underline */
void writeoncxy(int x,int y,char c);

/*
   WRITEXY
   Write a string at x, y, erase background
   x = 0..632
   y = 0..464
   Use BACKCOL, PENCOL
*/

void writexy(int x,int y,char *t);

/*
   WRITEFXY
   Write a formated string at x, y, erase background
   x = 0..632
   y = 0..464
   Use BACKCOL, PENCOL
*/


void writefxy(int x, int y, char *fmt, ... );

/*
   WRITE18
   Write a string at column, row
   Column = 0..79
   Row = 0..29
   Use BACKCOL, PENCOL
*/

void write18(int col,int row,char *t);
void writeon18(int col, int row, char *t);
void writef18(int c,int l,char *fmt, ... );

void locate(int c, int l);
void writecxy(int ,int , char);     /* char x, y graph. */
void writec18(int, int, char);           /* char col, line */
void print(char *);                 /* disp lines at cursor */
void printc(char);                     /* put char at cursor */
void center(int, char *);
void textcol(char, char);


