#include <io.h>
#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "../gui/head.h"
#include "../gui/souris.h"
#include "../gui/vgalib.h"
#include "../gui/vga.h"
#include "../gui/texte.h"

char BACKCOL=0;
char PENCOL=7;

char TEXTBACK=15;
char TEXTCOL= 0;

int XLOC = 1;
int YLOC = 1;


int CHARHIGH=16;
int CHARSEG;
int CHAROFF;

void fontdefault()
{
    asm push ds
    asm mov ax,40h
    asm mov ds,ax
asm mov cx,ds:
    [85h]
    asm xor al,al
    asm mov es,ax
    asm mov bx,43h*4
asm lds si,es:
    [bx]
    asm mov ax,ds
    asm pop ds
    asm mov CHARHIGH,cx
    asm mov CHARSEG,ax
    asm mov CHAROFF,si
}


void fontselect(unsigned char *fonte)
{
    asm les di,fonte
    asm mov ax,es
    asm mov CHARSEG,ax
    asm mov CHAROFF,di
    asm mov CHARHIGH, 16
}


int CHARSEG8;
int CHAROFF8;

void get8x8()
{
    asm mov ah, 011h
    asm mov al, 030h
    asm mov bh, 3
    asm int 010h
    asm mov CHARSEG8, es
    asm mov CHAROFF8, bp
}

void set8x8()
{
    CHARSEG = CHARSEG8;
    CHAROFF = CHAROFF8;
    CHARHIGH = 8;
}

int CHARSEG14;
int CHAROFF14;

void get8x14()
{
    asm mov ah, 011h
    asm mov al, 030h
    asm mov bh, 2
    asm int 010h
    asm mov CHARSEG14, es
    asm mov CHAROFF14, bp
}

void set8x14()
{
    CHARSEG = CHARSEG14;
    CHAROFF = CHAROFF14;
    CHARHIGH = 14;
}

int CHARSEG16;
int CHAROFF16;

void get8x16()
{
    asm mov ah, 011h
    asm mov al, 030h
    asm mov bh, 6
    asm int 010h
    asm mov CHARSEG16, es
    asm mov CHAROFF16, bp
}

void set8x16()
{
    CHARSEG = CHARSEG16;
    CHAROFF = CHAROFF16;
    CHARHIGH = 16;
}


/* ecrit en x, y, avec underbar, sans fond */

void writeonxy(int x,int y, char *t)
{
    int gadr;
    int dssv;
    int sisv;

    asm mov bl,PENCOL

    asm push ds

    asm mov ax,CHARHIGH
    asm mov gadr,ax
    asm mov ax,CHARSEG
    asm mov dssv,ax
    asm mov ax,CHAROFF
    asm mov sisv,ax


    asm lds si,t

    asm mov ax,y
    asm mov cx,x
    asm mov di,cx
    asm shr di,3
    asm mov dx,80
    asm mul dx
    asm add di,ax
    asm mov ax,0A000h
    asm mov es,ax

    asm mov dx, 03ceh
    asm mov ax, 0a05h
    asm out dx, ax

    asm and cl, 7
    asm xor cl, 7
    asm mov bh, cl
    asm jmp short nextchar

newchar:
    asm cmp  al,'_'
    asm jne  new2
    asm dec  di

new2:
    asm push si
    asm push di
    asm push ds
    asm mov ah,0
    asm mov cx,gadr
    asm mul cl
    asm mov si,sisv
    asm mov ds,dssv
    asm add si,ax

line:
    asm push cx
    asm mov  cl, bh
asm mov  al, ds:
    [si]
    asm xor  ah, ah
    asm shl  ax, cl
    asm mov  ch, al
    asm mov  al, 8
    asm out  dx, ax
asm mov  ah, es:
    [di]
asm mov  es:
    [di], bl

    asm mov  ah, ch
    asm out  dx, ax
asm mov  ah, es:
    [di+1]
asm mov  es:
    [di+1], bl

    asm pop  cx
    asm inc  si
    asm add  di, 80
    asm loop line

    asm pop ds
    asm pop di
    asm pop si
    asm inc di

nextchar:
    asm lodsb
    asm test al,al
    asm jnz  newchar

quit:
    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
    asm pop ds
}


void writeonxy2(int x,int y,char *t)  /* sans underbar */
{
    int gadr;
    int dssv;
    int sisv;

    asm mov bl,PENCOL

    asm push ds

    asm mov ax,CHARHIGH
    asm mov gadr,ax
    asm mov ax,CHARSEG
    asm mov dssv,ax
    asm mov ax,CHAROFF
    asm mov sisv,ax

    asm lds si,t

    asm mov ax,y
    asm mov cx,x
    asm mov di,cx
    asm shr di,3
    asm mov dx,80
    asm mul dx
    asm add di,ax
    asm mov ax,0A000h
    asm mov es,ax

    asm mov dx, 03ceh
    asm mov ax, 0a05h
    asm out dx, ax

    asm and cl, 7
    asm xor cl, 7
    asm mov bh, cl
    asm jmp short nextchar

newchar:
    asm push si
    asm push di
    asm push ds
    asm mov ah,0
    asm mov cx,gadr
    asm mul cl
    asm mov si,sisv
    asm mov ds,dssv
    asm add si,ax

line:
    asm push cx
    asm mov  cl, bh
asm mov  al, ds:
    [si]
    asm xor  ah, ah
    asm shl  ax, cl
    asm mov  ch, al
    asm mov  al, 8
    asm out  dx, ax
asm mov  ah, es:
    [di]
asm mov  es:
    [di], bl

    asm mov  ah, ch
    asm out  dx, ax
asm mov  ah, es:
    [di+1]
asm mov  es:
    [di+1], bl

    asm pop  cx
    asm inc  si
    asm add  di, 80
    asm loop line

    asm pop ds
    asm pop di
    asm pop si
    asm inc di

nextchar:
    asm lodsb
    asm cmp al,1
    asm je nextchar
    asm test al,al
    asm jnz  newchar

quit:
    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
    asm pop ds
}



/* ecrit en x, y,  et avec fond */

void writexy(int x,int y,char *t)
{
    char gadr;
    int dssv;
    int sisv;
    char SHIFT;

    asm mov bh, BACKCOL
    asm mov bl, PENCOL

    asm push ds

    asm mov ax, CHARHIGH
    asm mov gadr, al
    asm mov ax, CHARSEG
    asm mov dssv, ax
    asm mov ax, CHAROFF
    asm mov sisv, ax

    asm lds si, t

    asm mov ax, y
    asm mov cx, x
    asm mov di, cx
    asm shr di, 3
    asm mov dx, 80
    asm mul dx
    asm add di, ax
    asm mov ax, 0A000h
    asm mov es, ax

    asm mov dx, 03ceh
    asm mov ax, 0a05h
    asm out dx, ax

    asm and cl, 7
    asm xor cl, 7
    asm mov SHIFT, cl
    asm jmp short nextchar

newchar:
    asm push si
    asm push di
    asm push ds

    asm mov ch, gadr
    asm mul ch
    asm mov si, sisv
    asm mov ds, dssv
    asm add si, ax

    asm mov cl, SHIFT

line:
    asm push cx

    asm mov  ax, 000FFh
    asm shl  ax, cl
    asm mov  ch, al
    asm mov  al, 8
    asm out  dx,ax
asm mov  ah, es:
    [di]
asm mov  es:
    [di], bh

    asm mov  ah, ch
    asm out  dx, ax
asm mov  ah, es:
    [di+1]
asm mov  es:
    [di+1], bh

asm mov  al, ds:
    [si]
    asm xor  ah, ah
    asm shl  ax, cl
    asm mov  ch, al
    asm mov  al, 8
    asm out  dx, ax
asm mov  ah, es:
    [di]
asm mov  es:
    [di], bl

    asm mov  ah, ch
    asm out  dx, ax
asm mov  ah, es:
    [di+1]
asm mov  es:
    [di+1], bl

    asm pop  cx
    asm inc  si
    asm add  di, 80
    asm dec  ch
    asm jnz line

    asm pop ds
    asm pop di
    asm pop si
    asm inc di

nextchar:
    asm lodsb
    asm test al,al
    asm jnz  newchar

quit:
    asm mov ax, 0ff08h
    asm out dx, ax
    asm mov ax, 5
    asm out dx, ax
    asm pop ds
}


void writefxy(int x, int y, char *fmt, ... )
{
    va_list  argptr;
    char STRBUF[256];

    va_start(argptr, fmt);
    vsprintf((char *) STRBUF, fmt, argptr);
    writexy(x, y, STRBUF);
    va_end(argptr);
}


void write18(int col,int row,char *t)
{
    int hchar;
    int sisv;

    asm .386

    asm mov bl,PENCOL
    asm mov bh,BACKCOL

    asm push ds

    asm mov ax,CHARHIGH
    asm mov hchar,ax
    asm mov ax,CHARSEG
    /* asm mov dssv,ax */
    asm mov fs, ax
    asm mov ax,CHAROFF
    asm mov sisv,ax


    asm mov dx,03ceh
    asm mov ax,0a05h
    asm out dx,ax

    asm lds si,t

    asm mov ax,row
    asm mov di,col
    asm dec ax
    asm dec di
    asm shl ax,4
    asm mov dx,80
    asm mul dx
    asm add di,ax

    asm mov ax,0A000h
    asm mov es,ax
    asm mov dx, 03ceh
    asm jmp testcar

newchar:
    /* asm push ds */
    asm push si
    asm push di

    asm xor ah, ah     /* al code car. */
    asm mov cx ,hchar
    asm mul cl
    asm mov si, sisv
    asm add si, ax

    /* asm mov ds, dssv */
    asm mov al, 8

line:
    asm mov ah, 255
    asm out dx, ax
asm mov es:
    [di],bh

asm mov ah, es:
    [di]
asm mov ah, fs:
    [si]
    asm out dx, ax
asm mov es:
    [di],bl

    asm inc si
    asm add di,80
    asm loop line

    asm pop di
    asm pop si
    /* asm pop ds */
    asm inc di

testcar:
    asm lodsb
    asm test al,al
    asm jnz newchar

quit:
    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
    asm pop ds
}


void locate(int c,int l)
{
    if((c < 1) || (c > 80))
        c = 1;
    if((l < 1) || (l > 30))
        l = 1;
    XLOC = c;
    YLOC = l;
}


void writecxy(int x,int y,char c)
{
    char SHIFT;

    asm mov bl,PENCOL
    asm mov bh,BACKCOL

    asm push ds

    asm  mov  ax, y
    asm  mov  cx, x
    asm  mov  di, cx
    asm  shr  di, 3
    asm  mov  dx, 80
    asm  mul  dx
    asm  add  di, ax

    asm  and cl, 7
    asm  xor cl, 7
    asm  mov SHIFT,cl

    asm  mov  cx, CHARHIGH
    asm  mov  si, CHAROFF
    asm  mov  ds, CHARSEG
    asm  mov  al, c
    asm  xor  ah, ah
    asm  mul  cl
    asm  add  si, ax

    asm  mov  ax, 0A000h
    asm  mov  es, ax

    asm  mov  dx, 03ceh
    asm  mov  ax, 0a05h
    asm  out  dx, ax

row:
    asm push  cx
    asm mov   cl, SHIFT

    asm mov   ax, 0FFh
    asm shl   ax, cl
    asm mov   ch, al
    asm mov   al, 8
    asm out   dx, ax
asm mov   ah, es:
    [di]
asm mov   es:
    [di], bh
    asm mov   ah, ch
    asm out   dx, ax
asm mov   ah, es:
    [di+1]
asm mov   es:
    [di+1], bh

asm mov   al, ds:
    [si]
    asm xor   ah, ah
    asm shl   ax, cl
    asm mov   ch, al
    asm mov   al, 8
    asm out   dx, ax
asm mov   ah, es:
    [di]
asm mov   es:
    [di], bl
    asm mov   ah, ch
    asm out   dx,ax
asm mov   ah,es:
    [di+1]
asm mov   es:
    [di+1],bl

    asm pop cx
    asm inc si
    asm add di,80
    asm loop row

    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax

    asm pop ds
}


void writeoncxy(int x,int y,char c)
{
    char SHIFT;

    asm mov bl,PENCOL

    asm push ds

    asm  mov  ax,y
    asm  mov  cx,x
    asm  mov  di,cx
    asm  shr  di,3
    asm  mov  dx,80
    asm  mul  dx
    asm  add  di,ax

    asm  and cl,7
    asm  xor cl,7
    asm  mov SHIFT,cl

    asm  mov  cx,CHARHIGH
    asm  mov  si,CHAROFF
    asm  mov  ds,CHARSEG
    asm  mov al,c
    asm  xor ah,ah
    asm  mul cl
    asm  add si,ax

    asm  mov  ax,0A000h
    asm  mov  es,ax

    asm  mov  dx,03ceh
    asm  mov  ax,0a05h
    asm  out  dx,ax

row:
    asm push cx
    asm mov  cl, SHIFT
asm mov  al, ds:
    [si]
    asm xor  ah, ah
    asm shl  ax, cl
    asm mov  ch, al
    asm mov  al, 8
    asm out  dx, ax
asm mov  bh, es:
    [di]
asm mov  es:
    [di],bl

    asm mov  ah, ch
    asm out  dx, ax
asm mov  bh,es:
    [di+1]
asm mov  es:
    [di+1],bl

    asm pop cx
    asm inc si
    asm add di,80
    asm loop row

    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax

    asm pop ds
}


void writec18(int col,int row,char chr)
{
    asm mov bl,PENCOL
    asm mov bh,BACKCOL

    asm push ds

    asm mov dx,03ceh
    asm mov ax,0a05h
    asm out dx,ax

    asm mov ax,row
    asm mov di,col
    asm dec ax
    asm dec di
    asm shl ax,4
    asm mov dx,80
    asm mul dx
    asm add di,ax
    asm mov ax,0A000h
    asm mov es,ax

    asm mov  al, chr
    asm test al,al
    asm jz   quit
    asm mov  ah,0
    asm mov  cx,CHARHIGH
    asm mul  cl
    asm mov  si,CHAROFF
    asm mov  ds,CHARSEG
    asm add  si,ax

    asm mov  al,8
    asm mov  dx,03ceh

rowline:
    asm mov ah,255
    asm out dx,ax
asm mov es:
    [di],bh

asm mov ah,es:
    [di]
asm mov ah,ds:
    [si]
    asm out dx,ax
asm mov es:
    [di],bl

    asm inc si
    asm add di,80
    asm loop rowline

quit:
    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
    asm pop ds
}



void writeon18(int col, int row, char *t)
{
    int gadr;
    int sisv;

    asm .386

    asm mov bl,PENCOL
    asm push ds

    asm mov ax,CHARHIGH
    asm mov gadr,ax

    asm mov ax,CHARSEG
    /* asm mov dssv,ax */
    asm mov fs, ax
    asm mov ax,CHAROFF
    asm mov sisv,ax

    asm mov dx,03ceh
    asm mov ax,0a05h
    asm out dx,ax

    asm lds si,t

    asm mov ax, row
    asm mov di, col
    asm dec ax
    asm dec di
    asm shl ax,4
    asm mov dx,80
    asm mul dx
    asm add di,ax
    asm mov ax,0A000h
    asm mov es,ax
    asm jmp short nextchar

newchar:
    /* asm push ds*/
    asm push si
    asm push di
    asm mov ah,0
    asm mov cx,gadr
    asm mul cl
    asm mov si,sisv
    /* asm mov ds,dssv */
    asm add si,ax
    asm mov al,8
    asm mov dx,03ceh

line:
asm mov ah,es:
    [di]
asm mov ah,fs:
    [si]
    asm out dx,ax
asm mov es:
    [di],bl
    asm inc si
    asm add di,80
    asm loop line

    asm pop di
    asm pop si
    /* asm pop ds */
    asm inc di

nextchar:
    asm lodsb
    asm test al,al
    asm jnz newchar

quit:
    asm mov ax,0ff08h
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
    asm pop ds
}



void writef18(int c,int l,char *fmt, ... )
{
    va_list  argptr;
    char STRBUF[256];

    va_start( argptr, fmt );
    vsprintf((char *) STRBUF, fmt, argptr );
    write18(c, l, (char *) STRBUF);
    va_end( argptr );
}


void print(char *txt)
{
    write18(XLOC, YLOC, txt);
    XLOC += strlen(txt);
    while(XLOC > 80)
    {
        XLOC -=80;
        YLOC++;
    }
    if(YLOC > 30)
        YLOC = 30;
    locate(XLOC, YLOC);
}

void printc(char c)
{
    writec18(XLOC++,YLOC,c);
}

void textcol(char b,char p)
{
    asm mov al,b
    asm mov BACKCOL,al
    asm mov al,p
    asm mov PENCOL,al
}


void center(int line, char *msg)
{
    write18((40 - strlen(msg) / 2),line,msg);
}


/* ecrit en x, y le  fond  seul */

void writepad(int x,int y, char slen)
{
    asm mov bh, BACKCOL
    asm mov si, slen

    asm mov ax, y
    asm mov cx, x
    asm mov di, cx
    asm shr di, 3
    asm mov dx, 80
    asm mul dx
    asm add di, ax
    asm mov ax, 0A000h
    asm mov es, ax

    asm mov dx,03ceh
    asm mov ax,0a05h
    asm out dx,ax

    asm and cl, 7
    asm xor cl, 7

nextchar:
    asm push di
    asm mov ch, 16

row:
    asm mov  ax, 0FFh
    asm shl  ax, cl
    asm mov  bl, al
    asm mov  al, 8
    asm out  dx, ax
asm mov  ah, es:
    [di]
asm mov  es:
    [di], bh

    asm mov  ah, bl
    asm out  dx, ax
asm mov  ah, es:
    [di+1]
asm mov  es:
    [di+1], bh

    asm add  di, 80
    asm dec  ch
    asm jnz  row

    asm pop  di
    asm inc  di
    asm dec  si
    asm jne  nextchar

    asm mov ah,0ffh
    asm out dx,ax
    asm mov ax,5
    asm out dx,ax
}

