
#include <stdlib.h>
#include <conio.h>
#include <string.h>

#include "../gui/head.h"
#include "../gui/gets18.h"
#include "../gui/souris.h"
#include "../gui/vga.h"
#include "../gui/design.h"
#include "../gui/texte.h"
#include "../gui/popwin.h"
#include "../gui/lift.h"
#include "../gui/scroll.h"
#include "../gui/alt.h"
#include "listgui.h"


char SCROLLBACK = 15;
char SCROLLPEN = 0;
int SCROLL_START;
char SCROLL_WIDTH;
char SCROLL_TXT_WIDTH = 80;


void design_cadre(int col, int line, int size, int button, char *txt)
{
    int xl;
    int yb;
    int xr;
    int yt;

    xl = ((WL + col)  << 3) - 1;
    yt = ((WU + line) << 4);
    xr = xl + (size << 3) + 8;
    yb = yt + 15;

    rectangle18(xl - 1, yt - 1, xr + 1, yb + 1, 0);
    bar18(xl, yt, xr, yb, SCROLLBACK);

    writeonxy((WL + col) << 3, ((WU + line) << 4 ) - 18, txt);
    if(button)
        putkey16(WL + col + size, WU + line + 1, button);
}


void scrollbar(int num, char *scrolltexte, char mode)
{
    int x, y;
    int l, l2;
    char *texte;

    texte = scrolltexte + num * SCROLL_TXT_WIDTH;
    x = (WL << 3) + 16;
    y = (WU << 4) + 10 + ((num - SCROLL_START) << 4);

    if(mode)
    {
        BACKCOL = SCROLLPEN;
        PENCOL  = SCROLLBACK;
    }
    else
    {
        BACKCOL = SCROLLBACK;
        PENCOL = SCROLLPEN;
    }

    l = strlen(texte);
    l2 = SCROLL_WIDTH - l;

    mhide();
    writecxy(x - 8, y, ' ');
    writexy(x, y, texte);
    if(l2 > 0)
        writepad(x + (l << 3) , y, l2);
}

void scroll_window(int NROW)
{
    int xr, yb;
    int x, y;

    x  =  (WL << 3) + 6;    /* extrieur de 2 */
    y  =  (WU << 4) + 2;
    xr =  (WR << 3) + 8;
    yb =  (WB << 4) + 15;

    SCROLL_WIDTH = WR - WL - 4;
    SCROLL_START = 0;

    LIFTRMARGIN = 0;
    LIFTBMARGIN = 1;
    LIFTTMARGIN = 4;
    B_LIFT = 8;
    BACKCOL = SCROLLBACK;

    mhide();
    bar18(x , y, xr, yb, SCROLLBACK);

    putlift(NROW > 2);
    rectangle18(x ,y, xr, yb, 0);
}


void scroll_list(char *scrolltexte, int first, int last)
{
    int i;

    BACKCOL = SCROLLBACK;
    PENCOL = SCROLLPEN;

    mhide();
    for(i = first; i <= last; i ++)
        scrollbar( i, scrolltexte, 0);
}

signed int scrollmenu(char *scrolltexte, int NENTRY, int NROW)
{
    int ch;
    int i;
    int a;
    int num, numold;
    int xr, yb, x, y;
    int last;
    char *adr;

    x  =  (WL << 3) + 6;    /* extrieur de 2 */
    y  =  (WU << 4) + 2;
    xr =  (WR << 3) + 8;
    yb =  (WB << 4) + 15;

    scroll_window(NROW);

    num = 0;

minidisp:
    SCROLL_START = min( SCROLL_START, NENTRY - NROW);
    SCROLL_START = max( SCROLL_START,  0);
    last = min( SCROLL_START + NROW - 1, NENTRY - 1);

    scroll_list(scrolltexte, SCROLL_START, last);

miniloop:
    num = min( num, last);
    numold = num;

    scrollbar( num, scrolltexte, 1);
    numberlift(num, NENTRY);
    ch = 0;

    if(MOUSE)
    {
mloop:
        mshow();
        while(!kbhit())
        {
            if(mclick())
            {
                mrelease(1);
                ch = -3;
                if(mx > x)
                    if(my > y)
                        if(my < yb)
                            if(mx < xr)
                            {
                                if(mx > xr - 16)
                                    a = wmouselift(&num, NENTRY);
                                else
                                {
                                    a = 0;
                                    num = SCROLL_START + ((my - (y + 10)) >> 4);
                                    ch = 13;
                                    goto chskip2;
                                }
                                if(a > 256)
                                {
                                    ch = a;
                                    goto chskip2;
                                }
                                if(a != -1)
                                {
                                    if(num < SCROLL_START)
                                    {
                                        SCROLL_START = num;
                                        goto minidisp;
                                    }
                                    if(num > last)
                                    {
                                        SCROLL_START = min( NENTRY - (last - SCROLL_START), SCROLL_START + ( num - last));
                                        goto minidisp;
                                    }
                                    if(num == numold)
                                        goto mloop;
                                    scrollbar(numold, scrolltexte, 0);
                                    goto miniloop;
                                }
                            }  /* en fentre */
                goto chskip2;
            }   /* click */
        }   /* kbhit */
    }   /* mouse */

    ch = get1000();

chskip2:
    scrollbar( numold, scrolltexte, 0);

chloop:
    switch(ch)
    {
    case 1071:
        SCROLL_START = 0;
        num = 0;
        goto minidisp;
    case 1072:
        if(num > 0)
        {
            num--;
            if(num < SCROLL_START)
            {
                SCROLL_START--;
                goto minidisp;
            }
        }
        break;
    case 1080:
        if(num < (NENTRY - 1))
        {
            num++;
            if(num > last)
            {
                SCROLL_START++;
                goto minidisp;
            }
        }
        break;
    case 1073:
        if(num)
        {
            if(num == SCROLL_START)
                SCROLL_START -= NROW;
            num = max(SCROLL_START, 0);
            goto minidisp;
        }
        break;
    case 1081:
        if(num == last)
            if(num < (NENTRY - 1))
                SCROLL_START = last;
        num = last;
        goto minidisp;
    case DELETE:
        i = num;
        while(i < (NENTRY - 1))
        {
            adr = scrolltexte + i * SCROLL_TXT_WIDTH;
            strcpy(adr, adr + SCROLL_TXT_WIDTH);
            i++;
        }
        adr = scrolltexte + (NENTRY-1) * SCROLL_TXT_WIDTH;
        *adr = '\0';
        goto minidisp;
    case 27:
        ch = -1;
    case -3:
        goto upd;
    case 13:
        scrollbar( num, scrolltexte, 1);
        ch = num;
        goto upd;
    default:
        break;
    }

    goto miniloop;

upd:
    SCROLL_TXT_WIDTH = 80;
    return(ch);
}


void winwritepad(int co, int li, char *txt, int slen)
{
    int l;
    int x, y;

    l = strlen(txt);

    BACKCOL = WBACK;
    PENCOL  = WCOL;
    x = (WL + co) << 3;
    y = (WU + li) << 4;
    writexy( x, y, txt);
    if(slen > l)
        writepad( x + (l << 3) , y, slen - l);
}
