#include <conio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "../gui/head.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/gets18.h"
#include "../gui/souris.h"
#include "../gui/lift.h"
#include "../gui/winmove.h"
#include "../gui/gostop.h"
#include "../gui/alt.h"
#include "../gui/message.h"
#include "../gui/vga.h"
#include "../gui/drive.h"

#include "listgui.h"
#include "../gui/keys.h"

int X_BOX = 20;
int Y_BOX = 12;
int W_BOX = 20;
int H_BOX = 3;

int X_IBOX = 20;
int Y_IBOX = 12;
int W_IBOX = 40;
int H_IBOX = 6;



void hideboxsub();

int answer(int ch)
{
    switch(ch)
    {
    case 'y':
    case 'Y':
    case 'o':
    case 'O':
        ch = 13;
        break;
    case 'n':
    case 'N':
        ch = 'n';
        break;
    case 'l':
    case 'L':
    case 'c':
    case 'C':
    case 'r':
    case 'R':
        ch = 27;
    default :
        break;
    }
    return(ch);
}

/* Trois rponses seulement */

int answer3(int i)
{
    if(i == 13)
        goto ok;
    if(i == 'n')
        goto ok;
    i = 27;
ok:
    return(i);
}

char BOXPLUS = 0;
char BOXYES = 0;
char BOXBACK = 7;
char BOXPEN = 0;
char BOX_OPENED;


void message_box(char *txt)
{
    int colr, rowb;
    register int nc;

    if(BOX_OPENED)
        hideboxsub();
    winsave(0);

    txt[76] = 0;
    nc = strlen(txt) + 4;
    if(nc < 40)
        nc = 40;

    X_BOX = 40 - (nc >> 1);
    W_BOX = nc;
    colr  = X_BOX + nc - 1;
    rowb  = Y_BOX + H_BOX - 1;

    DIALOG_BAR = 0;
    DIALOG_BACK = BOXBACK;

    mhide();
    winbacksave(X_BOX, Y_BOX, colr, rowb);
    winboard(X_BOX, Y_BOX, colr, rowb, BOXBACK);
    wintextcol(BOXBACK, BOXPEN);
    wincenter(1, txt);

    H_BOX = 3;
    BOX_OPENED = 1;
}


void showbox(char *fmt, ...)
{
    va_list  argptr;
    char txt[128];

    va_start(argptr, fmt);
    vsprintf((char *) txt, fmt, argptr);
    message_box(txt);
    va_end(argptr);
    return;
}


void hideboxsub()
{
    mhide();
    winbackput();
    winopen(0);
    BOX_OPENED = 0;
}


void hidebox()
{
    BOXYES = 0;
    BOXPLUS = 0;
    BOXBACK = 7;
    if(BOX_OPENED)
        hideboxsub();
}


int box(const char *fmt, ...)
{
    va_list argptr;
    int ch;
    int fnew, oldimage;
    char txtbuf[128];

    va_start(argptr, fmt);
    vsprintf((char *) txtbuf, fmt, argptr);

    fnew = 0;
    oldimage = MOUSIMAGE;

redisp:
    H_BOX = 6 - (BOXPLUS != 0);
    message_box(txtbuf);
    if(BOXPLUS)
    {
        H_BOX = 5;
        longkey(WR - 22, WU + 3, 4);  /* non */
        longkey(WL + 2,  WU + 3, 2);  /* cancel */
        longkey(WR - 11, WU + 3, 3);   /* oui */
    }
    else
    {
        H_BOX = 6;
        if(BOXYES)
            stop_key(WW - 18, 3);
        go_key(WW - 9, 3);
    }

    ALT = 0;

    if(MOUSE)
    {
mloop:
        mshow();
        release();
        while (!kbhit())
        {
            if(mclick())
            {
                if(fnew)
                {
                    ch = ALT_M;
                    goto bxskp;
                }
                if(!wininside())
                {
                    ch  = 27;
                    goto bxskp;
                }

                if(BOXPLUS)
                {
                    if(testlong(4))
                    {
                        ch = 'n';
                        goto bxskp;
                    }
                    if(testlong(3))
                    {
                        ch = 13;
                        goto bxskp;
                    }
                    if(testlong(2))
                    {
                        ch = 27;
                        goto bxskp;
                    }
                }
                else
                {
                    if(BOXYES)
                        if(test_stop())
                        {
                            ch = 27;
                            goto bxskp;
                        }
                    if(test_go())
                    {
                        ch = 13;
                        goto bxskp;
                    }
                }

                goto mloop;
            }

            fnew = testborder(0);
            if(fnew)
                fnew = MOUSE_MOVE;
            newcursor(fnew);
        }
    }

    ch = get1000();

bxskp:
    if(ch == ALT_M)
    {
        move(&X_BOX, &Y_BOX, &W_BOX, &H_BOX, W_BOX, 5, W_BOX, 5);
        hideboxsub();
        goto redisp;
    }

    hidebox();
    va_end( argptr );
    newcursor(oldimage);
    H_BOX = 3;
    return(ch);
}




int boxinput(char *txt, char *var, int size)
{

    int col;
    int colr;
    int lin;
    int linb;

    int c;
    int width;
    int ch;
    char sav_bar;
    char sav_barcol;
    char sav_back;

    sav_bar = DIALOG_BAR;
    sav_barcol = DIALOG_BARCOL;
    sav_back = DIALOG_BACK;

redisp:
    DIALOG_BAR = sav_bar;
    DIALOG_BARCOL = sav_barcol;
    DIALOG_BACK = sav_back;

    width = max(W_IBOX, strlen(txt) + 4);

    col=  X_IBOX;
    colr= X_IBOX + width - 1;
    lin=  Y_IBOX;
    linb= Y_IBOX + H_IBOX-1;


    mhide();
    winbacksave(col, lin, colr, linb);
    winboard(col, lin, colr, linb, 7);

    redo
:
    c = min(width - 7, size);
    wintextcol(7, 0);
clearloop:
    get_frame(2, 4, c + 2, 13, txt);
    winlocate(2, 4);
    ch = getsg(var, c);

parse:
    switch(ch)
    {
    case ALT_M:
        newcursor(MOUSE_MOVE);
        goto movloop;
    case ALT_R:
    case ALT_S:
        newcursor(MOUSE_RIGHT);
        goto movloop;
    case ALT_L:
        newcursor(MOUSE_LEFT);
movloop:
        move(&X_IBOX, &Y_IBOX, &W_IBOX, &H_IBOX, 30, 6, 80, 6);
        winbackput();
        goto redisp;
    case -3:
        if(wininside())
        {
            if(test16(13))
            {
                *var = 0;
                goto clearloop;
            }
            if(test16(16))
            {
                ch = 27;
                break;
            }
            if(test16(17))
            {
                ch = 13;
                goto parse;
            }
            goto redo
            ;
        }
        ch = 27;
        break;
    case 13:
        if(!strlen(var))
            ch = 0;
    default:
        break;
    }

    winbackput();
    CLEAR_BUTTON = 1;
    return(ch);
}

