
#include <dos.h>
#include "../gui/hugertn.h"


#define ulong unsigned long

unsigned long huge2long(char huge *p)
{
    unsigned long seg,dep;

    seg = (unsigned long) FP_SEG(p);
    dep = (unsigned long) FP_OFF(p);
    return( (seg << 4) + dep);
}

char huge *long2huge(unsigned long val)
{
    unsigned int seg;
    unsigned int off;

    seg = (unsigned int) (val >> 4);
    off = (unsigned int) (val) & 0xF;

    return((char huge *) MK_FP(seg, off));
}

/* ajoute un int a un ptr */

char huge *hugepint(char huge *adr,unsigned int val)
{
    ulong e;
    e =  huge2long(adr) + (ulong) val;
    return(long2huge(e));
}

char huge *hugemint(char huge *adr,unsigned int val)
{
    ulong e;
    e =  huge2long(adr) - (ulong) val;
    return(long2huge(e));
}


unsigned int subhuge(char huge *p1,char huge *p2)      /* ptr1 - ptr2 */
{
    ulong ad1, ad2;

    ad1 = huge2long(p1);
    ad2 = huge2long(p2);

    if(ad1 < ad2)
        return((unsigned) (ad2 - ad1));
    else
        return((unsigned) (ad1 - ad2));
}
