#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>

#include "../gui/head.h"
#include "../gui/dirtools.h"



int is_drive(char *path)
{
    int l;
    int c;

    l = strlen(path);

    if(l > 3)
        return(0);
    if(l == 1)
        goto slash;
    if(path[1] != ':')
        return(0);   /* l = 2 ou 3 */
    if(l == 2)
        return(1);

slash:               /* l vaut 1 ou 3 */
    c = path[l-1];
    if((c == '\\') || (c == '\/'))
        return(1);
    return(0);
}

/* Chemin est un simple rpertoire sans fichier */

int dir_only(char *nom)
{
    int l;

    l = strlen(nom);
    if(l)
    {
        l--;
        if((nom[l] == '\\') || (nom[l] == '\/'))
            return(1);
    }
    return(0);
}

/* Directory in path */

int has_dir(char *nom)
{
    int l;

    l = strlen(nom);
    while(l)
    {
        l--;
        if((nom[l] == '\\') || (nom[l] == '\/'))
            return(1);
    }
    return(0);
}

/* REMSLASH
   Return: 1 slash enlev
	   0 inchang, slash absent ou racine
*/

int remslash(char *nom)
{
    int l;

    l = strlen(nom);
    if(l)
    {
        l--;
        if((nom[l] == '\\') || (nom[l] == '\/'))
        {
            if(l == 0)
                goto non;
            if((l == 2) && (nom[1]==':'))
                goto non;
            nom[l] = 0;
            return(1);
        }
    }
non:
    return(0);
}

void copycat(char *nom,char *node,char *ext)
{
    strcpy(nom,node);
    strcat(nom,ext);
}

/* PULLNAME prend le nom de fichier dans un chemin complet */

int pullname(char *path, char *name)
{
    char dummy_drive[3];
    char dummy_dir[67];
    char ext[5];

    fnsplit(path, dummy_drive, dummy_dir, name, ext);

    /* box("(%s) (%s) (%s) (%s) (%s)", path, dummy_drive, dummy_dir, name,ext);*/
    strcat(name, ext);
    return(strlen(name));
}

void minisplit(char *srcnom, char *dstnode, char *dstext)
{
    int l;

    l = strcspn(srcnom,".");
    strncpy(dstnode, srcnom, 8);
    dstnode[l] = 0;
    strcpy(dstext, srcnom + l);
}


/* PUSHNAME ajoute ou remplace le nom, peut ne pas avoir de chemin */

void pushname(char *path, char *name)
{
    int l;
    char drive[80];
    char dir[80];
    char node[80];
    char ext[80];

    l = strlen(path);
    l = max(0, l - 1);
    if(path[l] != '\\')
        strcat(path, "\\");

    fnsplit(path, drive, dir, node, ext);
    minisplit(name, node, ext);
    fnmerge(path, drive, dir, node, ext);
}



void pathcat(char *first,char *second)
{
    int l;

    l = strlen(first) - 1;
    if(first[l]=='\\')
        first[l] = 0;
    if(*second != '\\')
        strcat(first,"\\");
    strcat(first,second);
}


void supermerge(char *path, char *drive, char *dir, char *node, char *ext)
{
    int drivint;

    if(*drive == '\0')
    {
        drivint  = getdisk();
        drive[0] = (char) drivint + 'a';
        drive[1] = ':';
        drive[2] = 0;
    }
    else
        drivint = (int) _toupper(*drive) - 'A';
    if(*dir == '\0')
        getcurdir(drivint + 1, dir);
    strcpy(path, drive);
    pathcat(path, dir);
    pathcat(path, node);
    strcat(path, ext);
}



void CHG_EXTENSION(char *NEWNAME, char *NEWEXT)
{
    int l;

    l = strcspn(NEWNAME,".");
    strcpy(NEWNAME + l, NEWEXT);
};


void popname(char *path)
{
    char drive[3];
    char dir[67];
    char node[9];
    char ext[5];

    fnsplit(path, drive, dir, node, ext);
    fnmerge(path, drive, dir, "","");

}


int cdd(char *path)
{
    int l;

    l = strlen(path);
    if(l == 0)
        return(0);
    if(l > 1)
    {
        if(path[1] == ':')
        {
            setdisk((int) toupper(path[0]) - 'A');
            if(path[2] == 0)
                return(0);
        }
        remslash(path);
    }

    return(chdir(path));
}

