
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <time.h>
#include <dos.h>
#include <process.h>
#include <dir.h>
#include <alloc.h>
#include <stdarg.h>

#include "../gui/head.h"
#include "../gui/souris.h"
#include "../gui/drive.h"
#include "../gui/texte.h"
#include "../gui/design.h"
#include "../gui/popwin.h"
#include "../gui/message.h"

#include "listgui.h"
#include "../gui/vga.h"
#include "listico.h"
#include "listini.h"
#include "listkeys.h"


int KEYHAUT;
int KEYBAS;
int KEYBOT;

int TOPBAR;   /* la barre grise */

#define MAXBIG 32

char bigstate[MAXBIG];

char *bigico[MAXBIG]=
    {
        printico,
        pileico,
        pageico,
        pageico,
        pileico,
        arboico,
        searchico,
        copyico,            /* left / copy */
        editico,
        0,            /* zip */
        unarcico,     /* right / unarc */
        0,            /* 11 dos */
        0,            /* 12 bbs */
        0,            /* 13 sort  */
        doublico,     /* 14 */
        0,            /* bye */


        printico,
        pileico,
        pageico,
        0,            /* left / copy */
        0,
        0,
        0,            /* right / unarc */
        pageico,
        pileico,
        searchico,
        againico,            /* again */
        0,            /* sort  */
        0,            /* warp / tag */
        dirico,
        helpico,
        0,            /* bye */

    };


char bigtexte[MAXBIG][5]=
    {
        0  ,' ',' ',' ',0,
        24,' ',' ',' ', 0,  /* 2 home */
        ' ',27,' ', ' ',0,
        /*
        ' ',24,' ',' ',0,
        ' ',25,' ',' ',0,
        */
        ' ',26,' ',' ',0,
        ' ', ' ', 25, ' ',0,  /* 5 fin */
        0  ,0, 0, 0,0,
        0  ,0, 0, 0,0,
        0  ,0, 0, 0,0,
        0  ,0, 0, 0,0,
        "Z_ip",
        0, ' ',' ',' ',0,
        "Do_s",
        "B_BS",
        "Srt_",
        0 ,' ',' ',' ',0,
        27, ' ', 26, ' ',0,

        0  ,' ',' ',' ',0,
        24,' ', ' ',' ', 0,  /* 2 home */
        ' ',27 ,' ',' ',0,
        ' ',27 ,' ',' ',0,
        ' ',24 ,' ',' ',0,
        ' ',25 ,' ',' ',0,
        ' ',26 ,' ',' ',0,
        ' ',26 ,' ',' ',0,
        ' ', ' ', 25, ' ',0,  /* 5 fin */
        0  ,' ',' ',' ',0,
        0  ,' ',' ',' ',0,
        "H_yp",
        " w  ",
        0  ,' ',' ',' ',0,
        0 ,' ',' ',' ',0,
        "C:> ",

    } ;


char *maintext[MAXHELP]=
    {
        "Print the file",
        "Go to start of directory",
        "Display previous page",
        "Display next page",
        "Go to end of directory",
        "Disk tree",
        "Locate a file",
        "Copy the file or tagged list",
        "Edit the file",
        "Make the tagged list an archive",
        "Unarchive the file",
        "Send a MS-DOS command",
        "Get BBS description or generic",
        "Sort directory on/off",
        "Double directory or not",
        "Exchange directories",

        "Print the text",
        "Go to top of text",
        "Display previous page",
        "Shift left the text",
        "Previous line",
        "Next line",
        "Shift right the text",
        "Display next page",
        "Go to end of text",
        "Search for a string",
        "Search again",
        "Hypertext or summary",
        "Wrap-around on/off",
        "Display the directory",
        "Display help or no",
        "Exit CD List",

    };



void bigkey(int no)
{
    int depl;
    int x, xl, xr;
    char *ico;
    char *BIGTXT;
    char colback;

    if(no < 16)
        x = no * 5;
    else
        x = (no - 16) * 5;

    xl = (x << 3);
    xr = xl + 39;

    ico = bigico[no];
    if(bigstate[no])
    {
        colback = 8;
        depl = 1;
    }
    else
    {
        colback = KEYBACK;
        depl = PRESS;
    }

    if(depl)
        COLOR16 = 0;
    else
        COLOR16 = KEYBOR;

    BIGTXT = (char *) bigtexte[no];

    mhide();
    fastbar(x, KEYHAUT, x + 4, KEYBAS, colback);

    hline18(xl, KEYHAUT, xr);
    vline18(xl, KEYHAUT, KEYBAS );

    COLOR16 = 0;
    hline18(xl, KEYBAS, xr - 1);

    COLOR16 = 0;
    vline18(xr, KEYHAUT, KEYBAS);

    if(ico)
        icon9(xl + 4 + depl, KEYBOT + 5 - depl, ico);
    if(*BIGTXT)
    {
        PENCOL = 0;
        writeonxy(xl + 7 + depl, KEYHAUT + 9 + depl, BIGTXT);
        PENCOL = KEYTEXTCOL;
        writeonxy(xl + 6 + depl, KEYHAUT + 8 + depl, BIGTXT);
    }
    PRESS = 0;
}


int pressbig(int a)
{
    PRESS = 1;
    bigkey(a);
    if(!bigstate[a])
    {
        delay2(420);
        bigkey(a);
    }
}

int setbig(int a, char flag)
{
    bigstate[a] = flag;
    pressbig(a);
}


void gray_bar()
{
    fastbar(0, TOPBAR, 79, TOPBAR + 21, 7);
    COLOR16 = 8;
    hline18(LEFTBAR, TOPBAR + 1, RIGHTBAR);
    vline18(LEFTBAR, TOPBAR + 1, TOPBAR + 19);
    COLOR16 = 15;
    vline18(RIGHTBAR, TOPBAR + 1, TOPBAR + 19);
    hline18(LEFTBAR + 1, TOPBAR + 19, RIGHTBAR);
}

int test_bar()
{
    if(mx > LEFTBAR)
        if(mx < RIGHTBAR)
            if(my > TOPBAR)
                if(my < (TOPBAR + 19))
                    return(1);

    return(0);
}


void writebar(char f, int c, char *fmt, ... )
{
    va_list  argptr;
    char STRBUF[256];

    va_start( argptr, fmt );

    BACKCOL = 7;
    c = c << 3;
    vsprintf((char *) STRBUF, fmt, argptr );
    PENCOL = 0;
    writexy(c , TOPBAR + 3 , STRBUF);
    if(f)
    {
        PENCOL = 15;
        writeonxy2(c - 1 , TOPBAR + 2 , STRBUF);
    }

    va_end( argptr );
}

int input_bar(char *search)
{
    char var[81];

    strcpy((char *) var, search);

    if(boxinput("New path:", var, 63) == 13)
    {
        strcpy(search, (char *) var);
        return(1);
    }
    return(0);
}
