
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <string.h>
#include <fcntl.h>
#include <dir.h>

#include "../gui/head.h"
#include "../gui/hugertn.h"
#include "../gui/winzip.h"
#include "../gui/dosman.h"
#include "../gui/dirtools.h"
#include "../gui/zip.h"
#include "../gui/vga.h"

#include "listgui.h"
#include "listini.h"
#include "listdir.h"
#include "listit.h"

char typetext[EXTMAX][45];
char DESCPATH[81];
char PATHEXT[81];
char EDITOR[81];

#define DESCMAX 2
int DESCVALUES[DESCMAX];
char DISK_OPTIONS[16]= "/V";
char REMOVABLEID[80] = "";

char MESS_DEL = 1;
char DOUBLE;
char BBS;
char SORT;
char ICOBACK;
char TEXT_BORDER;
char DIR_BORDER;
char ZIP_BORDER;
char MENU_BACK = 4;
char HELPBACK = 2;
char KEYBACK = 7;
char KEYBOR = 15;
char WINDOWBACK = 7;
char WINDOWHEAD = 2;
char WINDOWPEN = 0;
char KEYTEXTCOL = 15;
char WRAP;
char FONT;

char CASEFLAG = 1;
char DOCFLAG = 1;

int X_SBOX = 20;
int Y_SBOX = 12;
int W_SBOX = 41;
int H_SBOX = 5;

char DIRBACK;
char DIRPEN;


char huge *DESCadr[DIRSIZE];
char huge *DESCptr;
char huge *DESCbuf;

char REPBUF[DIRSIZE][13];
long REPSIZE[DIRSIZE];
char DTAG[DIRSIZE];
char lockit[DIRSIZE];

extern int FILEMAX;


char *skipblank(char *txt)
{
    while(*txt && (*txt==' '))
        txt++;
    return(txt);
}


char *skipequal(char *txt)
{
    while(*txt && ((*txt== ' ') || (*txt == '=')))
        txt++;
    return(txt);
}


int getext()
{
    FILE *fp;
    char txt[81];
    int extnum, l;

    if((fp = fopen(PATHEXT,"rb")) == 0)
        goto exit;

next:
    if(fgets(txt, 47, fp) )
    {
        if( strncmp(txt, "[Extensions]", 12))
            goto next;
    }
    else
        goto bye;

    strcpy(typetext[0], "nil");
    extnum = 1;

suite:
    if(fgets(txt, 47, fp))
    {
        l = min(44, strlen(txt) - 2);
        l = max(0, l);
        txt[l] = 0;
        strcpy(typetext[extnum++], txt);
        if(extnum < EXTMAX)
            goto suite;
    }

bye:
    fclose(fp);
exit:
    return(extnum);
}


/* GETSTRING
   Passe cot gauche et gal
*/

int STR_START;

int getstring(char *txt)
{
    int i, f;

    i = STR_START;
    while( txt[i] == ' ' || txt[i]== '=')
        i++;
    f = i;
    STR_START = i;
    while( txt[f] && txt[f] != ' ' && txt[f] != '=')
        f++;
    return( f - i );
}


int getvalues(char *line, int buf[DESCMAX])
{
    char var[6];
    int i, j, num;

    i = 0;
    num = 0;
    if(*line)
        while(num < DESCMAX)
        {
            j = 0;
            while(line[i] && line[i] == ' ')
                i++;
            while(line[i] && line[i] != ' ' && (j < 5))
            {
                var[j++]= line[i++];
            }
            var[j]= 0;
            if( j == 0)
                goto bye;
            buf[num++] = atoi(var);
        }
bye:
    return(num);
}



int getdesc()
{
    FILE *fp;
    char txt[161];
    char filedesc[81];
    int  ret;
    int  l;

    if((fp = fopen(PATHEXT,"rb")) == 0)
        return(0);

next:
    if(fgets(txt, 47, fp) )
    {
        if(strncmp(txt, "[Descriptions]", 14))
            goto next;
    }
    else
        goto bye;

suite:
    STR_START = 0;
    if(fgets(txt, 81, fp))
    {
        if(*txt == '\/')
            goto suite;

        txt[strlen(txt) - 2] = 0;
        l = getstring(txt);
        if(l)
        {
            if(!strncmp(txt + STR_START, "Descfile", 8))
            {
                STR_START += 8;
                l = getstring(txt);
                if(l)
                {
                    strncpy(filedesc, txt + STR_START, l);
                    filedesc[l] = 0;

                    getvalues(txt + STR_START + l, DESCVALUES);
                    getcwd(DESCPATH, 81);
                    pathcat(DESCPATH, filedesc);
                    if(access(DESCPATH, 0) == 0 )
                    {
                        ret = 1;
                        goto bye;
                    }
                    goto suite;
                }
            }
        }
        ret = 0;
    }

bye:
    fclose(fp);
    return(ret);
}


/*
unsigned long huge2long(char huge *p)
{
 unsigned long seg,dep;
 
 seg = (unsigned long) FP_SEG(p);
 dep = (unsigned long) FP_OFF(p);
 return( (seg << 4) + dep);
}
 
char huge *long2huge(unsigned long val)
{
  unsigned int seg;
  unsigned int off;
 
  seg = (unsigned int) (val >> 4);
  off = (unsigned int) (val) & 0xF;
 
  return((char huge *) MK_FP(seg, off));
}
 
/* ajoute un int a un ptr */

char huge *hugepint(char huge *adr,unsigned int val)
{
    unsigned long e;
    e =  huge2long(adr) + (unsigned long) val;
    return(long2huge(e));
}
*/

int getBBS(unsigned int debut)
{
    FILE *fp;
    char txt[1025];
    int i, l;
    int dpos;
    int ret = 0;
    int start;

    if((fp = fopen(DESCPATH,"rb")) == 0)
        goto sortie;

    ret = 2;
    i = DESCVALUES[0];
    while(i)
    {
        if(!fgets(txt, 82, fp))
            goto dexit;
        i--;
    }

    dpos = DESCVALUES[1];
    start = debut;

nextdesc:
    if(fgets(txt, 82, fp))
    {
        l = strlen(txt);
        if(l <= dpos)
            goto nextdesc;
        l = min(l, 82);
        txt[l - 2] = 0;
        debut = start++;

nextfile:
        if(debut < FILEMAX)
        {
            l = strlen(REPBUF[debut]);
            if(BBS_cmp(REPBUF[debut], txt, l))
            {
                debut++;
                goto nextfile;
            }

            DESCptr = hugepint(DESCbuf, debut * 46);
            strncpy((char *) DESCptr, txt + dpos, 45);
            DESCptr[45] = 0;
        }
        goto nextdesc;
    }

    ret = debut;

dexit:
    fclose(fp);
sortie:
    return(ret);
}




int getanswer(char *txt, char *option)
{
    int l;

    l = strlen(option);

    if(!strnicmp(txt, option, l))
        if(!strnicmp( skipequal(txt+l), "no", 2))
            return(0);
    return(1);
}


int get_char_val(char *txt, char *option, char *var)
{
    int l;

    l = strlen(option);

    if(!strncmp(txt, option, l))
    {
        txt += l;
        txt = skipequal(txt);
        *var = (char) atoi(txt);
        return(1);
    }
    return(0);
}

int get_integer(char *txt, char *option, int *var)
{
    int l;

    l = strlen(option);
    if(!strncmp(txt, option, l))
    {
        txt += l;
        txt = skipequal(txt);
        *var = atoi(txt);
        return(1);
    }
    return(0);
}


int get_string(char *txt, char *option, char *var)
{
    int l;

    l = strlen(option);

    if(!strncmp(txt, option, l))
    {
        txt += l;
        txt = skipequal(txt);
        l = strlen(txt);
        if(l)
        {
            if(txt[l-1] == 10)
                l--;
            if(txt[l-1] == 13)
                l--;
            txt[l] = 0;
            if(l)
            {
                strcpy(var, txt);
                return(1);
            }
        }
    }
    return(0);
}

void keep_string(char *txt, char *var)
{
    int l;

    while(*txt == ' ')
        txt++;
    l = strlen(txt);
    if(l)
    {
        if(txt[l-1] == 10)
            l--;
        if(txt[l-1] == 13)
            l--;
        txt[l] = 0;
    }
    strcpy(var, txt);
}

int get_command(char *txt, int linectr)
{
    int i;
    char *adr;

    if(*txt++ != '>')
        goto bye;
    adr = txt;

    i = 0;
    while((*adr++ != '=') && (i < 40))
        i++;
    strncpy((char *) WIN_TITLES[linectr], txt, i);
    WIN_TITLES[linectr][i] = 0;

    while(*adr == ' ')
        adr++ ;

    if(*adr == 'C' || *adr == 'c')
    {
        WIN_CLEAR_DST[linectr] = 1;
        adr++;
        if(*adr == 'C' || *adr == 'c')
        {
            WIN_CLEAR_SRC[linectr] = 1;
            adr++;
        }
    }

    keep_string(adr, (char *) WIN_COMMANDS[linectr]);
    return(1);

bye:
    return(0);
}


void getSETUP()
{
    FILE *fp;
    char txt[81];
    int linectr;

    WRAP = 1;
    FONT = 1;
    DIRBACK = 7;
    DIRPEN = 0;
    BBS = 1;
    DOUBLE = 1;
    SORT = 1;

    if((fp = fopen(PATHEXT, "rb")) == 0)
        goto exit;

next:
    if(fgets(txt, 80, fp) )
    {
        if( strncmp(txt, "[Setup]", 7))
            goto next;
    }
    else
        goto bye;


    linectr = 0;

nextcolors:
    if(fgets(txt, 80, fp))
    {
        if((*txt == 13) || (*txt == '\/'))
            goto nextcolors;
        switch(linectr)
        {
        case 0:
            get_char_val(txt, "IconColor", &KEYBACK);
            break;
        case 1:
            get_char_val(txt, "TextBorder", &TEXT_BORDER);
            break;
        case 2:
            get_char_val(txt, "DirBorder", &DIR_BORDER);
            break;
        case 3:
            get_char_val(txt, "ArchiveBorder", &ZIP_BORDER);
            break;
        case 4:
            get_char_val(txt, "DirBack", &DIRBACK);
            break;
        case 5:
            get_char_val(txt, "DirPen", &DIRPEN);
            break;
        case 6:
            if(!getanswer(txt, "DirSort"))
                SORT = 0;
            break;
        case 7:
            get_char_val(txt, "ArchiveBack", &ZIPBACK);
            break;
        case 8:
            get_char_val(txt, "ArchivePen", &ZIPTEXT);
            break;
        case 9:
            if( !getanswer(txt, "Wrap-around"))
                WRAP = 0;
            break;
        case 10:
            if( !getanswer(txt, "Font"))
                FONT = 0;
            break;
        case 11:
            if( !getanswer(txt, "BBS"))
                BBS  = 0;
            break;
        case 12:
            if(!getanswer(txt, "DoubleDir"))
                DOUBLE = 0;
            break;
        case 13:
            get_string(txt, "TempPath", CDTEMP);
            break;
        case 14:
            get_string(txt, "Editor", EDITOR);
            break;
        case 15:
            get_string(txt, "Archiver", ARCHIVER);
            break;
        case 16:
            get_string(txt, "Unarchiver", UNARCHIVER);
            break;
        case 17:
            get_string(txt, "RemovableUnit", REMOVABLEID);
            break;
        default:
            break;
        }

        if(++linectr < 23)
            goto nextcolors;
    }

now_com:
    if(fgets(txt, 80, fp) )
    {
        if(strncmp(txt, "[Commands]", 7))
            goto now_com;
    }
    else
        goto bye;

    linectr = 0;
    WIN_COM_MAX = 0;

com_loop:
    if(fgets(txt, 80, fp))
    {
        if(!get_command(txt, linectr))
            goto bye;
        WIN_COM_MAX = linectr + 1;
        if(++linectr < 16)
            goto com_loop;
    }

bye:
    fclose(fp);
exit:
    KEYBOR = min(15, KEYBACK + 8);
    KEYTEXTCOL = KEYBOR;
    if(DIRBACK == DIRPEN)
        DIRPEN = 15 - DIRBACK & 15;
    if(DIRBACK == 7)
        HELPBACK = 2;
    else
        HELPBACK = 7;
    get_unarchiver(); /* nom sans options */
    return;
}
