var uri="/websocket.html"; // the name of your HTML interface

var j5 = require("johnny-five");

var myLed;

j5.Board().on("ready", function() {
  myLed = new j5.Led.RGB([ 9, 10, 11 ]);
  
  myLed.color("#ffffff");

  this.wait(2000, function() {
    myLed.color("#00ff00");
    myLed.strobe(1000);
  });

});


var fs = require('fs'),
    http = require('http'),
    socket = require("socket.io");

var page = fs.readFileSync(__dirname + uri);

function handler(request, response)
{
  response.write(page); 
  response.end(); 
}

var app = http.createServer(function(r, s){ handler(r,s); });
app.listen(8100);

var listener = socket.listen(app, { log: false });

console.log("Waiting...")

function start(socket) 
{
  socket.emit('notification', 'Server online via websocket...');
    
  socket.on('data', function (data) {
    var message;
    var color;
    switch(data) 
    {
		case 'happy':
				message="robot happy";
				color="#003399"; 
				break;
		case 'angry':
				message="robot angry";
				color="#990000"; 
				break;
		default:
				message="no emotion";
				color="#ffffff"; 
	}
    listener.sockets.emit('notification', "Data received, " +message);
    myLed.color(color);
    myLed.strobe(1000);
    
  });    
}

listener.sockets.on('connection', function (socket) { start(socket);} );

