<?php
// Script Check 1.2
// (c) 2007-2012 Scriptol.com
// Free under the GNU GPL 3 license.
// Requires the PHP interpreter.
// and Scriptol to PHP compiler version 7.0 to compile the source.
//
// Verify that all the scripts or webpages with scripts inside
// are exactly the same as the original files in the source directory.
// And so detect malicious code to be stored on the website.
//
include_once("path.php");
include_once("dirlist.php");
include_once("ftp.php");
$CHECKMODE=false;
$VERBOSE=false;
$QUIET=false;
$DEBUG=false;
$server="";
$source="";
$user="";
$pass="";
$params=array();
$backdir="";
$connection=0;
$counter=0;
$problem=0;
$obtrusive=0;
$validExtensions=array(".php",".php3",".php4",".php5",".asp",".aspx");
$log=0;
function display($t)
{
   global $QUIET;
   if(!$QUIET)
   {
      echo $t, "\n";
   }
   global $log;
   fwrite($log,$t."\n");
   return;
}

function syncConnect()
{
   global $connection;
   global $server;
   $connection=ftp_connect($server);
   if($connection===0)
   {
      die("Not connected");
   }
   global $user;
   global $pass;
   if(ftp_login($connection,$user,$pass)===true)
   {
      echo "Connected on $server as $user", "\n";
      if(ftp_pasv($connection,true)===true)
      {
         echo "Passive mode turned on", "\n";
      }
      else
      {
         echo "Enable to set passive mode", "\n";
      }
      return true;
   }
   else
   {
      echo "Enable to connect as $user on $server", "\n";
   }
   return false;
}

function syncDisconnect()
{
   global $connection;
   ftp_close($connection);
   return;
}

function remoteIdentical($lfile,$rfile)
{
   global $DEBUG;
   if($DEBUG===true)
   {
      display("Comparing $lfile and remote $rfile");
   }
   $temporary="temporary-file.000.tmp";
   global $connection;
   if(ftp_get($connection,$temporary,$rfile,FTP_BINARY)!=true)
   {
      echo "Enable to load ", " ", $rfile, "\n";
      return false;
   }
   if(filesize($temporary)===0)
   {
      return true;
   }
   $x=array();
   $y=array();
   $x=file($lfile);
   if(count($x)===0)
   {
      echo "Empty file ", " ", $lfile, "\n";
   }
   $y=file($temporary);
   if(count($x)===0)
   {
      echo "Empty file ", " ", $rfile, "\n";
   }
   if((count($x)===0)&&(count($y)===0))
   {
      return true;
   }
   $a="";
   $b="";
   $x1=array();
   reset($x);
   do
   {
      $a=trim(current($x));
      if($a!=false)
      {
         array_push($x1,$a);
      }
   }
   while(!(next($x)===false));
   $y1=array();
   reset($y);
   do
   {
      $a=trim(current($y));
      if($a!=false)
      {
         array_push($y1,$a);
      }
   }
   while(!(next($y)===false));
   if(count($x1)!=count($y1))
   {
      return false;
   }
   reset($y1);
   reset($x1);
   do
   {
      if(current($x1)!=current($y1))
      {
         echo "line ", " ", current($x1), " ", " ", " ", current($y), "\n";
         return false;
      }
   }
   while(!(next($x1)===false)&&!(next($y1)===false));
   return true;
}

function check($locdir,$hostdir)
{
   $dlist=new DirList();
   $content=$dlist->getList($locdir);
   $distant=array();
   $src="";
   $bck="";
   $rmt="";
   $returned=0;
   $pname="";
   $fname="";
   if(empty($content))
   {
      return;
   }
   reset($content);
   do
   {
      $name= current($content);
      $src=Path::merge($locdir,$name);
      if($name===".")
      {
         continue;
      }
      if($name==="..")
      {
         continue;
      }
      if(filetype($src)==="file")
      {
         $ext=Path::getExtension($src);
         global $validExtensions;
         if(!in_array($ext,$validExtensions))
         {
            continue;
         }
         $result=("Processing $src");
         $rmt=Path::merge($hostdir,$name);

         if($name{0}===".")
         {
            $result.=" skipped";
            display($result);
            continue;
         }
         $returned=remoteIdentical($src,$rmt);
         if($returned===false)
         {
            $result.=" and $rmt *DIFFER*";
            global $problem;
            $problem+=1;
            display($result);
            continue;
         }
         global $counter;
         $counter+=1;
         $result.=" OK";
         global $VERBOSE;
         if($VERBOSE)
         {
            display($result);
         }
      }
   }
   while(!(next($content) === false));

   reset($content);
   do
   {
      $name= current($content);
      $src=Path::merge($locdir,$name);
      if(filetype($src)==="dir")
      {
         check($src,Path::merge($hostdir,$name));
      }
   }
   while(!(next($content) === false));

   global $connection;
   $distant=@ftp_nlist($connection,$hostdir);
   if($distant ==false)
   {
      die("Enable to connect");
   }
   global $VERBOSE;
   if($VERBOSE)
   {
      echo "Dir $locdir sizes =", " ", count($content), " ", "$hostdir =", " ", count($distant), "\n";
   }
   reset($distant);
   do
   {
      $t= current($distant);
      if($t ==false)
      {
         continue;
      }
      $_I4=Path::splitFile($t);
      $pname=reset($_I4);
      $fname=next($_I4);
      if($fname===".")
      {
         continue;
      }
      if($fname==="..")
      {
         continue;
      }
      if(in_array($fname,$content))
      {
         continue;
      }
      if($fname ==false)
      {
         $fname=$pname;
      }
      global $obtrusive;
      $obtrusive+=1;
      display("UNKNOWN - $t not in source");
   }
   while(!(next($distant) === false));

   return;
}

function usage()
{
   echo "\n";
   echo "Script Check - (c) 2007-2012 Scriptol.com", "\n";
   echo "-----------------------------------------", "\n";
   echo "Syntax:", "\n";
   echo "  solp scheck [options] sourcedir ftpadr", "\n";
   echo "Options:", "\n";
   echo "  -v verbose, display more infos.", "\n";
   echo "  -q quiet, display nothing.", "\n";
   echo "  -ppassword.", "\n";
   echo "  -llogin.", "\n";
   echo "  -ddirectory", "\n";
   echo "Arguments:", "\n";
   echo "  sourcedir: the local directory of original contents.", "\n";
   echo "  ftpadr: remote adr in ftp.domain.tld form (ex: ftp.scriptol.com).", "\n";
   exit(0);
   return;
}

function processCommand($argnum,$arguments)
{
   $daystring="";
   $opt="";
   $remotedir="";
   if($argnum<2)
   {
      usage();
   }
   reset($arguments);
   do
   {
      $param= current($arguments);
      if(strlen($param)>1)
      {
         $opt=substr($param,0,2);
      }
      else
      {
         usage();
      }
      if($opt==="-v")
      {
         global $VERBOSE;
         $VERBOSE=true;
         continue;
      }
      if($opt==="-q")
      {
         global $QUIET;
         $QUIET=true;
         continue;
      }
      if($opt==="-u")
      {
         global $DEBUG;
         $DEBUG=true;
         continue;
      }
      if($opt==="-p")
      {
         global $pass;
         $pass=substr($param,2);
         if($pass ==false)
         {
            die("-p must be followed by the password.");
         }
         continue;
      }
      if($opt==="-l")
      {
         global $user;
         $user=substr($param,2);
         if($user ==false)
         {
            die("-l must be followed by the login.");
         }
         continue;
      }
      if($opt==="-d")
      {
         $remotedir=substr($param,2);
         if($remotedir ==false)
         {
            die("-d requires a sub-directory.");
         }
         continue;
      }
      if($opt==="-f")
      {
         global $server;
         $server=substr($param,2);
         if($server ==false)
         {
            die("-f requires a sub-directory.");
         }
         continue;
      }
      if(substr($param,0,4)==="ftp.")
      {
         global $server;
         $server=$param;
         continue;
      }
      if($param{0}==="-")
      {
         echo "Unknown command $param", "\n";
         usage();
      }
      global $source;
      if($source ==false)
      {
         $source=$param;
         continue;
      }
      echo "Unknown command $param", "\n";
      usage();
   }
   while(!(next($arguments) === false));

   global $server;
   if($server ==false)
   {
            echo "FTP location: ";
      $fp=fopen("php://stdin","r");
      $server=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($server ==false)
   {
      exit(0);
   }
   global $source;
   if($source ==false)
   {
            echo "Original directory: ";
      $fp=fopen("php://stdin","r");
      $source=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($source ==false)
   {
      exit(0);
   }
   global $user;
   if($user ==false)
   {
            echo "Login: ";
      $fp=fopen("php://stdin","r");
      $user=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($user ==false)
   {
      exit(0);
   }
   global $pass;
   if($pass ==false)
   {
            echo "Password: ";
      $fp=fopen("php://stdin","r");
      $pass=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($pass ==false)
   {
      exit(0);
   }
   global $params;
   $params["server"]=$server;
   $params["user"]=$user;
   $params["pass"]=$pass;
   $params["source"]=$source;
   $params["remdir"]=$remotedir;

   return;
}

function main($argc,$argv)
{
   $x=array_slice($argv,1);
   processCommand($argc,$x);
   global $problem;
   $problem=0;
   global $counter;
   $counter=0;
   global $obtrusive;
   $obtrusive=0;
   global $server;
   global $params;
   $server=$params["server"];
   global $user;
   $user=$params["user"];
   global $pass;
   $pass=$params["pass"];
   global $source;
   $source=$params["source"];

   global $QUIET;
   if(!$QUIET)
   {
      global $VERBOSE;
      if($VERBOSE===true)
      {
         echo "Verbose mode enabled", "\n";
      }
      global $DEBUG;
      if($DEBUG===true)
      {
         echo "Debug mode enabled", "\n";
      }
      echo "Source directory $source", "\n";
      echo "Remote directory", " ", $params["remdir"], "\n";
   }
   global $log;
   $log=fopen("scheck.log","w");
   syncConnect();
   display("Checking $source on $server");
   check($source,$params["remdir"]);
   syncDisconnect();
   display("$counter file".($counter>1?"s":"")." compared.");
   display("$problem file".($problem>1?"s":"")." differ.");
   display("$obtrusive file".($obtrusive>1?"s":"")." obtrusive.");
   fclose($log);
   return 0;
}

main(intVal($argc),$argv);

?>
