<?php
/**
 * WordPress functions stubs for static analysis
 * 
 * This file contains function and class stubs to help code linting tools.
 * It should not be included in the theme itself, it's only for development.
 */

// WordPress core functions
if (!function_exists('__')) {
    function __($text, $domain = 'default') { return $text; }
}

if (!function_exists('_e')) {
    function _e($text, $domain = 'default') { echo $text; }
}

if (!function_exists('add_action')) {
    function add_action($hook, $callback, $priority = 10, $accepted_args = 1) {}
}

if (!function_exists('add_theme_support')) {
    function add_theme_support($feature) {}
}

if (!function_exists('add_editor_style')) {
    function add_editor_style($file) {}
}

if (!function_exists('register_nav_menus')) {
    function register_nav_menus($menus) {}
}

if (!function_exists('apply_filters')) {
    function apply_filters($tag, $value) { return $value; }
}

if (!function_exists('wp_list_pages')) {
    function wp_list_pages($args) { return ''; }
}

if (!function_exists('wp_list_categories')) {
    function wp_list_categories($args) { return ''; }
}

if (!function_exists('wp_get_archives')) {
    function wp_get_archives($args) { return ''; }
}

if (!function_exists('wp_parse_args')) {
    function wp_parse_args($args, $defaults = []) { return $args; }
}

if (!function_exists('esc_attr')) {
    function esc_attr($text) { return $text; }
}

if (!function_exists('get_template_directory')) {
    function get_template_directory() { return ''; }
}

if (!function_exists('get_template_directory_uri')) {
    function get_template_directory_uri() { return ''; }
}

if (!function_exists('get_stylesheet_uri')) {
    function get_stylesheet_uri() { return ''; }
}

if (!function_exists('load_theme_textdomain')) {
    function load_theme_textdomain($domain, $path) {}
}

// WordPress core classes
if (!class_exists('WP_Widget')) {
    class WP_Widget {
        public function __construct($id_base, $name, $widget_options = [], $control_options = []) {}
        public function get_field_id($field_name) { return ''; }
        public function get_field_name($field_name) { return ''; }
    }
} 