# Resolving WordPress Linter Errors

This document provides instructions on how to fix the linter errors related to WordPress functions and classes in this theme.

## Option 1: Using PHPStan Configuration

If you're using PHPStan as your linter, you can use the included `phpstan.neon` configuration file. This file tells PHPStan to ignore errors related to WordPress functions and classes.

To use it:

1. Make sure you have PHPStan installed
2. Run PHPStan with the configuration file:
   ```
   phpstan analyse --configuration phpstan.neon
   ```

## Option 2: Using WordPress Stubs

We've included a file called `wp-stubs.php` that contains stub declarations for WordPress functions and classes that are commonly used in themes. These stub declarations help your linter understand that these functions and classes exist, even though they're not directly defined in your theme code.

### Using with VSCode and Intelephense

1. In your VSCode settings.json, add:
   ```json
   "intelephense.stubs": [
     "wordpress",
     "path/to/your/theme/wp-stubs.php"
   ]
   ```

### Using with other IDEs or linters

Most PHP linters allow you to include stub files or configure include paths. Consult your linter's documentation for how to include the `wp-stubs.php` file as a reference.

## Option 3: Installing WordPress Core Stubs Package

For a more comprehensive solution, you can install the WordPress stubs package:

```
composer require --dev php-stubs/wordpress-stubs
```

Then configure your linter to use these stubs.

## Reminder

These linter errors don't affect the actual functioning of your theme in WordPress. They only appear because the linter doesn't know about WordPress's globally available functions and classes. The actual WordPress environment will have all these functions and classes available at runtime. 