MODULE_NAME='Nad_T773_UI' (DEV vdvNAD_T773, DEV dvTP, INTEGER nCHAN_BTN[])
(*{{PS_SOURCE_INFO(PROGRAM STATS)                          *)
(***********************************************************)
(*  FILE CREATED ON: 11/08/2004 AT: 10:00:00               *)
(***********************************************************)
(*  FILE_LAST_MODIFIED_ON:11/22/2004 AT: 18:00:00         *)
(***********************************************************)
(*  ORPHAN_FILE_PLATFORM: 1                                *)
(***********************************************************)
(*!!FILE REVISION: Rev 0                                   *)
(*  REVISION DATE: 11/22/2004			                   *)
(*                                                         *)
(*  COMMENTS:                                              *)
(*                                                         *)
(***********************************************************)
(*}}PS_SOURCE_INFO                                         *)
(***********************************************************)

(***********************************************************)
(* System Type : Netlinx                                   *)
(***********************************************************)
(* REV HISTORY:                                            *)
(***********************************************************)

(***********************************************************)
(*          DEVICE NUMBER DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_DEVICE
(***********************************************************)
(*               CONSTANT DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_CONSTANT
(***********************************************************)
(*              DATA TYPE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_TYPE
(***********************************************************)
(*               VARIABLE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_VARIABLE

VOLATILE CHAR sVERSION[5] = ''   // STORES NETLINX COMM MODULE VERSION NUMBER
VOLATILE INTEGER nDEBUG = 0      // TRACKS THE ON/OFF STATE OF DEBUG MSGS SENT TO THE TELNET SESSION
VOLATILE CHAR cCOMMAND[10][10]
VOLATILE INTEGER nBTN
VOLATILE INTEGER nMUTE
VOLATILE INTEGER nZONE_MUTE
VOLATILE INTEGER nPOWER
VOLATILE INTEGER nZONE_POWER
VOLATILE INTEGER nAUDIOINPUT
VOLATILE INTEGER nZONE_AUDIOINPUT
VOLATILE INTEGER nVIDEOINPUT
VOLATILE INTEGER nZONE_VIDEOINPUT
VOLATILE INTEGER nMODE
VOLATILE INTEGER nTAPEMONITOR
VOLATILE INTEGER nBAND
VOLATILE INTEGER nSPEAKER_A
VOLATILE INTEGER nSPEAKER_B
VOLATILE INTEGER nTONE
VOLATILE INTEGER nFMMUTE
VOLATILE INTEGER nAMPRESET
VOLATILE INTEGER nFMPRESET
VOLATILE SINTEGER sVOLUME
VOLATILE SINTEGER sZONE_VOLUME

(***********************************************************)
(*               LATCHING DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_LATCHING
(***********************************************************)
(*       MUTUALLY EXCLUSIVE DEFINITIONS GO BELOW           *)
(***********************************************************)
DEFINE_MUTUALLY_EXCLUSIVE
(***********************************************************)
(*        SUBROUTINE/FUNCTION DEFINITIONS GO BELOW         *)
(***********************************************************)
DEFINE_FUNCTION INTEGER fnPARSE(CHAR cDELIMITER[2], CHAR cSTRING[500], CHAR cNEW_STRING[11][50])
{
	STACK_VAR INTEGER nCOUNTER
	nCOUNTER=0
	WHILE(nCOUNTER<=10)
	{
		IF(FIND_STRING(cSTRING,"cDELIMITER",1))  
		{
			cNEW_STRING[nCOUNTER+1]=REMOVE_STRING(cSTRING,"cDELIMITER",1)
			SET_LENGTH_STRING(cNEW_STRING[nCOUNTER+1],LENGTH_STRING(cNEW_STRING[nCOUNTER+1])-LENGTH_STRING(cDELIMITER))
			nCOUNTER++
		}
		ELSE
		{
			cNEW_STRING[nCOUNTER+1]=cSTRING
			IF(LENGTH_STRING(cSTRING))
				nCOUNTER++
			BREAK  
		}
	}
	RETURN nCOUNTER
}
(***********************************************************)
(*                STARTUP CODE GOES BELOW                  *)
(***********************************************************)
DEFINE_START
(***********************************************************)
(*                THE EVENTS GOES BELOW                    *)
(***********************************************************)
DEFINE_EVENT

DATA_EVENT[vdvNAD_T773]
{
	STRING:
	{
		STACK_VAR CHAR cCMD[35]
		
		IF(nDEBUG) 
		{
  		SEND_STRING 0, "'UI RECEIVED FROM COMM: ',DATA.TEXT" 
	  }
		IF(FIND_STRING(DATA.TEXT, '=', 1)) 
		{
  		cCMD = REMOVE_STRING(DATA.TEXT, '=', 1) 
		}        
		ELSE 
		{ 
		  cCMD = DATA.TEXT 
		}
		SWITCH(cCMD)
		{
			// FIND MATCHING STRING AND PARSE REST OF MESSAGE. PROVIDE FEEDBACK TO THE 
			// TOUCH PANEL.
			CASE 'AUDIOINPUT=':
			{
				fnPARSE(':',DATA.TEXT,cCOMMAND)
				nVIDEOINPUT = 0
				IF(cCOMMAND[2] == '1')//ZONE 1
					nAUDIOINPUT = ATOI(cCOMMAND[1])
				ELSE IF(cCOMMAND[2] == '2')//ZONE 2
					nZONE_AUDIOINPUT = ATOI(cCOMMAND[1])
			}
			CASE 'BAND=':
			{
				IF(DATA.TEXT == 'AM')
					nBAND = 0
				ELSE IF(DATA.TEXT == 'FM')
					nBAND = 1
			}
			CASE 'FMMUTE=':
			{
				IF(DATA.TEXT == '0')
					nFMMUTE = 0
				ELSE IF(DATA.TEXT == '1')
					nFMMUTE = 1			
			}
			CASE 'MODE=':
			{
				nMODE = ATOI(DATA.TEXT)
			}
			CASE 'MUTE=':
			{
				fnPARSE(':',DATA.TEXT,cCOMMAND)
				
				IF(cCOMMAND[2] == '1')//ZONE 1
				{
					IF(cCOMMAND[1] == '0')
						nMUTE = 0
					ELSE IF(cCOMMAND[1] == '1')
						nMUTE = 1
				}
				ELSE IF(cCOMMAND[2] == '2')//ZONE 2
				{
					IF(cCOMMAND[1] == '0')
						nZONE_MUTE = 0
					ELSE IF(cCOMMAND[1] == '1')
						nZONE_MUTE = 1				
				}
			}
			CASE 'POWER=':
			{
				fnPARSE(':',DATA.TEXT,cCOMMAND)
				
				IF(cCOMMAND[2] == '1')//ZONE 1
				{			
					IF(cCOMMAND[1] == '0')
						nPOWER = 0
					ELSE IF(cCOMMAND[1] == '1')
						nPOWER = 1
				}
				ELSE IF(cCOMMAND[2] == '2')//ZONE 2
				{
					IF(cCOMMAND[1] == '0')
						nZONE_POWER = 0
					ELSE IF(cCOMMAND[1] == '1')
						nZONE_POWER = 1
				}				
			}	
			CASE 'PRESET=':
			{
				fnPARSE(':',DATA.TEXT,cCOMMAND)
				
				IF(cCOMMAND[2] == 'FM')
					nFMPRESET = ATOI(cCOMMAND[1])
				ELSE IF(cCOMMAND[2] == 'AM')
					nAMPRESET = ATOI(cCOMMAND[1])
			}			
			CASE 'SPEAKER=':
			{
				fnPARSE(':',DATA.TEXT,cCOMMAND)
				IF(cCOMMAND[1] == 'A')
				{
					IF(cCOMMAND[2] == '0')
						nSPEAKER_A = 0
					ELSE IF(cCOMMAND[2] == '1')
						nSPEAKER_A = 1
				}
				ELSE IF(cCOMMAND[1] == 'B')
				{
					IF(cCOMMAND[2] == '0')
						nSPEAKER_B = 0
					ELSE IF(cCOMMAND[2] == '1')
						nSPEAKER_B = 1				
				}
			}
			CASE 'DEBUG=': 
			{
  			nDEBUG = ATOI(DATA.TEXT) 
			}
			CASE 'ERRORM=': 
			{
  			SEND_STRING 0, "'ERROR-',DATA.TEXT" 
			}
			CASE 'TAPEMONITOR=':
			{
				nTAPEMONITOR = ATOI(DATA.TEXT)
			}
			CASE 'TONE=':
			{
				nTONE = ATOI(DATA.TEXT)
			}
			CASE 'VERSION=': 
			{
				sVERSION = DATA.TEXT 
			}
			CASE 'VIDEOINPUT=':
			{
				fnPARSE(':',DATA.TEXT,cCOMMAND)
				nAUDIOINPUT = 0
				IF(cCOMMAND[2] == '1')//ZONE 1
					nVIDEOINPUT = ATOI(cCOMMAND[1])
				ELSE IF(cCOMMAND[2] == '2')//ZONE 2
					nZONE_VIDEOINPUT = ATOI(cCOMMAND[1])
			}
			CASE 'VOLUME=':
			{
				fnPARSE(':',DATA.TEXT,cCOMMAND)
				
				IF(cCOMMAND[2] == '1')//ZONE 1
				{
					SEND_COMMAND dvTP, "'@TXT',1,cCOMMAND[1]"
				}
				ELSE IF(cCOMMAND[2] == '2')//ZONE 2
				{
					SEND_COMMAND dvTP, "'@TXT',2,cCOMMAND[1]"
				}
			}
			
		}// END SWITCH(cCMD)
	}// END STRING
}// END DATA_EVENT[vdvDEVICE]

DATA_EVENT[dvTP]
{
	ONLINE: 
	{
		SEND_COMMAND dvTP, "'@PPX'"
	}
}// END DATA_EVENT[dvTP]

BUTTON_EVENT[dvTP, nCHAN_BTN]
{
	PUSH:
	{
		STACK_VAR INTEGER nBTN
		
		nBTN = GET_LAST(nCHAN_BTN)
		SWITCH(nBTN)
		{
			CASE 1: //POWER STANDBY
				SEND_COMMAND vdvNAD_T773, "'POWER=0:1'"
				BREAK
			CASE 2: //POWER ON
				SEND_COMMAND vdvNAD_T773, "'POWER=1:1'"
				BREAK
			CASE 3:  //MUTE ON 
				SEND_COMMAND vdvNAD_T773,"'MUTE=1:1'"
				BREAK      
			CASE 4:  //MUTE OFF 
				SEND_COMMAND vdvNAD_T773,"'MUTE=0:1'"
				BREAK
			CASE 5:  //AUDIOINPUT (CD)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=3:1'"
				BREAK
			CASE 6:  //AUDIOINPUT (DISK)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=14:1'"
				BREAK
			CASE 7:  //AUDIOINPUT (TUNER)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=1:1'"
				BREAK
			CASE 8:  //86- AUDIOINPUT (EXT 7.1)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=15:1'"
				BREAK	
			CASE 9:  //VIDEOINPUT (DVD)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=1:1'"
				BREAK
			CASE 10:  //VIDEOINPUT (SATELLITE)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=4:1'"
				BREAK
			CASE 11:  //VIDEOINPUT (VCR)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=5:1'"
				BREAK
			CASE 12: //VIDEOINPUT (VID4)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=9:1'"
				BREAK
			CASE 13: //VIDEOINPUT (VID5)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=10:1'"
				BREAK
			CASE 14: //VIDEOINPUT (VID6)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=11:1'"
				BREAK
			CASE 15: //TAPEMONITOR ON
				SEND_COMMAND vdvNAD_T773,"'TAPEMONITOR=1'"
				BREAK
			CASE 16: //TAPEMONITOR OFF
				SEND_COMMAND vdvNAD_T773,"'TAPEMONITOR=0'"
				BREAK
			CASE 17: //MODE - STEREO MODE
				SEND_COMMAND vdvNAD_T773,"'MODE=0'"
				BREAK
			CASE 18: //MODE - STEREO DOWNMIX MODE
				SEND_COMMAND vdvNAD_T773,"'MODE=1'"
				BREAK
			CASE 19: //MODE - DOLBY PRO LOGIC
				SEND_COMMAND vdvNAD_T773,"'MODE=2'"
				BREAK
			CASE 20: //MODE - DOLBY PRO LOGIC II - MOVIE
				SEND_COMMAND vdvNAD_T773,"'MODE=3'"
				BREAK
			CASE 21: //MODE - DOLBY PRO LOGIC II - MUSIC
				SEND_COMMAND vdvNAD_T773,"'MODE=4'"
				BREAK
			CASE 22: //MODE - NEO:6 - CINEMA
				SEND_COMMAND vdvNAD_T773,"'MODE=5'"
				BREAK
			CASE 23: //MODE - NEO:6 - MUSIC
				SEND_COMMAND vdvNAD_T773,"'MODE=6'"
				BREAK
			CASE 24: //MODE - MATRIX 7.1
				SEND_COMMAND vdvNAD_T773,"'MODE=7'"
				BREAK
			CASE 25: //MODE - EARS
				SEND_COMMAND vdvNAD_T773,"'MODE=8'"
				BREAK
			CASE 26: //MODE - ENHANCED STEREO 1
				SEND_COMMAND vdvNAD_T773,"'MODE=9'"
				BREAK
			CASE 27: //MODE - ENHANCED STEREO 2
				SEND_COMMAND vdvNAD_T773,"'MODE=10'"
				BREAK
			CASE 28: //MODE - DOLBY SURROUND EX
				SEND_COMMAND vdvNAD_T773,"'MODE=11'"
				BREAK
			CASE 29: //MODE - DOLBY PRO LOGIC IIx - MOVIE
				SEND_COMMAND vdvNAD_T773,"'MODE=12'"
				BREAK
			CASE 30: //MODE - DOLBY PRO LOGIC IIx - MUSIC
				SEND_COMMAND vdvNAD_T773,"'MODE=13'"
				BREAK
			CASE 31: //AM BAND
				SEND_COMMAND vdvNAD_T773,"'BAND=AM'"
				BREAK
			CASE 32: //FM BAND
				SEND_COMMAND vdvNAD_T773,"'BAND=FM'"
				BREAK
			CASE 33: //FM PRESET 1
				SEND_COMMAND vdvNAD_T773,"'PRESET=1:FM'"
				BREAK
			CASE 34: //FM PRESET 2
				SEND_COMMAND vdvNAD_T773,"'PRESET=2:FM'"
				BREAK
			CASE 35: //FM PRESET 3
				SEND_COMMAND vdvNAD_T773,"'PRESET=3:FM'"
				BREAK
			CASE 36: //FM PRESET 4
				SEND_COMMAND vdvNAD_T773,"'PRESET=4:FM'"
				BREAK
			CASE 37: //FM PRESET 5
				SEND_COMMAND vdvNAD_T773,"'PRESET=5:FM'"
				BREAK
			CASE 38: //FM PRESET 6
				SEND_COMMAND vdvNAD_T773,"'PRESET=6:FM'"
				BREAK
			CASE 39: //FM PRESET 7
				SEND_COMMAND vdvNAD_T773,"'PRESET=7:FM'"
				BREAK
			CASE 40: //FM PRESET 8
				SEND_COMMAND vdvNAD_T773,"'PRESET=8:FM'"
				BREAK
			CASE 41: //FM PRESET 9
				SEND_COMMAND vdvNAD_T773,"'PRESET=9:FM'"
				BREAK
			CASE 42: //FM PRESET 10
				SEND_COMMAND vdvNAD_T773,"'PRESET=10:FM'"
				BREAK
			CASE 43: //FM PRESET 11
				SEND_COMMAND vdvNAD_T773,"'PRESET=11:FM'"
				BREAK
			CASE 44: //FM PRESET 12
				SEND_COMMAND vdvNAD_T773,"'PRESET=12:FM'"
				BREAK
			CASE 45: //FM PRESET 13
				SEND_COMMAND vdvNAD_T773,"'PRESET=13:FM'"
				BREAK
			CASE 46: //FM PRESET 14
				SEND_COMMAND vdvNAD_T773,"'PRESET=14:FM'"
				BREAK
			CASE 47: //FM PRESET 15
				SEND_COMMAND vdvNAD_T773,"'PRESET=15:FM'"
				BREAK
			CASE 48: //FM PRESET 16
				SEND_COMMAND vdvNAD_T773,"'PRESET=16:FM'"
				BREAK
			CASE 49: //FM PRESET 17
				SEND_COMMAND vdvNAD_T773,"'PRESET=17:FM'"
				BREAK
			CASE 50: //FM PRESET 18
				SEND_COMMAND vdvNAD_T773,"'PRESET=18:FM'"
				BREAK
			CASE 51: //FM PRESET 19
				SEND_COMMAND vdvNAD_T773,"'PRESET=19:FM'"
				BREAK
			CASE 52: //FM PRESET 20
				SEND_COMMAND vdvNAD_T773,"'PRESET=20:FM'"
				BREAK
			CASE 53: //FM PRESET 21
				SEND_COMMAND vdvNAD_T773,"'PRESET=21:FM'"
				BREAK
			CASE 54: //FM PRESET 22
				SEND_COMMAND vdvNAD_T773,"'PRESET=22:FM'"
				BREAK
			CASE 55: //FM PRESET 23
				SEND_COMMAND vdvNAD_T773,"'PRESET=23:FM'"
				BREAK
			CASE 56: //FM PRESET 24
				SEND_COMMAND vdvNAD_T773,"'PRESET=24:FM'"
				BREAK
			CASE 57: //FM PRESET 25
				SEND_COMMAND vdvNAD_T773,"'PRESET=25:FM'"
				BREAK
			CASE 58: //FM PRESET 26
				SEND_COMMAND vdvNAD_T773,"'PRESET=26:FM'"
				BREAK
			CASE 59: //FM PRESET 27
				SEND_COMMAND vdvNAD_T773,"'PRESET=27:FM'"
				BREAK
			CASE 60: //FM PRESET 28
				SEND_COMMAND vdvNAD_T773,"'PRESET=28:FM'"
				BREAK
			CASE 61: //FM PRESET 29
				SEND_COMMAND vdvNAD_T773,"'PRESET=29:FM'"
				BREAK
			CASE 62: //FM PRESET 30
				SEND_COMMAND vdvNAD_T773,"'PRESET=30:FM'"
				BREAK
			CASE 63: //AM PRESET 1
				SEND_COMMAND vdvNAD_T773,"'PRESET=1:AM'"
				BREAK
			CASE 64: //AM PRESET 2
				SEND_COMMAND vdvNAD_T773,"'PRESET=2:AM'"
				BREAK
			CASE 65: //AM PRESET 3
				SEND_COMMAND vdvNAD_T773,"'PRESET=3:AM'"
				BREAK
			CASE 66: //AM PRESET 4
				SEND_COMMAND vdvNAD_T773,"'PRESET=4:AM'"
				BREAK
			CASE 67: //AM PRESET 5
				SEND_COMMAND vdvNAD_T773,"'PRESET=5:AM'"
				BREAK
			CASE 68: //AM PRESET 6
				SEND_COMMAND vdvNAD_T773,"'PRESET=6:AM'"
				BREAK
			CASE 69: //AM PRESET 7
				SEND_COMMAND vdvNAD_T773,"'PRESET=7:AM'"
				BREAK
			CASE 70: //AM PRESET 8
				SEND_COMMAND vdvNAD_T773,"'PRESET=8:AM'"
				BREAK
			CASE 71: //AM PRESET 9
				SEND_COMMAND vdvNAD_T773,"'PRESET=9:AM'"
				BREAK
			CASE 72: //AM PRESET 10
				SEND_COMMAND vdvNAD_T773,"'PRESET=10:AM'"
				BREAK
			CASE 73: //SPEAKER A OFF
				SEND_COMMAND vdvNAD_T773,"'SPEAKER=A:0'"
				BREAK
			CASE 74: //SPEAKER A ON
				SEND_COMMAND vdvNAD_T773,"'SPEAKER=A:1'"
				BREAK
			CASE 75: //SPEAKER B OFF
				SEND_COMMAND vdvNAD_T773,"'SPEAKER=B:0'"
				BREAK
			CASE 76: //SPEAKER B ON
				SEND_COMMAND vdvNAD_T773,"'SPEAKER=B:1'"
				BREAK
			CASE 77: //TONE DEFEAT
				SEND_COMMAND vdvNAD_T773,"'TONE=0'"
				BREAK
			CASE 78: //TONE ON
				SEND_COMMAND vdvNAD_T773,"'TONE=1'"
				BREAK
			CASE 79: //FM MUTE ON
				SEND_COMMAND vdvNAD_T773,"'FMMUTE=1'"
				BREAK
			CASE 80: //FM MUTE OFF
				SEND_COMMAND vdvNAD_T773,"'FMMUTE=0'"
				BREAK
			CASE 81: //SUB UP
				SEND_COMMAND vdvNAD_T773,"'SUB=+'"
				BREAK
			CASE 82: //SUB DN
				SEND_COMMAND vdvNAD_T773,"'SUB=-'"
				BREAK
			CASE 83: //TREBLE UP
				SEND_COMMAND vdvNAD_T773,"'TREBLE=+'"
				BREAK			
			CASE 84: //TREBLE DN
				SEND_COMMAND vdvNAD_T773,"'TREBLE=-'"
				BREAK
			CASE 85: //BASS UP
				SEND_COMMAND vdvNAD_T773,"'BASS=+'"
				BREAK
			CASE 86:  //BASS DN
				SEND_COMMAND vdvNAD_T773,"'BASS=-'"
				BREAK
			CASE 87:  //ZONE POWER STANDBY
				SEND_COMMAND vdvNAD_T773, "'POWER=0:2'"
				BREAK
			CASE 88:  //ZONE POWER ON
				SEND_COMMAND vdvNAD_T773, "'POWER=1:2'"
				BREAK
			CASE 89:  //ZONE MUTE ON 
				SEND_COMMAND vdvNAD_T773,"'MUTE=1:2'"
				BREAK 
			CASE 90:  //ZONE MUTE OFF
				SEND_COMMAND vdvNAD_T773,"'MUTE=0:2'"
				BREAK 
			CASE 91:  //ZONE AUDIOINPUT (CD)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=3:2'"
				BREAK
			CASE 92:  //ZONE AUDIOINPUT (DISK)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=14:2'"
				BREAK
			CASE 93:  //ZONE AUDIOINPUT (TUNER)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=1:2'"
				BREAK
			CASE 94:  //ZONE AUDIOINPUT (LOCAL)
				SEND_COMMAND vdvNAD_T773,"'AUDIOINPUT=15:2'"
				BREAK
			CASE 95:  //ZONE VIDEOINPUT (DVD)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=1:2'"
				BREAK
			CASE 96:  //ZONE VIDEOINPUT (SATELLITE)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=4:2'"
				BREAK
			CASE 97:  //ZONE VIDEOINPUT (VCR)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=5:2'"
				BREAK
			CASE 98:  //ZONE VIDEOINPUT (VID4)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=9:2'"
				BREAK
			CASE 99:  //ZONE VIDEOINPUT (VID5)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=10:2'"
				BREAK
			CASE 100: //ZONE VIDEOINPUT (VID6)
				SEND_COMMAND vdvNAD_T773,"'VIDEOINPUT=11:2'"
				BREAK			
			CASE 101: //VOLUME UP
				SEND_COMMAND vdvNAD_T773,"'VOLUME=+:1'"
				BREAK
			CASE 102: //VOLUME DN
				SEND_COMMAND vdvNAD_T773,"'VOLUME=-:1'"
				BREAK
			CASE 103: //ZONE VOLUME UP
				SEND_COMMAND vdvNAD_T773,"'VOLUME=+:2'"
				BREAK
			CASE 104: //ZONE VOLUME DN
				SEND_COMMAND vdvNAD_T773,"'VOLUME=-:2'"
				BREAK
			CASE 105: //SURR - VOLUME UP
				SEND_COMMAND vdvNAD_T773,"'SURR=+'"
				BREAK
			CASE 106: //SURR - VOLUME DN
				SEND_COMMAND vdvNAD_T773,"'SURR=-'"
				BREAK
			CASE 107: //DISPLAY
				SEND_COMMAND vdvNAD_T773,"'DISPLAY'"
				BREAK
			CASE 108: //LATE NIGHT
				SEND_COMMAND vdvNAD_T773,"'NIGHT'"
				BREAK
			CASE 109: //MODE - NEXT MODE
				SEND_COMMAND vdvNAD_T773,"'MODE=+'"
				BREAK
			CASE 110: //SLEEP
				SEND_COMMAND vdvNAD_T773,"'SLEEP'"
				BREAK
			CASE 111: //CENTER UP
				SEND_COMMAND vdvNAD_T773,"'CENTER=+'"
				BREAK
			CASE 112: //CENTER DN
				SEND_COMMAND vdvNAD_T773,"'CENTER=-'"
				BREAK
			CASE 113: //CURSOR - UP
				SEND_COMMAND vdvNAD_T773,"'CURSOR=+'"
				BREAK
			CASE 114: //CURSOR - DN
				SEND_COMMAND vdvNAD_T773,"'CURSOR=-'"
				BREAK
			CASE 115: //CURSOR - LEFT
				SEND_COMMAND vdvNAD_T773,"'CURSOR=<'"
				BREAK
			CASE 116: //CURSOR - RIGHT
				SEND_COMMAND vdvNAD_T773,"'CURSOR=>'"
				BREAK
			CASE 117: //CURSOR - ENTER
				SEND_COMMAND vdvNAD_T773,"'MENUSELECT'"
				BREAK
		}// END SWITCH(nBTN)
	}// END PUSH
	HOLD[2,REPEAT]:
	{
		STACK_VAR INTEGER nBTN
		
		nBTN = GET_LAST(nCHAN_BTN)
		SWITCH(nBTN)
		{
			CASE 101: //VOLUME UP
				SEND_COMMAND vdvNAD_T773,"'VOLUME=+:1'"
				BREAK
			CASE 102: //VOLUME DN
				SEND_COMMAND vdvNAD_T773,"'VOLUME=-:1'"
				BREAK
			CASE 103: //ZONE VOLUME UP
				SEND_COMMAND vdvNAD_T773,"'VOLUME=+:2'"
				BREAK
			CASE 104: //ZONE VOLUME DN
				SEND_COMMAND vdvNAD_T773,"'VOLUME=-:2'"
				BREAK
		}//END SWITCH	
	}//END HOLD[2,REPEAT]
}// END BUTTON_EVENT[dvTP, nCHAN_BTN]
(***********************************************************)
(*            THE ACTUAL PROGRAM GOES BELOW                *)
(***********************************************************)
DEFINE_PROGRAM

[dvTP,1]  = nPOWER = 0
[dvTP,2]  = nPOWER = 1
[dvTP,3]  = nMUTE = 1
[dvTP,4]  = nMUTE = 0
[dvTP,5]  = nAUDIOINPUT = 3
[dvTP,6]  = nAUDIOINPUT = 14
[dvTP,8]  = nAUDIOINPUT = 15
[dvTP,7]  = nAUDIOINPUT = 1
[dvTP,9]  = nVIDEOINPUT = 1
[dvTP,10] = nVIDEOINPUT = 4
[dvTP,11] = nVIDEOINPUT = 5
[dvTP,12] = nVIDEOINPUT = 9
[dvTP,13] = nVIDEOINPUT = 10
[dvTP,14] = nVIDEOINPUT = 11
[dvTP,15] = nTAPEMONITOR = 1
[dvTP,16] = nTAPEMONITOR = 0
[dvTP,17] = nMODE = 0
[dvTP,18] = nMODE = 1
[dvTP,19] = nMODE = 2
[dvTP,20] = nMODE = 3
[dvTP,21] = nMODE = 4
[dvTP,22] = nMODE = 5
[dvTP,23] = nMODE = 6
[dvTP,24] = nMODE = 7
[dvTP,25] = nMODE = 8
[dvTP,26] = nMODE = 9
[dvTP,27] = nMODE = 10
[dvTP,28] = nMODE = 11
[dvTP,29] = nMODE = 12
[dvTP,30] = nMODE = 13
[dvTP,31] = nBAND = 0
[dvTP,32] = nBAND = 1
[dvTP,33] = nFMPRESET = 1
[dvTP,34] = nFMPRESET = 2
[dvTP,35] = nFMPRESET = 3
[dvTP,36] = nFMPRESET = 4
[dvTP,37] = nFMPRESET = 5
[dvTP,38] = nFMPRESET = 6
[dvTP,39] = nFMPRESET = 7
[dvTP,40] = nFMPRESET = 8
[dvTP,41] = nFMPRESET = 9
[dvTP,42] = nFMPRESET = 10
[dvTP,43] = nFMPRESET = 11
[dvTP,44] = nFMPRESET = 12
[dvTP,45] = nFMPRESET = 13
[dvTP,46] = nFMPRESET = 14
[dvTP,47] = nFMPRESET = 15
[dvTP,48] = nFMPRESET = 16
[dvTP,49] = nFMPRESET = 17
[dvTP,50] = nFMPRESET = 18
[dvTP,51] = nFMPRESET = 19
[dvTP,52] = nFMPRESET = 20
[dvTP,53] = nFMPRESET = 21
[dvTP,54] = nFMPRESET = 22
[dvTP,55] = nFMPRESET = 23
[dvTP,56] = nFMPRESET = 24
[dvTP,57] = nFMPRESET = 25
[dvTP,58] = nFMPRESET = 26
[dvTP,59] = nFMPRESET = 27
[dvTP,60] = nFMPRESET = 28
[dvTP,61] = nFMPRESET = 29
[dvTP,62] = nFMPRESET = 30
[dvTP,63] = nAMPRESET = 1
[dvTP,64] = nAMPRESET = 2
[dvTP,65] = nAMPRESET = 3
[dvTP,66] = nAMPRESET = 4
[dvTP,67] = nAMPRESET = 5
[dvTP,68] = nAMPRESET = 6
[dvTP,69] = nAMPRESET = 7
[dvTP,70] = nAMPRESET = 8
[dvTP,71] = nAMPRESET = 9
[dvTP,72] = nAMPRESET = 10
[dvTP,73] = nSPEAKER_A = 0
[dvTP,74] = nSPEAKER_A = 1
[dvTP,75] = nSPEAKER_B = 0
[dvTP,76] = nSPEAKER_B = 1
[dvTP,77] = nTONE = 0
[dvTP,78] = nTONE = 1
[dvTP,79] = nFMMUTE = 1
[dvTP,80] = nFMMUTE = 0
[dvTP,87]  = nZONE_POWER = 0
[dvTP,88]  = nZONE_POWER = 1
[dvTP,89]  = nZONE_MUTE = 1
[dvTP,90]  = nZONE_MUTE = 0
[dvTP,91]  = nZONE_AUDIOINPUT = 3
[dvTP,92]  = nZONE_AUDIOINPUT = 14
[dvTP,93]  = nZONE_AUDIOINPUT = 1
[dvTP,94]  = nZONE_AUDIOINPUT = 15
[dvTP,95]  = nZONE_VIDEOINPUT = 1
[dvTP,96]  = nZONE_VIDEOINPUT = 4
[dvTP,97]  = nZONE_VIDEOINPUT = 5
[dvTP,98]  = nZONE_VIDEOINPUT = 9
[dvTP,99]  = nZONE_VIDEOINPUT = 10
[dvTP,100] = nZONE_VIDEOINPUT = 11
(***********************************************************)
(*                     END OF PROGRAM                      *)
(*        DO NOT PUT ANY CODE BELOW THIS COMMENT           *)
(***********************************************************)