PROGRAM_NAME='Nad_T773_Main'
(*{{PS_SOURCE_INFO(PROGRAM STATS)                          *)
(***********************************************************)
(*  FILE CREATED ON: 11/08/2004 AT: 10:00:00               *)
(***********************************************************)
(*  FILE_LAST_MODIFIED_ON: 11/22/2004 AT: 18:00:00         *)
(***********************************************************)
(*  ORPHAN_FILE_PLATFORM: 1                                *)
(***********************************************************)
(*!!FILE REVISION: Rev 0                                   *)
(*  REVISION DATE: 11/22/2004                              *)
(*                                                         *)
(*  COMMENTS:                                              *)
(*                                                         *)
(***********************************************************)
(*}}PS_SOURCE_INFO                                         *)
(***********************************************************)

(***********************************************************)
(* System Type : Netlinx                                   *)
(***********************************************************)
(* REV HISTORY:                                            *)
(***********************************************************)

(***********************************************************)
(*          DEVICE NUMBER DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_DEVICE

dvTP        = 10001:1:0           (* NXT-CV12 TOUCH PANEL *)
dvNAD_T773  =  5001:1:0           (* NAD T773     		  *)
vdvNAD_T773 = 33001:1:0           (* VIRTUAL DEVICE       *)

(* CABLE FOR THE NAD T773 IS FG#10-752-04. SEE DOCUMENTATION FOR WIRING DETAILS. *)

(***********************************************************)
(*               CONSTANT DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_CONSTANT
(***********************************************************)
(*              DATA TYPE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_TYPE
(***********************************************************)
(*               VARIABLE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_VARIABLE

INTEGER nCHAN_BTN[] =                   // CHANNEL BUTTONS ON TOUCH PANEL
{
	// format is as follows : "<buttonID>, //<buttonINDEX> - explanation " 
	// The <buttonID> can be any valid number, 
	// however the <buttonINDEX> position must not change
	
	1,  //1-   POWER STANDBY
	2,  //2-   POWER ON
	3,  //3-   MUTE ON 
	4,  //4-   MUTE OFF
	5,  //5-   AUDIOINPUT (CD)
	6,  //6-   AUDIOINPUT (DISK)
	7,	//7-   AUDIOINPUT (TUNER)
	8,	//8-   AUDIOINPUT (EXT 7.1)
	9,  //9-   VIDEOINPUT (DVD)
	10, //10-  VIDEOINPUT (SATELLITE)
	11, //11-  VIDEOINPUT (VCR)
	12, //12-  VIDEOINPUT (VID4)
	13, //13-  VIDEOINPUT (VID5)
	14, //14-  VIDEOINPUT (VID6)
	15,	//15-  TAPEMONITOR ON
	16, //16-  TAPEMONITOR OFF
	17, //17-  MODE - STEREO MODE
	18, //18-  MODE - STEREO DOWNMIX MODE
	19, //19-  MODE - DOLBY PRO LOGIC
	20, //20-  MODE - DOLBY PRO LOGIC II - MOVIE
	21, //21-  MODE - DOLBY PRO LOGIC II - MUSIC
	22, //22-  MODE - NEO:6 - CINEMA
	23, //23-  MODE - NEO:6 - MUSIC
	24, //24-  MODE - MATRIX 7.1
	25, //25-  MODE - EARS
	26, //26-  MODE - ENHANCED STEREO 1
	27, //27-  MODE - ENHANCED STEREO 2
	28, //28-  MODE - DOLBY SURROUND EX
	29, //29-  MODE - DOLBY PRO LOGIC IIx - MOVIE
	30, //30-  MODE - DOLBY PRO LOGIC IIx - MUSIC
	31, //31-  AM BAND
	32, //32-  FM BAND
	33, //33-  FM PRESET 1
	34, //34-  FM PRESET 2
	35, //35-  FM PRESET 3
	36, //36-  FM PRESET 4
	37, //37-  FM PRESET 5
	38, //38-  FM PRESET 6
	39, //39-  FM PRESET 7
	40, //40-  FM PRESET 8
	41, //41-  FM PRESET 9
	42, //42-  FM PRESET 10
	43, //43-  FM PRESET 11
	44, //44-  FM PRESET 12
	45, //45-  FM PRESET 13
	46, //46-  FM PRESET 14
	47, //47-  FM PRESET 15
	48, //48-  FM PRESET 16
	49, //49-  FM PRESET 17
	50, //50-  FM PRESET 18
	51, //51-  FM PRESET 19
	52, //52-  FM PRESET 20
	53, //53-  FM PRESET 21
	54, //54-  FM PRESET 22
	55, //55-  FM PRESET 23
	56, //56-  FM PRESET 24
	57, //57-  FM PRESET 25
	58, //58-  FM PRESET 26
	59, //59-  FM PRESET 27
	60, //60-  FM PRESET 28
	61, //61-  FM PRESET 29
	62, //62-  FM PRESET 30
	63, //63-  AM PRESET 1
	64, //64-  AM PRESET 2
	65, //65-  AM PRESET 3
	66, //66-  AM PRESET 4
	67, //67-  AM PRESET 5
	68, //68-  AM PRESET 6
	69, //69-  AM PRESET 7
	70, //70-  AM PRESET 8
	71, //71-  AM PRESET 9
	72, //72-  AM PRESET 10
	73, //73-  SPEAKER A OFF
	74, //74-  SPEAKER A ON
	75, //75-  SPEAKER B OFF
	76, //76-  SPEAKER B ON
	77, //77-  TONE DEFEAT
	78, //78-  TONE ON
	79, //79-  FM MUTE ON
	80, //80-  FM MUTE OFF
	81, //81-  SUB UP
	82, //82-  SUB DN
	83, //83-  TREBLE UP
	84, //84-  TREBLE DN
	85, //85-  BASS UP
	86, //86-  BASS DN
	87, //87-  ZONE POWER STANDBY
	88, //88-  ZONE POWER ON
	89, //89-  ZONE MUTE ON 
	90, //90-  ZONE MUTE OFF
	91, //91-  ZONE AUDIOINPUT (CD)
	92, //92-  ZONE AUDIOINPUT (DISK)
	93,	//93-  ZONE AUDIOINPUT (TUNER)
	94, //94-  ZONE AUDIOINPUT (LOCAL)
	95, //95-  ZONE VIDEOINPUT (DVD)
	96, //96-  ZONE VIDEOINPUT (SATELLITE)
	97, //97-  ZONE VIDEOINPUT (VCR)
	98, //98-  ZONE VIDEOINPUT (VID4)
	99, //99-  ZONE VIDEOINPUT (VID5)
	100,//100- ZONE VIDEOINPUT (VID6)	
	101,//101- VOLUME UP
	102,//102- VOLUME DN
	103,//103- ZONE VOLUME UP
	104,//104- ZONE VOLUME DN
	105,//105- SURR - VOLUME UP
	106,//106- SURR - VOLUME DN
	107,//107- DISPLAY
	108,//108- LATE NIGHT
	109,//109- MODE - NEXT MODE
	110,//110- SLEEP
	111,//111- CENTER UP
	112,//112- CENTER DN
	113,//113- CURSOR - UP
	114,//114- CURSOR - DN
	115,//115- CURSOR - LEFT
	116,//116- CURSOR - RIGHT
	117 //117- CURSOR - ENTER
}

(***********************************************************)
(*               LATCHING DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_LATCHING
(***********************************************************)
(*       MUTUALLY EXCLUSIVE DEFINITIONS GO BELOW           *)
(***********************************************************)
DEFINE_MUTUALLY_EXCLUSIVE
(***********************************************************)
(*        SUBROUTINE/FUNCTION DEFINITIONS GO BELOW         *)
(***********************************************************)

(***********************************************************)
(*                STARTUP CODE GOES BELOW                  *)
(***********************************************************)
DEFINE_START

DEFINE_MODULE 'Nad_T773_Comm' COMM1(vdvNAD_T773, dvNAD_T773)
DEFINE_MODULE 'Nad_T773_UI'   TP1(vdvNAD_T773, dvTP, nCHAN_BTN)
(***********************************************************)
(*                THE EVENTS GOES BELOW                    *)
(***********************************************************)
DEFINE_EVENT
(***********************************************************)
(*            THE ACTUAL PROGRAM GOES BELOW                *)
(***********************************************************)
DEFINE_PROGRAM
(***********************************************************)
(*                     END OF PROGRAM                      *)
(*        DO NOT PUT ANY CODE BELOW THIS COMMENT           *)
(***********************************************************)