/*
 * This program attaches Infocom's Apple //e Z5 interpreter to a game.
 * It outputs either 1 or 2 disk images.
 * 
 * Written by S. Nickolas, Dec. 19, 2016
 */

#include <stdint.h>
#include <stdio.h>
#include <string.h>

uint8_t disk1[143360], disk2[232960];
uint8_t raw[161280];

int interl[16]={0x0,0xD,0xB,0x9,0x7,0x5,0x3,0x1,0xE,0xC,0xA,0x8,0x6,0x4,0x2,0xF};

uint8_t translate[256] =
{
 0x96, 0x97, 0x9A, 0x9B, 0x9D, 0x9E, 0x9F, 0xA6,
 0xA7, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB2, 0xB3,
 0xB4, 0xB5, 0xB6, 0xB7, 0xB9, 0xBA, 0xBB, 0xBC,
 0xBD, 0xBE, 0xBF, 0xCB, 0xCD, 0xCE, 0xCF, 0xD3,
 0xD6, 0xD7, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE,
 0xDF, 0xE5, 0xE6, 0xE7, 0xE9, 0xEA, 0xEB, 0xEC,
 0xED, 0xEE, 0xEF, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,
 0xF7, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x01,
 0x80, 0x80, 0x02, 0x03, 0x80, 0x04, 0x05, 0x06,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x07, 0x08,
 0x80, 0x80, 0x80, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
 0x80, 0x80, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
 0x80, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
 0x80, 0x80, 0x80, 0x1B, 0x80, 0x1C, 0x1D, 0x1E,
 0x80, 0x80, 0x80, 0x1F, 0x80, 0x80, 0x20, 0x21,
 0x80, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
 0x80, 0x80, 0x80, 0x80, 0x80, 0x29, 0x2A, 0x2B,
 0x80, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32,
 0x80, 0x80, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
 0x80, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F
};

uint8_t markers[35][2]=
{{0xAA, 0xAA}, {0xAA, 0xAB}, {0xAB, 0xAA}, {0xAB, 0xAB}, {0xAA, 0xAE}, {0xAA, 0xAF}, {0xAB, 0xAE}, 
 {0xAB, 0xAF}, {0xAE, 0xAA}, {0xAE, 0xAB}, {0xAF, 0xAA}, {0xAF, 0xAB}, {0xAE, 0xAE}, {0xAE, 0xAF}, 
 {0xAF, 0xAE}, {0xAF, 0xAF}, {0xAA, 0xBA}, {0xAA, 0xBB}, {0xAB, 0xBA}, {0xAB, 0xBB}, {0xAA, 0xBE}, 
 {0xAA, 0xBF}, {0xAB, 0xBE}, {0xAB, 0xBF}, {0xAE, 0xBA}, {0xAE, 0xBB}, {0xAF, 0xBA}, {0xAF, 0xBB}, 
 {0xAE, 0xBE}, {0xAE, 0xBF}, {0xAF, 0xBE}, {0xAF, 0xBF}, {0xBA, 0xAA}, {0xBA, 0xAB}, {0xBB, 0xAA}};

/* disk 1 process */
void reorient (int t)
{
 int off, sec1, sec2;
 uint8_t trk[4096];
 
 off=t*4096;
 for (sec1=0;sec1<16;sec1++)
 {
  memcpy(&(trk[(interl[sec1]<<8)]),&(disk1[off+(sec1<<8)]),256);
 }
 memcpy(&(disk1[off]),trk,4096);
}

/* disk 2 process */
uint8_t *mksec (uint8_t *nibs, uint8_t *bytes)
{
 int checksum, diskbyte;
 
 checksum=0;
 for (diskbyte=0; diskbyte<0x0156; diskbyte++)
 {
  int v;
  v=(diskbyte>=0x56)?(bytes[diskbyte-0x56]>>2):
                     ((bytes[diskbyte     ]&0x02)>>1)|
                     ((bytes[diskbyte     ]&0x01)<<1)|
                     ((bytes[diskbyte+0x56]&0x02)<<1)|
                     ((bytes[diskbyte+0x56]&0x01)<<3)|
                     ((bytes[diskbyte+0xAC]&0x02)<<3)|
                     ((bytes[diskbyte+0xAC]&0x01)<<5);
  *(nibs++)=translate[(checksum^v)&0x3F];
  checksum=v;
 }
 *(nibs++)=translate[checksum&0x3F];
 return nibs;
}

uint8_t track[0x1A00];

void mktrk (uint8_t *bytes)
{
 int s, o;
 
 memset(track,255,0x1A00);
 track[0]=0xD5;
 track[1]=0xAA;
 track[2]=0xAD;
 for (s=0; s<18; s++)
 {
  o=5+(s*343);
  mksec(&(track[o]),&(bytes[s<<8]));
 }
}

int main (int argc, char **argv)
{
 long l;
 int twodisks;
 
 FILE *file;
 
 twodisks=0;
 
 memset(disk1,0,143360);
 
 if ((argc<3)||(argc>5))
 {
  fprintf (stderr, "usage: %s stub.bin filename.z5 filename.dsk\n", argv[0]);
  return -1;
 }
 
 file=fopen(argv[1],"rb");
 if (!file)
 {
  perror(argv[1]);
  return -1;
 }
 fseek(file,0,SEEK_END);
 l=ftell(file);
 fseek(file,0,SEEK_SET);
 if (l!=16384)
 {
  fclose(file);
  fprintf (stderr, "%s must be 16384 bytes\n", argv[1]);
  return -1;
 }
 fread(disk1,16384,1,file);
 fclose(file);
 
 file=fopen(argv[2],"rb");
 if (!file)
 {
  perror(argv[2]);
  return -1;
 }
 fseek(file,0,SEEK_END);
 l=ftell(file);
 fseek(file,0,SEEK_SET);
 if (l>100864)
 {
  twodisks=1;
  fread(&(disk1[16384]),1,100864,file);
  fread(raw,l-100864,1,file);
 }
 else
 {
  fread(&(disk1[16384]),1,l,file);
 }
 
 fclose(file);
 
 if ((argc-twodisks)!=4)
 {
  fprintf (stderr, "%d disk images are needed.\n", twodisks+1);
  return -1;
 }
 
 for (l=4; l<35; l++) reorient(l);
 
 file=fopen(argv[3],"wb");
 if (!file)
 {
  perror(argv[3]);
  return -1;
 }
 fwrite(disk1,4096,35,file);
 fclose(file);
 
 if (twodisks)
 {
  for (l=0; l<35; l++)
  {
   mktrk(&(raw[l*4608]));
   track[3]=markers[l][0];
   track[4]=markers[l][1];
   memcpy(&(disk2[l*0x1A00]),track,0x1A00);
  }
  file=fopen(argv[4],"wb");
  if (!file)
  {
   perror(argv[4]);
   return -2;
  }
  fwrite(disk2,232960,1,file);
  fclose(file);
 }
 
 return 0;
}
