/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx.plaf;

import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.BuddySupport;
import org.jdesktop.xswingx.JXSearchField;
import org.jdesktop.xswingx.plaf.AbstractUIChangeHandler;
import org.jdesktop.xswingx.plaf.BuddyTextFieldUI;
import org.jdesktop.xswingx.plaf.PromptTextAreaUI;
import org.jdesktop.xswingx.plaf.PromptTextUI;
import org.jdesktop.xswingx.plaf.SearchFieldUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextUIWrapper<UI extends TextUI> {
    private static final DefaultWrapper defaultWrapper = new DefaultWrapper();
    private Class<UI> wrapperClass;
    private final TextUIChangeHandler uiChangeHandler = new TextUIChangeHandler();

    public static final TextUIWrapper<? extends PromptTextUI> getDefaultWrapper() {
        return defaultWrapper;
    }

    protected TextUIWrapper(Class<UI> wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public final void install(JTextComponent textComponent, boolean stayOnUIChange) {
        this.replaceUIIfNeeded(textComponent);
        if (stayOnUIChange) {
            this.uiChangeHandler.install(textComponent);
        }
    }

    protected boolean replaceUIIfNeeded(JTextComponent textComponent) {
        if (this.wrapperClass.isAssignableFrom(textComponent.getUI().getClass())) {
            return false;
        }
        textComponent.setUI((TextUI)this.wrapUI(textComponent));
        return true;
    }

    public abstract UI wrapUI(JTextComponent var1);

    public Class<UI> getWrapperClass() {
        return this.wrapperClass;
    }

    public final void uninstall(JTextComponent textComponent) {
        this.uiChangeHandler.uninstall(textComponent);
        textComponent.updateUI();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DefaultWrapper
    extends TextUIWrapper<PromptTextUI> {
        private DefaultWrapper() {
            super(PromptTextUI.class);
        }

        @Override
        public PromptTextUI wrapUI(JTextComponent textComponent) {
            TextUI textUI = textComponent.getUI();
            if (textUI instanceof PromptTextUI) {
                return (PromptTextUI)textUI;
            }
            if (textUI instanceof BasicTextFieldUI) {
                if (textComponent instanceof JXSearchField) {
                    return new SearchFieldUI(textUI);
                }
                return new BuddyTextFieldUI(textUI);
            }
            if (textUI instanceof BasicTextAreaUI) {
                return new PromptTextAreaUI(textUI);
            }
            throw new IllegalArgumentException();
        }

        @Override
        protected boolean replaceUIIfNeeded(JTextComponent textComponent) {
            boolean replaced = super.replaceUIIfNeeded(textComponent);
            if (replaced && textComponent instanceof JTextField) {
                BuddySupport.ensureBuddiesAreInComponentHierarchy((JTextField)textComponent);
            }
            return replaced;
        }
    }

    private final class TextUIChangeHandler
    extends AbstractUIChangeHandler {
        private TextUIChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent txt = (JTextComponent)evt.getSource();
            TextUIWrapper.this.replaceUIIfNeeded(txt);
        }
    }
}

