/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.xswingx.JXSearchField;
import org.jdesktop.xswingx.NativeSearchFieldSupport;

public class RecentSearches
implements ActionListener {
    private Preferences prefsNode;
    private int maxRecents = 5;
    private List<String> recentSearches = new ArrayList<String>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public RecentSearches(String saveName) {
        this(null, saveName);
    }

    public RecentSearches(Preferences prefs, String saveName) {
        if (prefs == null) {
            try {
                prefs = Preferences.userRoot();
            }
            catch (AccessControlException ace) {
                Logger.getLogger(this.getClass().getName()).warning("cannot acces preferences. persistency disabled.");
            }
        }
        if (prefs != null && saveName != null) {
            this.prefsNode = prefs.node(saveName);
            this.load();
        }
    }

    private void load() {
        try {
            String[] recent = new String[this.prefsNode.keys().length];
            String[] arr$ = this.prefsNode.keys();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String key;
                recent[this.prefsNode.getInt((String)key, (int)-1)] = key = arr$[i$];
            }
            this.recentSearches.addAll(Arrays.asList(recent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        if (this.prefsNode == null) {
            return;
        }
        try {
            this.prefsNode.clear();
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        int i = 0;
        for (String search : this.recentSearches) {
            this.prefsNode.putInt(search, i++);
        }
    }

    public void put(String searchString) {
        if (searchString == null || searchString.trim().length() == 0) {
            return;
        }
        int lastIndex = this.recentSearches.indexOf(searchString);
        if (lastIndex != -1) {
            this.recentSearches.remove(lastIndex);
        }
        this.recentSearches.add(0, searchString);
        if (this.getLength() > this.getMaxRecents()) {
            this.recentSearches.remove(this.recentSearches.size() - 1);
        }
        this.save();
        this.fireChangeEvent();
    }

    public String[] getRecentSearches() {
        return this.recentSearches.toArray(new String[0]);
    }

    public int getLength() {
        return this.recentSearches.size();
    }

    public void removeAll() {
        this.recentSearches.clear();
        this.save();
        this.fireChangeEvent();
    }

    public int getMaxRecents() {
        return this.maxRecents;
    }

    public void setMaxRecents(int maxRecents) {
        this.maxRecents = maxRecents;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public ChangeListener[] getChangeListeners() {
        return this.listeners.toArray(new ChangeListener[0]);
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    protected JPopupMenu createPopupMenu(JTextField searchField) {
        return new RecentSearchesPopup(this, searchField);
    }

    public void install(JTextField searchField) {
        searchField.addActionListener(this);
        NativeSearchFieldSupport.setFindPopupMenu(searchField, this.createPopupMenu(searchField));
    }

    public void uninstall(JXSearchField searchField) {
        searchField.removeActionListener(this);
        if (searchField.getFindPopupMenu() instanceof RecentSearchesPopup) {
            this.removeChangeListener((ChangeListener)((Object)searchField.getFindPopupMenu()));
            searchField.setFindPopupMenu(null);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.put(e.getActionCommand());
    }

    public static class RecentSearchesPopup
    extends JPopupMenu
    implements ActionListener,
    ChangeListener {
        private RecentSearches recentSearches;
        private JTextField searchField;
        private JMenuItem clear;

        public RecentSearchesPopup(RecentSearches recentSearches, JTextField searchField) {
            this.searchField = searchField;
            this.recentSearches = recentSearches;
            recentSearches.addChangeListener(this);
            this.buildMenu();
        }

        private void buildMenu() {
            this.setVisible(false);
            this.removeAll();
            if (this.recentSearches.getLength() == 0) {
                JMenuItem noRecent = new JMenuItem(UIManagerExt.getString((Object)"SearchField.noRecentsText"));
                noRecent.setEnabled(false);
                this.add(noRecent);
            } else {
                JMenuItem recent = new JMenuItem(UIManagerExt.getString((Object)"SearchField.recentsMenuTitle"));
                recent.setEnabled(false);
                this.add(recent);
                for (String searchString : this.recentSearches.getRecentSearches()) {
                    JMenuItem mi = new JMenuItem(searchString);
                    mi.addActionListener(this);
                    this.add(mi);
                }
                this.addSeparator();
                this.clear = new JMenuItem(UIManagerExt.getString((Object)"SearchField.clearRecentsText"));
                this.clear.addActionListener(this);
                this.add(this.clear);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.clear) {
                this.recentSearches.removeAll();
            } else {
                this.searchField.setText(e.getActionCommand());
                this.searchField.postActionEvent();
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.buildMenu();
        }
    }
}

