/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.html.HTMLEditorKit;
import language_engine.TranslationEngineType;
import module.SupportedLanguages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiSelectDialog
extends DialogWrapper {
    public static final double GOLDEN_RATIO = 0.618;
    public static final double REVERSE_GOLDEN_RATIO = 0.382;
    private PropertiesComponent propertiesComponent;
    protected String myMessage;
    private MyBorderLayout myLayout;
    private JCheckBox myCheckBox;
    private String myCheckboxText;
    private boolean myChecked;
    private List<SupportedLanguages> data;
    private List<SupportedLanguages> selectedLanguages = new ArrayList<SupportedLanguages>();
    private OnOKClickedListener onOKClickedListener;

    public void setOnOKClickedListener(OnOKClickedListener onOKClickedListener) {
        this.onOKClickedListener = onOKClickedListener;
    }

    public MultiSelectDialog(@Nullable Project project, String message, String title, @Nullable String checkboxText, boolean checkboxStatus, TranslationEngineType translationEngineType, boolean canBeParent) {
        super(project, canBeParent);
        this.data = SupportedLanguages.getAllSupportedLanguages(translationEngineType);
        this._init(project, title, message, checkboxText, checkboxStatus, null);
    }

    protected void _init(Project project, String title, String message, @Nullable String checkboxText, boolean checkboxStatus, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        this.setTitle(title);
        if (Messages.isMacSheetEmulation()) {
            this.setUndecorated(true);
        }
        this.propertiesComponent = PropertiesComponent.getInstance((Project)project);
        this.myMessage = message;
        this.myCheckboxText = checkboxText;
        this.myChecked = checkboxStatus;
        this.setButtonsAlignment(4);
        this.setDoNotAskOption(doNotAskOption);
        this.init();
        if (Messages.isMacSheetEmulation()) {
            MacUtil.adjustFocusTraversal((Disposable)this.myDisposable);
        }
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.onOKClickedListener != null) {
            this.onOKClickedListener.onClick(this.selectedLanguages, this.myCheckBox.isSelected());
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actions = SystemInfo.isMac ? new Action[]{this.myCancelAction, this.myOKAction} : new Action[]{this.myOKAction, this.myCancelAction};
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ui/MultiSelectDialog", "createActions"));
        }
        return actions;
    }

    public void doCancelAction() {
        this.close(-1);
    }

    protected JComponent createCenterPanel() {
        return this.doCreateCenterPanel();
    }

    @NotNull
    LayoutManager createRootLayout() {
        BorderLayout borderLayout;
        if (Messages.isMacSheetEmulation()) {
            this.myLayout = new MyBorderLayout();
            borderLayout = this.myLayout;
        } else {
            borderLayout = new BorderLayout();
        }
        if (borderLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ui/MultiSelectDialog", "createRootLayout"));
        }
        return borderLayout;
    }

    protected void dispose() {
        if (Messages.isMacSheetEmulation()) {
            this.animate();
        } else {
            super.dispose();
        }
    }

    public void show() {
        if (Messages.isMacSheetEmulation()) {
            this.setInitialLocationCallback((Computable)new Computable<Point>(){

                public Point compute() {
                    JRootPane rootPane = SwingUtilities.getRootPane(MultiSelectDialog.this.getWindow().getParent());
                    if (rootPane == null) {
                        rootPane = SwingUtilities.getRootPane(MultiSelectDialog.this.getWindow().getOwner());
                    }
                    Point p = rootPane.getLocationOnScreen();
                    p.x += (rootPane.getWidth() - MultiSelectDialog.this.getWindow().getWidth()) / 2;
                    return p;
                }
            });
            this.animate();
            if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                try {
                    Method method = Class.forName("java.awt.Window").getDeclaredMethod("setOpacity", Float.TYPE);
                    if (method != null) {
                        method.invoke((Object)this.getPeer().getWindow(), Float.valueOf(0.8f));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setAutoAdjustable(false);
            this.setSize(this.getPreferredSize().width, 0);
        }
        super.show();
    }

    private void animate() {
        final int height = this.getPreferredSize().height;
        int frameCount = 10;
        final boolean toClose = this.isShowing();
        final AtomicInteger i = new AtomicInteger(-1);
        final Alarm animator = new Alarm(this.myDisposable);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int state = i.addAndGet(1);
                double linearProgress = (double)state / 10.0;
                if (toClose) {
                    linearProgress = 1.0 - linearProgress;
                }
                MultiSelectDialog.this.myLayout.myPhase = (1.0 - Math.cos(Math.PI * linearProgress)) / 2.0;
                Window window = MultiSelectDialog.this.getPeer().getWindow();
                Rectangle bounds = window.getBounds();
                bounds.height = (int)((double)height * MultiSelectDialog.this.myLayout.myPhase);
                window.setBounds(bounds);
                if (state == 0 && !toClose && window.getOwner() instanceof IdeFrame) {
                    WindowManager.getInstance().requestUserAttention((IdeFrame)window.getOwner(), true);
                }
                if (state < 10) {
                    animator.addRequest((Runnable)this, 10);
                } else if (toClose) {
                    MultiSelectDialog.super.dispose();
                }
            }
        };
        animator.addRequest(runnable, 10, ModalityState.stateForComponent((Component)this.getRootPane()));
    }

    protected JComponent doCreateCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(15, 0));
        if (this.myMessage != null) {
            JTextPane messageComponent = MultiSelectDialog.createMessageComponent(this.myMessage);
            Dimension screenSize = messageComponent.getToolkit().getScreenSize();
            Dimension textSize = messageComponent.getPreferredSize();
            if (this.myMessage.length() > 100) {
                JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)messageComponent);
                pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                pane.setVerticalScrollBarPolicy(20);
                pane.setHorizontalScrollBarPolicy(30);
                int scrollSize = (int)new JScrollBar(1).getPreferredSize().getWidth() + 12;
                Dimension preferredSize = new Dimension(Math.min(textSize.width, (int)((double)screenSize.width * 0.382)) + scrollSize, Math.min(textSize.height, screenSize.height / 3) + scrollSize);
                pane.setPreferredSize(preferredSize);
                panel.add((Component)pane, "North");
            } else {
                panel.add((Component)messageComponent, "North");
            }
        }
        if (!this.data.isEmpty()) {
            Container container = new Container();
            int gridCol = 2;
            int gridRow = this.data.size() % gridCol == 0 ? this.data.size() / gridCol : this.data.size() / gridCol + 1;
            container.setLayout(new GridLayout(gridRow, gridCol));
            for (final SupportedLanguages language : this.data) {
                JCheckBox checkbox = new JCheckBox(language.getLanguageEnglishDisplayName() + " (" + language.getLanguageDisplayName() + ") ");
                checkbox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            if (!MultiSelectDialog.this.selectedLanguages.contains((Object)language)) {
                                MultiSelectDialog.this.selectedLanguages.add(language);
                            }
                        } else if (e.getStateChange() == 2 && MultiSelectDialog.this.selectedLanguages.contains((Object)language)) {
                            MultiSelectDialog.this.selectedLanguages.remove((Object)language);
                        }
                    }
                });
                checkbox.setSelected(this.propertiesComponent.getBoolean("AL_SupportedLanguageCheckStatus_" + language.getLanguageCode(), false));
                container.add(checkbox);
            }
            panel.add((Component)container, "Center");
        }
        if (this.myCheckboxText != null) {
            this.myCheckBox = new JCheckBox(this.myCheckboxText);
            this.myCheckBox.setSelected(this.myChecked);
            this.myCheckBox.setMargin(new Insets(2, -4, 0, 0));
            panel.add((Component)this.myCheckBox, "South");
        }
        return panel;
    }

    protected static JTextPane createMessageComponent(String message) {
        JTextPane messageComponent = new JTextPane();
        return MultiSelectDialog.configureMessagePaneUi(messageComponent, message);
    }

    protected void doHelpAction() {
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(JTextPane messageComponent, String message) {
        JTextPane jTextPane = MultiSelectDialog.configureMessagePaneUi(messageComponent, message, true);
        if (jTextPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ui/MultiSelectDialog", "configureMessagePaneUi"));
        }
        return jTextPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(JTextPane messageComponent, String message, boolean addBrowserHyperlinkListener) {
        messageComponent.setFont(UIUtil.getLabelFont());
        if (BasicHTML.isHTMLString(message)) {
            HTMLEditorKit editorKit = new HTMLEditorKit();
            editorKit.getStyleSheet().addRule(UIUtil.displayPropertiesToCSS((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground()));
            messageComponent.setEditorKit(editorKit);
            messageComponent.setContentType("text/html");
            if (addBrowserHyperlinkListener) {
                messageComponent.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            }
        }
        messageComponent.setText(message);
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            messageComponent.setOpaque(false);
            messageComponent.setBackground(UIUtil.TRANSPARENT_COLOR);
        } else {
            messageComponent.setBackground(UIUtil.getOptionPaneBackground());
        }
        messageComponent.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent;
        if (jTextPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ui/MultiSelectDialog", "configureMessagePaneUi"));
        }
        return jTextPane;
    }

    private static class MyBorderLayout
    extends BorderLayout {
        private double myPhase = 0.0;

        private MyBorderLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Dimension realSize = target.getSize();
            target.setSize(target.getPreferredSize());
            super.layoutContainer(target);
            target.setSize(realSize);
            Object object = target.getTreeLock();
            synchronized (object) {
                Component[] components;
                int yShift = (int)((1.0 - this.myPhase) * (double)target.getPreferredSize().height);
                for (Component component : components = target.getComponents()) {
                    Point point = component.getLocation();
                    point.y -= yShift;
                    component.setLocation(point);
                }
            }
        }
    }

    public static interface OnOKClickedListener {
        public void onClick(List<SupportedLanguages> var1, boolean var2);
    }
}

