/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.MultiSelectDialog;

public class GoogleAlertDialog
extends DialogWrapper {
    private String mMessage;
    private Action detailAction = new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)"Pricing details")){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Desktop.getDesktop().browse(new URI("https://cloud.google.com/translate/v2/pricing"));
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            GoogleAlertDialog.this.close(5, true);
        }
    };
    private Action neverShowAction = new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)"Never show this again")){

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertiesComponent.getInstance().setValue("GoogleAlertMsgShownSetting", String.valueOf(true));
            GoogleAlertDialog.this.close(6, true);
        }
    };

    public GoogleAlertDialog(@Nullable Component parent, boolean canBeParent) {
        super(parent, canBeParent);
        this._init("Information", "Google Translate API is a paid service. The pricing is based on usage. Translation usage is calculated in millions of characters (M), where 1 M = 106 characters");
    }

    protected void _init(String title, String message) {
        this.setTitle(title);
        this.mMessage = message;
        if (Messages.isMacSheetEmulation()) {
            this.setUndecorated(true);
        }
        this.setButtonsAlignment(4);
        this.setDoNotAskOption(null);
        this.init();
        if (Messages.isMacSheetEmulation()) {
            MacUtil.adjustFocusTraversal((Disposable)this.myDisposable);
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actions = SystemInfo.isMac ? new Action[]{this.myCancelAction, this.neverShowAction, this.detailAction, this.myOKAction} : new Action[]{this.myOKAction, this.detailAction, this.neverShowAction, this.myCancelAction};
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ui/GoogleAlertDialog", "createActions"));
        }
        return actions;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(15, 0));
        JLabel iconLabel = new JLabel(Messages.getInformationIcon());
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)iconLabel, "North");
        panel.add((Component)container, "West");
        if (this.mMessage != null) {
            JTextPane messageComponent = MultiSelectDialog.createMessageComponent(this.mMessage);
            Dimension screenSize = messageComponent.getToolkit().getScreenSize();
            Dimension textSize = messageComponent.getPreferredSize();
            if (this.mMessage.length() > 100) {
                JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)messageComponent);
                pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                pane.setVerticalScrollBarPolicy(20);
                pane.setHorizontalScrollBarPolicy(30);
                int scrollSize = (int)new JScrollBar(1).getPreferredSize().getWidth();
                Dimension preferredSize = new Dimension(Math.min(textSize.width, screenSize.width / 2) + scrollSize, Math.min(textSize.height, screenSize.height / 3) + scrollSize);
                pane.setPreferredSize(preferredSize);
                panel.add((Component)pane, "Center");
            } else {
                panel.add((Component)messageComponent, "Center");
            }
        }
        return panel;
    }
}

