/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import module.FilterRule;
import org.jdesktop.swingx.prompt.PromptSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFilterRuleDialog
extends DialogWrapper {
    private MyBorderLayout myLayout;
    private ComboBox ruleType;
    private JTextField filterName;
    private OnOKClickedListener onOKClickedListener;

    public void setOnOKClickedListener(OnOKClickedListener onOKClickedListener) {
        this.onOKClickedListener = onOKClickedListener;
    }

    public AddFilterRuleDialog(@Nullable Component parent, String title, boolean canBeParent) {
        super(parent, canBeParent);
        this._init(title, null);
    }

    protected void _init(String title, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        this.setTitle(title);
        if (Messages.isMacSheetEmulation()) {
            this.setUndecorated(true);
        }
        this.setButtonsAlignment(4);
        this.setDoNotAskOption(doNotAskOption);
        this.init();
        if (Messages.isMacSheetEmulation()) {
            MacUtil.adjustFocusTraversal((Disposable)this.myDisposable);
        }
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.onOKClickedListener != null && this.ruleType != null && this.filterName != null) {
            this.onOKClickedListener.onClick((FilterRule.FilterRuleType)((Object)this.ruleType.getSelectedItem()), this.filterName.getText());
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actions = SystemInfo.isMac ? new Action[]{this.myCancelAction, this.myOKAction} : new Action[]{this.myOKAction, this.myCancelAction};
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ui/AddFilterRuleDialog", "createActions"));
        }
        return actions;
    }

    public void doCancelAction() {
        this.close(-1);
    }

    protected JComponent createCenterPanel() {
        return this.doCreateCenterPanel();
    }

    @NotNull
    LayoutManager createRootLayout() {
        BorderLayout borderLayout;
        if (Messages.isMacSheetEmulation()) {
            this.myLayout = new MyBorderLayout();
            borderLayout = this.myLayout;
        } else {
            borderLayout = new BorderLayout();
        }
        if (borderLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ui/AddFilterRuleDialog", "createRootLayout"));
        }
        return borderLayout;
    }

    protected void dispose() {
        if (Messages.isMacSheetEmulation()) {
            this.animate();
        } else {
            super.dispose();
        }
    }

    public void show() {
        if (Messages.isMacSheetEmulation()) {
            this.setInitialLocationCallback((Computable)new Computable<Point>(){

                public Point compute() {
                    JRootPane rootPane = SwingUtilities.getRootPane(AddFilterRuleDialog.this.getWindow().getParent());
                    if (rootPane == null) {
                        rootPane = SwingUtilities.getRootPane(AddFilterRuleDialog.this.getWindow().getOwner());
                    }
                    Point p = rootPane.getLocationOnScreen();
                    p.x += (rootPane.getWidth() - AddFilterRuleDialog.this.getWindow().getWidth()) / 2;
                    return p;
                }
            });
            this.animate();
            if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                try {
                    Method method = Class.forName("java.awt.Window").getDeclaredMethod("setOpacity", Float.TYPE);
                    if (method != null) {
                        method.invoke((Object)this.getPeer().getWindow(), Float.valueOf(0.8f));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setAutoAdjustable(false);
            this.setSize(this.getPreferredSize().width, 0);
        }
        super.show();
    }

    private void animate() {
        final int height = this.getPreferredSize().height;
        int frameCount = 10;
        final boolean toClose = this.isShowing();
        final AtomicInteger i = new AtomicInteger(-1);
        final Alarm animator = new Alarm(this.myDisposable);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int state = i.addAndGet(1);
                double linearProgress = (double)state / 10.0;
                if (toClose) {
                    linearProgress = 1.0 - linearProgress;
                }
                AddFilterRuleDialog.this.myLayout.myPhase = (1.0 - Math.cos(Math.PI * linearProgress)) / 2.0;
                Window window = AddFilterRuleDialog.this.getPeer().getWindow();
                Rectangle bounds = window.getBounds();
                bounds.height = (int)((double)height * AddFilterRuleDialog.this.myLayout.myPhase);
                window.setBounds(bounds);
                if (state == 0 && !toClose && window.getOwner() instanceof IdeFrame) {
                    WindowManager.getInstance().requestUserAttention((IdeFrame)window.getOwner(), true);
                }
                if (state < 10) {
                    animator.addRequest((Runnable)this, 10);
                } else if (toClose) {
                    AddFilterRuleDialog.super.dispose();
                }
            }
        };
        animator.addRequest(runnable, 10, ModalityState.stateForComponent((Component)this.getRootPane()));
    }

    protected JComponent doCreateCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        FilterRule.FilterRuleType[] types = FilterRule.FilterRuleType.values();
        this.ruleType = new ComboBox((Object[])types);
        this.ruleType.setEnabled(true);
        this.ruleType.setSelectedIndex(0);
        panel.add((Component)this.ruleType, "West");
        this.filterName = new JTextField(20);
        PromptSupport.setPrompt((String)"Set the string name here", (JTextComponent)this.filterName);
        panel.add((Component)this.filterName, "Center");
        return panel;
    }

    protected void doHelpAction() {
    }

    private static class MyBorderLayout
    extends BorderLayout {
        private double myPhase = 0.0;

        private MyBorderLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Dimension realSize = target.getSize();
            target.setSize(target.getPreferredSize());
            super.layoutContainer(target);
            target.setSize(realSize);
            Object object = target.getTreeLock();
            synchronized (object) {
                Component[] components;
                int yShift = (int)((1.0 - this.myPhase) * (double)target.getPreferredSize().height);
                for (Component component : components = target.getComponents()) {
                    Point point = component.getLocation();
                    point.y -= yShift;
                    component.setLocation(point);
                }
            }
        }
    }

    public static interface OnOKClickedListener {
        public void onClick(FilterRule.FilterRuleType var1, String var2);
    }
}

