/*
 * Decompiled with CFR 0.152.
 */
package settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import data.Log;
import data.SerializeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import language_engine.TranslationEngineType;
import module.FilterRule;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.prompt.PromptSupport;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import ui.AddFilterRuleDialog;
import ui.GoogleAlertDialog;

public class SettingConfigurable
implements Configurable,
ActionListener {
    private static final String DEFAULT_CLIENT_ID = "Default client id";
    private static final String DEFAULT_CLIENT_SECRET = "Default client secret";
    private static final String DEFAULT_GOOGLE_API_KEY = "Enter API key here";
    private static final String BING_HOW_TO = "<html><a href=\"http://blogs.msdn.com/b/translation/p/gettingstarted1.aspx\">How to get ClientId and ClientSecret?</a></html>";
    private MouseAdapter bingHowTo = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                Desktop.getDesktop().browse(new URI("http://blogs.msdn.com/b/translation/p/gettingstarted1.aspx"));
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    };
    private static final String GOOGLE_HOW_TO = "<html><a href=\"https://cloud.google.com/translate/v2/getting_started#intro\">How to set up Google Translation API key?</a></html>";
    private MouseAdapter googleHowTo = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                Desktop.getDesktop().browse(new URI("https://cloud.google.com/translate/v2/getting_started#intro"));
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    };
    private JPanel settingPanel;
    private JComboBox languageEngineBox;
    private TranslationEngineType currentEngine;
    private JLabel howToLabel;
    private JLabel line1Text;
    private JTextField line1TextField;
    private JLabel line2Text;
    private JTextField line2TextField;
    private JBList filterList;
    private JButton btnAddFilter;
    private JButton btnDeleteFilter;
    private List<FilterRule> filterRules = new ArrayList<FilterRule>();
    private boolean languageEngineChanged = false;
    private boolean filterRulesChanged = false;

    @Nls
    public String getDisplayName() {
        return "Android Localizationer";
    }

    @Nullable
    public String getHelpTopic() {
        return this.getDisplayName();
    }

    @Nullable
    public JComponent createComponent() {
        if (this.settingPanel == null) {
            this.settingPanel = new JPanel((LayoutManager)new VerticalLayout(18));
            Container container = new Container();
            container.setLayout(new BorderLayout());
            this.currentEngine = TranslationEngineType.fromName(PropertiesComponent.getInstance().getValue("SettingLanguageEngine"));
            TranslationEngineType[] items = TranslationEngineType.getLanguageEngineArray();
            this.languageEngineBox = new ComboBox((Object[])items);
            this.languageEngineBox.setEnabled(true);
            this.languageEngineBox.setSelectedItem((Object)this.currentEngine);
            this.languageEngineBox.addActionListener(this);
            container.add((Component)new JLabel("Language engine: "), "West");
            container.add((Component)this.languageEngineBox, "Center");
            this.settingPanel.add(container);
            this.initContentContainer();
            this.initAndAddFilterContainer();
        }
        return this.settingPanel;
    }

    public boolean isModified() {
        if (this.languageEngineChanged) {
            return true;
        }
        if (this.filterRulesChanged) {
            return true;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        switch (this.currentEngine) {
            case Bing: {
                String bingClientIdStored = propertiesComponent.getValue("BingClientIdStored");
                String bingClientSecretStored = propertiesComponent.getValue("BingClientSecretStored");
                boolean bingClientIdChanged = false;
                boolean bingClientSecretChanged = false;
                if (bingClientIdStored == null) {
                    if (!this.line1TextField.getText().isEmpty()) {
                        bingClientIdChanged = true;
                    }
                } else if (!this.line1TextField.getText().equals(bingClientIdStored) && !this.line1TextField.getText().trim().isEmpty()) {
                    bingClientIdChanged = true;
                }
                if (bingClientSecretStored == null) {
                    if (!this.line2TextField.getText().isEmpty()) {
                        bingClientSecretChanged = true;
                    }
                } else if (!this.line2TextField.getText().equals(bingClientSecretStored) && !this.line2TextField.getText().trim().isEmpty()) {
                    bingClientSecretChanged = true;
                }
                return bingClientIdChanged || bingClientSecretChanged;
            }
            case Google: {
                String googleApiKeyStored = propertiesComponent.getValue("GoogleAPIKeyStored");
                boolean googleApiKeyStoredChanged = false;
                if (googleApiKeyStored == null) {
                    if (!this.line1TextField.getText().isEmpty()) {
                        googleApiKeyStoredChanged = true;
                    }
                } else if (!this.line1TextField.getText().equals(googleApiKeyStored) && !this.line1TextField.getText().trim().isEmpty()) {
                    googleApiKeyStoredChanged = true;
                }
                return googleApiKeyStoredChanged;
            }
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        Log.i("apply clicked");
        if (this.languageEngineBox == null || this.filterList == null || this.btnAddFilter == null || this.btnDeleteFilter == null || this.line1TextField == null || this.line2TextField == null) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        this.languageEngineChanged = false;
        propertiesComponent.setValue("SettingLanguageEngine", this.currentEngine.toName());
        switch (this.currentEngine) {
            case Bing: {
                if (!this.line1TextField.getText().trim().isEmpty()) {
                    propertiesComponent.setValue("BingClientIdStored", this.line1TextField.getText());
                    PromptSupport.setPrompt((String)this.line1TextField.getText(), (JTextComponent)this.line1TextField);
                }
                if (!this.line2TextField.getText().trim().isEmpty()) {
                    propertiesComponent.setValue("BingClientSecretStored", this.line2TextField.getText());
                    PromptSupport.setPrompt((String)this.line2TextField.getText(), (JTextComponent)this.line2TextField);
                }
                this.line1TextField.setText("");
                this.line2TextField.setText("");
                break;
            }
            case Google: {
                if (!this.line1TextField.getText().trim().isEmpty()) {
                    propertiesComponent.setValue("GoogleAPIKeyStored", this.line1TextField.getText());
                    PromptSupport.setPrompt((String)this.line1TextField.getText(), (JTextComponent)this.line1TextField);
                }
                this.line1TextField.setText("");
            }
        }
        this.languageEngineBox.requestFocus();
        this.filterRulesChanged = false;
        propertiesComponent.setValue("SettingFilterRules", SerializeUtil.serializeFilterRuleList(this.filterRules));
    }

    public void reset() {
        if (this.settingPanel == null || this.languageEngineBox == null || this.filterList == null || this.btnAddFilter == null || this.btnDeleteFilter == null) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        this.currentEngine = TranslationEngineType.fromName(propertiesComponent.getValue("SettingLanguageEngine"));
        this.languageEngineBox.setSelectedItem((Object)this.currentEngine);
        this.languageEngineChanged = false;
        this.initUI(this.currentEngine);
        Log.i("reset, current engine: " + (Object)((Object)this.currentEngine));
        this.languageEngineBox.requestFocus();
        this.filterRulesChanged = false;
        this.resetFilterList();
    }

    public void disposeUIResources() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        TranslationEngineType type = (TranslationEngineType)((Object)comboBox.getSelectedItem());
        if (type == this.currentEngine && !this.languageEngineChanged) {
            return;
        }
        this.languageEngineChanged = true;
        Log.i("selected type: " + type.name());
        this.currentEngine = type;
        this.initUI(this.currentEngine);
        boolean GoogleAlertMsgShownSetting = PropertiesComponent.getInstance().getBoolean("GoogleAlertMsgShownSetting", false);
        if (this.currentEngine == TranslationEngineType.Google && !GoogleAlertMsgShownSetting) {
            new GoogleAlertDialog(this.settingPanel, false).show();
        }
    }

    private void initUI(TranslationEngineType engineType) {
        if (this.settingPanel == null) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        switch (engineType) {
            case Bing: {
                this.line1Text.setText("Client Id:");
                this.line2Text.setText("Client secret:");
                this.line2Text.setVisible(true);
                this.line2TextField.setVisible(true);
                this.howToLabel.setText(BING_HOW_TO);
                this.howToLabel.removeMouseMotionListener(this.googleHowTo);
                this.howToLabel.addMouseListener(this.bingHowTo);
                String bingClientIdStored = propertiesComponent.getValue("BingClientIdStored");
                String bingClientSecretStored = propertiesComponent.getValue("BingClientSecretStored");
                if (bingClientIdStored != null) {
                    PromptSupport.setPrompt((String)bingClientIdStored, (JTextComponent)this.line1TextField);
                } else {
                    PromptSupport.setPrompt((String)DEFAULT_CLIENT_ID, (JTextComponent)this.line1TextField);
                }
                this.line1TextField.setText("");
                if (bingClientSecretStored != null) {
                    PromptSupport.setPrompt((String)bingClientSecretStored, (JTextComponent)this.line2TextField);
                } else {
                    PromptSupport.setPrompt((String)DEFAULT_CLIENT_SECRET, (JTextComponent)this.line2TextField);
                }
                this.line2TextField.setText("");
                break;
            }
            case Google: {
                this.line1Text.setText("API key:");
                this.line2Text.setVisible(false);
                this.line2TextField.setVisible(false);
                this.howToLabel.setText(GOOGLE_HOW_TO);
                this.howToLabel.removeMouseListener(this.bingHowTo);
                this.howToLabel.addMouseListener(this.googleHowTo);
                String googleAPIKey = propertiesComponent.getValue("GoogleAPIKeyStored");
                if (googleAPIKey != null) {
                    PromptSupport.setPrompt((String)googleAPIKey, (JTextComponent)this.line1TextField);
                } else {
                    PromptSupport.setPrompt((String)DEFAULT_GOOGLE_API_KEY, (JTextComponent)this.line1TextField);
                }
                this.line1TextField.setText("");
            }
        }
    }

    private void initContentContainer() {
        this.line1TextField = new JTextField();
        this.line2TextField = new JTextField();
        this.line1Text = new JLabel("Client Id:");
        this.line2Text = new JLabel("Client Secret:");
        Container outContainer = new Container();
        outContainer.setLayout(new BorderLayout(0, 5));
        this.howToLabel = new JLabel();
        this.howToLabel.setCursor(new Cursor(12));
        outContainer.add((Component)this.howToLabel, "North");
        Container contentContainer = new Container();
        contentContainer.setLayout(new GridBagLayout());
        ((GridBagLayout)contentContainer.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)contentContainer.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)contentContainer.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)contentContainer.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0E-4};
        this.line1Text.setHorizontalAlignment(4);
        contentContainer.add((Component)this.line1Text, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        contentContainer.add((Component)this.line1TextField, new GridBagConstraints(1, 0, 1, 1, 10.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.line2Text.setHorizontalAlignment(4);
        contentContainer.add((Component)this.line2Text, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        contentContainer.add((Component)this.line2TextField, new GridBagConstraints(1, 1, 1, 1, 10.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        outContainer.add((Component)contentContainer, "Center");
        this.settingPanel.add(outContainer);
    }

    private void initAndAddFilterContainer() {
        Container filterSettingContainer = new Container();
        filterSettingContainer.setLayout(new BorderLayout(0, 5));
        JLabel filterLabel = new JLabel("Filter setting");
        filterSettingContainer.add((Component)filterLabel, "North");
        Container listPane = new Container();
        listPane.setLayout(new BorderLayout());
        JBScrollPane scrollPane = new JBScrollPane();
        this.filterList = new JBList((Object[])new String[]{"1,", "2"});
        this.filterList.setSelectionMode(1);
        scrollPane.setViewportView((Component)this.filterList);
        listPane.add((Component)scrollPane, "North");
        Container btnPane = new Container();
        btnPane.setLayout(new FlowLayout(0, 0, 0));
        this.btnAddFilter = new JButton("+");
        this.btnDeleteFilter = new JButton("-");
        btnPane.add(this.btnAddFilter);
        btnPane.add(this.btnDeleteFilter);
        this.filterList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (SettingConfigurable.this.filterList.getSelectedIndex() <= 0) {
                        SettingConfigurable.this.btnDeleteFilter.setEnabled(false);
                    } else {
                        SettingConfigurable.this.btnDeleteFilter.setEnabled(true);
                    }
                }
            }
        });
        this.btnAddFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingConfigurable.this.filterRulesChanged = true;
                AddFilterRuleDialog dialog = new AddFilterRuleDialog(SettingConfigurable.this.settingPanel, "Set your filter rule", false);
                dialog.setOnOKClickedListener(new AddFilterRuleDialog.OnOKClickedListener(){

                    @Override
                    public void onClick(FilterRule.FilterRuleType ruleType, String filterNameString) {
                        SettingConfigurable.this.filterRules.add(new FilterRule(ruleType, filterNameString));
                        int index = SettingConfigurable.this.filterList.getSelectedIndex();
                        SettingConfigurable.this.filterList.setListData((Object[])SettingConfigurable.this.getFilterRulesDisplayString());
                        SettingConfigurable.this.filterList.setSelectedIndex(index);
                    }
                });
                dialog.show();
            }
        });
        this.btnDeleteFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingConfigurable.this.filterRulesChanged = true;
                int index = SettingConfigurable.this.filterList.getSelectedIndex();
                SettingConfigurable.this.filterRules.remove(index);
                SettingConfigurable.this.filterList.setListData((Object[])SettingConfigurable.this.getFilterRulesDisplayString());
                if (index < SettingConfigurable.this.filterRules.size()) {
                    SettingConfigurable.this.filterList.setSelectedIndex(index);
                } else {
                    if (SettingConfigurable.this.filterRules.size() == 1) {
                        SettingConfigurable.this.btnDeleteFilter.setEnabled(false);
                    }
                    SettingConfigurable.this.filterList.setSelectedIndex(SettingConfigurable.this.filterRules.size() - 1);
                }
            }
        });
        listPane.add((Component)btnPane, "Center");
        filterSettingContainer.add((Component)listPane, "Center");
        this.settingPanel.add(filterSettingContainer);
    }

    private void resetFilterList() {
        this.btnDeleteFilter.setEnabled(false);
        this.filterRules.clear();
        this.filterRules.addAll(FilterRule.getFilterRulesFromLocal());
        this.filterList.setListData((Object[])this.getFilterRulesDisplayString());
    }

    private String[] getFilterRulesDisplayString() {
        String[] displayStrings = new String[this.filterRules.size()];
        for (int i = 0; i < this.filterRules.size(); ++i) {
            displayStrings[i] = this.filterRules.get(i).toString();
        }
        return displayStrings;
    }
}

