/*
 * Decompiled with CFR 0.152.
 */
package module;

import java.util.ArrayList;
import java.util.List;
import language_engine.TranslationEngineType;

public enum SupportedLanguages {
    Afrikaans("af", "Afrikaans", "Afrikaans"),
    Albanian("sq", "Shqiptar", "Albanian"),
    Arabic("ar", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "Arabic"),
    Azerbaijani("az", "Az\u0259rbaycan", "Azerbaijani"),
    Basque("eu", "Euskal", "Basque"),
    Bengali("bn", "\u09ac\u09be\u0999\u09be\u09b2\u09bf", "Bengali"),
    Belarusian("be", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0456", "Belarusian"),
    Bulgarian("bg", "\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438", "Bulgarian"),
    Catalan("ca", "Catal\u00e0", "Catalan"),
    Chinese_Simplified("zh-CN", "\u7b80\u4f53\u4e2d\u6587", "Chinese Simplified"),
    Chinese_Simplified_BING("zh-CHS", "\u7b80\u4f53\u4e2d\u6587", "Chinese Simplified"),
    Chinese_Traditional("zh-TW", "\u6b63\u9ad4\u4e2d\u6587", "Chinese Traditional"),
    Chinese_Traditional_BING("zh-CHT", "\u6b63\u9ad4\u4e2d\u6587", "Chinese Traditional"),
    Croatian("hr", "Hrvatski", "Croatian"),
    Czech("cs", "\u010ce\u0161tina", "Czech"),
    Danish("da", "Dansk", "Danish"),
    Dutch("nl", "Nederlands", "Dutch"),
    English("en", "English", "English"),
    Esperanto("eo", "Esperanta", "Esperanto"),
    Estonian("et", "Eesti", "Estonian"),
    Filipino("tl", "Pilipino", "Filipino"),
    Finnish("fi", "Suomi", "Finnish"),
    French("fr", "Fran\u00e7ais", "French"),
    Galician("gl", "Galego", "Galician"),
    Georgian("ka", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8", "Georgian"),
    German("de", "Deutsch", "German"),
    Greek("el", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "Greek"),
    Gujarati("gu", "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0", "Gujarati"),
    Haitian_Creole("ht", "Haitiancreole", "Haitian Creole"),
    Hebrew("iw", "\u05e2\u05d1\u05e8\u05d9\u05ea", "Hebrew"),
    Hebrew_BING("he", "\u05e2\u05d1\u05e8\u05d9\u05ea", "Hebrew"),
    Hindi("hi", "\u0939\u093f\u0902\u0926\u0940", "Hindi"),
    Hungarian("hu", "Magyar", "Hungarian"),
    Icelandic("is", "Icelandic", "Icelandic"),
    Indonesian("id", "Indonesia", "Indonesian"),
    Irish("ga", "Irish", "Irish"),
    Italian("it", "Italiano", "Italian"),
    Japanese("ja", "\u65e5\u672c\u8a9e", "Japanese"),
    Kannada("kn", "\u0c95\u0ca8\u0ccd\u0ca8\u0ca1", "Kannada"),
    Korean("ko", "\ud55c\uad6d\uc758", "Korean"),
    Latin("la", "Latina", "Latin"),
    Latvian("lv", "Latvijas", "Latvian"),
    Lithuanian("lt", "Lietuvos", "Lithuanian"),
    Macedonian("mk", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438", "Macedonian"),
    Malay("ms", "Melayu", "Malay"),
    Maltese("mt", "Malti", "Maltese"),
    Norwegian("no", "Norsk", "Norwegian"),
    Persian("fa", "\u0641\u0627\u0631\u0633\u06cc", "Persian"),
    Polish("pl", "Polski", "Polish"),
    Portuguese("pt", "Portugu\u00eas", "Portuguese"),
    Romanian("ro", "Rom\u00e2n", "Romanian"),
    Russian("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "Russian"),
    Serbian("sr", "\u0421\u0440\u043f\u0441\u043a\u0438", "Serbian"),
    Slovak("sk", "Sloven\u010dina", "Slovak"),
    Slovenian("sl", "Sloven\u0161\u010dina", "Slovenian"),
    Spanish("es", "Espa\u00f1ol", "Spanish"),
    Swahili("sw", "Kiswahili", "Swahili"),
    Swedish("sv", "Svenska", "Swedish"),
    Tamil("ta", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd", "Tamil"),
    Telugu("te", "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41", "Telugu"),
    Thai("th", "\u0e44\u0e17\u0e22", "Thai"),
    Turkish("tr", "T\u00fcrk", "Turkish"),
    Ukrainian("uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0439", "Ukrainian"),
    Urdu("ur", "\u0627\u0631\u062f\u0648", "Urdu"),
    Vietnamese("vi", "Ti\u1ebfng Vi\u1ec7t", "Vietnamese"),
    Welsh("cy", "Cymraeg", "Welsh"),
    Yiddish("yi", "\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9", "Yiddish");

    private String languageCode;
    private String languageDisplayName;
    private String languageEnglishDisplayName;

    private SupportedLanguages(String languageCode, String languageDisplayName, String languageEnglishDisplayName) {
        this.languageCode = languageCode;
        this.languageDisplayName = languageDisplayName;
        this.languageEnglishDisplayName = languageEnglishDisplayName;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getLanguageDisplayName() {
        return this.languageDisplayName;
    }

    public String getLanguageEnglishDisplayName() {
        return this.languageEnglishDisplayName;
    }

    public static List<SupportedLanguages> getAllSupportedLanguages(TranslationEngineType type) {
        switch (type) {
            case Bing: {
                return SupportedLanguages.getBingLanguages();
            }
            case Google: {
                return SupportedLanguages.getGoogleLanguages();
            }
        }
        return null;
    }

    public String toString() {
        return this.getLanguageEnglishDisplayName() + "(\"" + this.getLanguageCode() + "\", \"" + this.getLanguageDisplayName() + "\")";
    }

    public String getAndroidStringFolderNameSuffix() {
        if (this == Chinese_Simplified_BING || this == Chinese_Simplified) {
            return "zh-rCN";
        }
        if (this == Chinese_Traditional_BING || this == Chinese_Traditional) {
            return "zh-rTW";
        }
        if (this == Hebrew_BING) {
            return Hebrew.getLanguageCode();
        }
        return this.getLanguageCode();
    }

    private static List<SupportedLanguages> getGoogleLanguages() {
        ArrayList<SupportedLanguages> result = new ArrayList<SupportedLanguages>();
        result.add(Afrikaans);
        result.add(Albanian);
        result.add(Arabic);
        result.add(Azerbaijani);
        result.add(Basque);
        result.add(Bengali);
        result.add(Belarusian);
        result.add(Bulgarian);
        result.add(Catalan);
        result.add(Chinese_Simplified);
        result.add(Chinese_Traditional);
        result.add(Croatian);
        result.add(Czech);
        result.add(Danish);
        result.add(Dutch);
        result.add(English);
        result.add(Esperanto);
        result.add(Estonian);
        result.add(Filipino);
        result.add(Finnish);
        result.add(French);
        result.add(Galician);
        result.add(Georgian);
        result.add(German);
        result.add(Greek);
        result.add(Gujarati);
        result.add(Haitian_Creole);
        result.add(Hebrew);
        result.add(Hindi);
        result.add(Hungarian);
        result.add(Icelandic);
        result.add(Indonesian);
        result.add(Irish);
        result.add(Italian);
        result.add(Japanese);
        result.add(Kannada);
        result.add(Korean);
        result.add(Latin);
        result.add(Latvian);
        result.add(Macedonian);
        result.add(Malay);
        result.add(Maltese);
        result.add(Norwegian);
        result.add(Persian);
        result.add(Polish);
        result.add(Portuguese);
        result.add(Romanian);
        result.add(Russian);
        result.add(Serbian);
        result.add(Slovak);
        result.add(Slovenian);
        result.add(Spanish);
        result.add(Swahili);
        result.add(Swedish);
        result.add(Tamil);
        result.add(Telugu);
        result.add(Thai);
        result.add(Turkish);
        result.add(Ukrainian);
        result.add(Urdu);
        result.add(Vietnamese);
        result.add(Welsh);
        result.add(Yiddish);
        return result;
    }

    private static List<SupportedLanguages> getBingLanguages() {
        ArrayList<SupportedLanguages> result = new ArrayList<SupportedLanguages>();
        result.add(Arabic);
        result.add(Bulgarian);
        result.add(Catalan);
        result.add(Chinese_Simplified_BING);
        result.add(Chinese_Traditional_BING);
        result.add(Czech);
        result.add(Danish);
        result.add(Dutch);
        result.add(English);
        result.add(Estonian);
        result.add(Finnish);
        result.add(French);
        result.add(German);
        result.add(Greek);
        result.add(Haitian_Creole);
        result.add(Hebrew_BING);
        result.add(Hindi);
        result.add(Hungarian);
        result.add(Indonesian);
        result.add(Italian);
        result.add(Japanese);
        result.add(Korean);
        result.add(Latvian);
        result.add(Lithuanian);
        result.add(Malay);
        result.add(Maltese);
        result.add(Norwegian);
        result.add(Persian);
        result.add(Polish);
        result.add(Portuguese);
        result.add(Romanian);
        result.add(Russian);
        result.add(Slovak);
        result.add(Slovenian);
        result.add(Spanish);
        result.add(Swedish);
        result.add(Thai);
        result.add(Turkish);
        result.add(Ukrainian);
        result.add(Urdu);
        result.add(Vietnamese);
        result.add(Welsh);
        return result;
    }
}

