/*
 * Decompiled with CFR 0.152.
 */
package module;

import com.intellij.ide.util.PropertiesComponent;
import data.SerializeUtil;
import java.util.ArrayList;
import java.util.List;

public class FilterRule {
    private FilterRuleType filterRuleType;
    private String filterString;
    public static FilterRule DefaultFilterRule = new FilterRule(FilterRuleType.START_WITH, "NAL_");

    public FilterRule(FilterRuleType filterRuleType, String filterString) {
        this.filterRuleType = filterRuleType;
        this.filterString = filterString;
    }

    public FilterRuleType getFilterRuleType() {
        return this.filterRuleType;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterRuleType(FilterRuleType filterRuleType) {
        this.filterRuleType = filterRuleType;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public String toString() {
        return this.getFilterRuleType().toString() + " <" + this.getFilterString() + ">";
    }

    public static List<FilterRule> getFilterRulesFromLocal() {
        ArrayList<FilterRule> result = new ArrayList<FilterRule>();
        String rules = PropertiesComponent.getInstance().getValue("SettingFilterRules");
        if (rules != null) {
            List<FilterRule> ruleList = SerializeUtil.deserializeFilterRuleList(rules);
            result.addAll(ruleList);
        } else {
            result.add(DefaultFilterRule);
        }
        return result;
    }

    public static boolean inFilterRule(String key, List<FilterRule> rules) {
        for (FilterRule rule : rules) {
            switch (rule.getFilterRuleType()) {
                case START_WITH: {
                    if (!key.startsWith(rule.getFilterString())) break;
                    return true;
                }
                case EQUALS: {
                    if (!key.equals(rule.getFilterString())) break;
                    return true;
                }
                case END_WITH: {
                    if (!key.endsWith(rule.getFilterString())) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static enum FilterRuleType {
        START_WITH("Start with"),
        EQUALS("Equals"),
        END_WITH("End with");

        private String displayName;

        private FilterRuleType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public static FilterRuleType fromName(String name) {
            if (name == null) {
                return START_WITH;
            }
            for (FilterRuleType type : FilterRuleType.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            return START_WITH;
        }

        public String toName() {
            return this.name();
        }
    }
}

