/*
 * Decompiled with CFR 0.152.
 */
package language_engine.google;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.ide.util.PropertiesComponent;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import language_engine.HttpUtils;
import module.SupportedLanguages;
import org.jetbrains.annotations.NotNull;

public class GoogleTranslationApi {
    private static final String BASE_TRANSLATION_URL = "https://www.googleapis.com/language/translate/v2?%s&target=%s&source=%s&key=%s";

    public static List<String> getTranslationJSON(@NotNull List<String> querys, @NotNull SupportedLanguages targetLanguageCode, @NotNull SupportedLanguages sourceLanguageCode) {
        if (querys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "querys", "language_engine/google/GoogleTranslationApi", "getTranslationJSON"));
        }
        if (targetLanguageCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLanguageCode", "language_engine/google/GoogleTranslationApi", "getTranslationJSON"));
        }
        if (sourceLanguageCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceLanguageCode", "language_engine/google/GoogleTranslationApi", "getTranslationJSON"));
        }
        if (querys.isEmpty()) {
            return null;
        }
        String query = "";
        for (int i = 0; i < querys.size(); ++i) {
            query = query + "q=" + URLEncoder.encode(querys.get(i));
            if (i == querys.size() - 1) continue;
            query = query + "&";
        }
        String url = null;
        try {
            url = String.format(BASE_TRANSLATION_URL, query, targetLanguageCode.getLanguageCode(), sourceLanguageCode.getLanguageCode(), PropertiesComponent.getInstance().getValue("GoogleAPIKeyStored"), "");
        }
        catch (IllegalFormatException e) {
            e.printStackTrace();
        }
        if (url == null) {
            return null;
        }
        String getResult = HttpUtils.doHttpGet(url);
        JsonObject jsonObject = new JsonParser().parse(getResult).getAsJsonObject();
        if (jsonObject.get("error") != null) {
            JsonObject error = jsonObject.get("error").getAsJsonObject().get("errors").getAsJsonArray().get(0).getAsJsonObject();
            if (error == null) {
                return null;
            }
            if (error.get("reason").getAsString().equals("dailyLimitExceeded")) {
                return new ArrayList<String>();
            }
            return null;
        }
        JsonObject data = jsonObject.get("data").getAsJsonObject();
        JsonArray translations = data.get("translations").getAsJsonArray();
        if (translations != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < translations.size(); ++i) {
                result.add(translations.get(i).getAsJsonObject().get("translatedText").getAsString());
            }
            return result;
        }
        return null;
    }
}

