/*
 * Decompiled with CFR 0.152.
 */
package language_engine.bing;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.ide.util.PropertiesComponent;
import data.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import language_engine.HttpUtils;
import language_engine.bing.BingResultParser;
import language_engine.bing.TranslateArrayResponse;
import module.SupportedLanguages;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class BingTranslationApi {
    private static final String ENCODING = "UTF-8";
    private static final String AUTH_URL = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13/";
    private static final String TRANSLATE_URL = "http://api.microsofttranslator.com/V2/Ajax.svc/TranslateArray?";
    protected static final String PARAM_APP_ID = "appId=";
    protected static final String PARAM_TO_LANG = "&to=";
    protected static final String PARAM_FROM_LANG = "&from=";
    protected static final String PARAM_TEXT_ARRAY = "&texts=";

    private static List<NameValuePair> getAccessTokenNameValuePair() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(4);
        params.add((NameValuePair)new BasicNameValuePair("client_id", propertiesComponent.getValue("BingClientIdStored", "android_localizationer")));
        params.add((NameValuePair)new BasicNameValuePair("client_secret", propertiesComponent.getValue("BingClientSecretStored", "eQiD1XOQCKToGLWMl0GXuWZb2cQJqYIwid8UPhln5CY=")));
        params.add((NameValuePair)new BasicNameValuePair("scope", "http://api.microsofttranslator.com"));
        params.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        return params;
    }

    public static String getAccessToken() {
        String postResult = HttpUtils.doHttpPost(AUTH_URL, BingTranslationApi.getAccessTokenNameValuePair());
        JsonObject jsonObject = new JsonParser().parse(postResult).getAsJsonObject();
        if (jsonObject.get("error") == null) {
            return jsonObject.get("access_token").getAsString();
        }
        return null;
    }

    public static List<String> getTranslatedStringArrays2(String accessToken, List<String> querys, SupportedLanguages from, SupportedLanguages to) {
        int i;
        String url = BingTranslationApi.generateUrl(accessToken, querys, from, to);
        Header[] headers = new Header[]{new BasicHeader("Authorization", "Bearer " + accessToken), new BasicHeader("Content-Type", "text/plain; charset=UTF-8"), new BasicHeader("Accept-Charset", ENCODING)};
        String getResult = HttpUtils.doHttpGet(url, headers);
        JsonArray jsonArray = null;
        try {
            jsonArray = new JsonParser().parse(getResult).getAsJsonArray();
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        if (jsonArray == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (i = 0; i < jsonArray.size(); ++i) {
            String translatedText = jsonArray.get(i).getAsJsonObject().get("TranslatedText").getAsString();
            if (translatedText == null) {
                result.add("");
                continue;
            }
            result.add(StringEscapeUtils.unescapeJava((String)translatedText));
        }
        if (querys.size() > result.size()) {
            for (i = 0; i < querys.size(); ++i) {
                if (querys.get(i).isEmpty()) {
                    result.add(i, "");
                }
                if (querys.size() == result.size()) break;
            }
        }
        Log.i(((Object)result).toString());
        return result;
    }

    private static String generateUrl(String accessToken, List<String> querys, SupportedLanguages from, SupportedLanguages to) {
        Object[] texts = new String[]{};
        texts = querys.toArray(texts);
        for (int i = 0; i < texts.length; ++i) {
            texts[i] = StringEscapeUtils.escapeJava((String)texts[i]);
        }
        try {
            String params = (accessToken != null ? PARAM_APP_ID + URLEncoder.encode("Bearer " + accessToken, ENCODING) : "") + PARAM_FROM_LANG + URLEncoder.encode(from.getLanguageCode(), ENCODING) + PARAM_TO_LANG + URLEncoder.encode(to.getLanguageCode(), ENCODING) + PARAM_TEXT_ARRAY + URLEncoder.encode(BingTranslationApi.buildStringArrayParam(texts), ENCODING);
            return TRANSLATE_URL + params;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String buildStringArrayParam(Object[] values) {
        StringBuilder targetString = new StringBuilder("[\"");
        for (Object obj : values) {
            String value;
            if (obj == null || (value = obj.toString()).length() == 0) continue;
            if (targetString.length() > 2) {
                targetString.append(",\"");
            }
            targetString.append(value);
            targetString.append("\"");
        }
        targetString.append("]");
        return targetString.toString();
    }

    public static List<String> getTranslatedStringArrays(String accessToken, List<String> querys, SupportedLanguages from, SupportedLanguages to) {
        String xmlBodyTop = "<TranslateArrayRequest>\n  <AppId />\n  <From>%s</From>\n  <Options>\n    <Category xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\" />\n    <ContentType xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\">text/plain</ContentType>\n    <ReservedFlags xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\" />\n    <State xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\" />\n    <Uri xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\" />\n    <User xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\" />\n  </Options>\n  <Texts>\n";
        String xmlBodyMid = "<string xmlns=\"http://schemas.microsoft.com/2003/10/Serialization/Arrays\">%s</string>\n";
        String xmlBodyBot = "    </Texts>\n  <To>%s</To>\n</TranslateArrayRequest>";
        String xmlBodyStrings = "";
        for (String query : querys) {
            xmlBodyStrings = xmlBodyStrings + String.format(xmlBodyMid, query);
        }
        String xmlBody = String.format(xmlBodyTop, from.getLanguageCode()) + xmlBodyStrings + String.format(xmlBodyBot, to.getLanguageCode());
        Header[] headers = new Header[]{new BasicHeader("Authorization", "Bearer " + accessToken), new BasicHeader("Content-Type", "text/xml")};
        Log.i("Bearer " + accessToken);
        Log.i("xml body: " + xmlBody);
        String postResult = HttpUtils.doHttpPost(TRANSLATE_URL, xmlBody, headers);
        Log.i("post result: " + postResult);
        List<TranslateArrayResponse> translateArrayResponses = BingResultParser.parseTranslateArrayResponse(postResult);
        ArrayList<String> result = new ArrayList<String>();
        for (TranslateArrayResponse translateArrayResponse : translateArrayResponses) {
            result.add(translateArrayResponse.getTranslatedText());
        }
        return result;
    }
}

