/*
 * Decompiled with CFR 0.152.
 */
package language_engine.bing;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import language_engine.bing.TranslateArrayResponse;

public class BingResultParser {
    static final String TranslateArrayResponse = "TranslateArrayResponse";
    static final String From = "From";
    static final String TranslatedText = "TranslatedText";

    public static List<TranslateArrayResponse> parseTranslateArrayResponse(String xml) {
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8")));
        ArrayList<TranslateArrayResponse> result = new ArrayList<TranslateArrayResponse>();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(stream);
            TranslateArrayResponse translateArrayResponse = null;
            while (eventReader.hasNext()) {
                EndElement endElement;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    if (startElement.getName().getLocalPart().equals(TranslateArrayResponse)) {
                        translateArrayResponse = new TranslateArrayResponse();
                    }
                    if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(From)) {
                        event = eventReader.nextEvent();
                        translateArrayResponse.setFrom(event.asCharacters().getData());
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equals(TranslatedText)) {
                        event = eventReader.nextEvent();
                        translateArrayResponse.setTranslatedText(event.asCharacters().getData());
                        continue;
                    }
                }
                if (!event.isEndElement() || !(endElement = event.asEndElement()).getName().getLocalPart().equals(TranslateArrayResponse)) continue;
                result.add(translateArrayResponse);
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return result;
    }
}

