/*
 * Decompiled with CFR 0.152.
 */
package language_engine;

public enum TranslationEngineType {
    Bing("Microsoft Translator"),
    Google("Google Translation API");

    private String displayName;

    private TranslationEngineType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static TranslationEngineType[] getLanguageEngineArray() {
        return new TranslationEngineType[]{Bing, Google};
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static TranslationEngineType fromName(String name) {
        if (name == null) {
            return Bing;
        }
        for (TranslationEngineType type : TranslationEngineType.values()) {
            if (!type.name().equals(name)) continue;
            return type;
        }
        return Bing;
    }

    public String toName() {
        return this.name();
    }
}

