/*
 * Decompiled with CFR 0.152.
 */
package data.task;

import action.ConvertToOtherLanguages;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import data.Log;
import data.SerializeUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import language_engine.TranslationEngineType;
import language_engine.bing.BingTranslationApi;
import language_engine.google.GoogleTranslationApi;
import module.AndroidString;
import module.FilterRule;
import module.SupportedLanguages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetTranslationTask
extends Task.Backgroundable {
    private List<SupportedLanguages> selectedLanguages;
    private final List<AndroidString> androidStrings;
    private double indicatorFractionFrame;
    private TranslationEngineType translationEngineType;
    private boolean override;
    private VirtualFile clickedFile;
    private static final String BingIdInvalid = "Invalid client id or client secret, please check them <html><a href=\"https://datamarket.azure.com/developer/applications\">here</a></html>";
    private static final String BingQuotaExceeded = "Microsoft Translator quota exceeded, please check your data usage <html><a href=\"https://datamarket.azure.com/account/datasets\">here</a></html>";
    private static final String GoogleErrorUnknown = "Error, please check API key in the settings panel.";
    private static final String GoogleDailyLimitError = "Daily Limit Exceeded, please note that Google Translation API is a <html><a href=\"https://cloud.google.com/translate/v2/pricing\">paid service.</a></html>";
    private String errorMsg = null;

    public GetTranslationTask(Project project, String title, List<SupportedLanguages> selectedLanguages, List<AndroidString> androidStrings, TranslationEngineType translationEngineType, boolean override, VirtualFile clickedFile) {
        super(project, title);
        this.selectedLanguages = selectedLanguages;
        this.androidStrings = androidStrings;
        this.translationEngineType = translationEngineType;
        this.indicatorFractionFrame = 1.0 / (double)this.selectedLanguages.size();
        this.override = override;
        this.clickedFile = clickedFile;
    }

    public void run(ProgressIndicator indicator) {
        for (int i = 0; i < this.selectedLanguages.size(); ++i) {
            SupportedLanguages language = this.selectedLanguages.get(i);
            List<List<AndroidString>> filteredAndSplittedString = this.splitAndroidString(this.filterAndroidString(this.androidStrings, language, this.override), this.translationEngineType);
            ArrayList<AndroidString> translationResult = new ArrayList<AndroidString>();
            for (int j = 0; j < filteredAndSplittedString.size(); ++j) {
                translationResult.addAll(this.getTranslationEngineResult(filteredAndSplittedString.get(j), language, SupportedLanguages.English, this.translationEngineType));
                indicator.setFraction(this.indicatorFractionFrame * (double)i + this.indicatorFractionFrame / (double)filteredAndSplittedString.size() * (double)j);
                indicator.setText("Translating to " + language.getLanguageEnglishDisplayName() + " (" + language.getLanguageDisplayName() + ")");
            }
            String fileName = this.getValueResourcePath(language);
            List<AndroidString> fileContent = GetTranslationTask.getTargetAndroidStrings(this.androidStrings, translationResult, fileName, this.override);
            GetTranslationTask.writeAndroidStringToLocal(this.myProject, fileName, fileContent);
        }
    }

    public void onSuccess() {
        if (this.errorMsg == null || this.errorMsg.isEmpty()) {
            return;
        }
        ConvertToOtherLanguages.showErrorDialog(this.getProject(), this.errorMsg);
    }

    private String getValueResourcePath(SupportedLanguages language) {
        String resPath = this.clickedFile.getPath().substring(0, this.clickedFile.getPath().indexOf("/res/") + "/res/".length());
        return resPath + "values-" + language.getAndroidStringFolderNameSuffix() + "/" + this.clickedFile.getName();
    }

    private List<AndroidString> getTranslationEngineResult(@NotNull List<AndroidString> needToTranslatedString, @NotNull SupportedLanguages targetLanguageCode, @NotNull SupportedLanguages sourceLanguageCode, TranslationEngineType translationEngineType) {
        if (needToTranslatedString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needToTranslatedString", "data/task/GetTranslationTask", "getTranslationEngineResult"));
        }
        if (targetLanguageCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLanguageCode", "data/task/GetTranslationTask", "getTranslationEngineResult"));
        }
        if (sourceLanguageCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceLanguageCode", "data/task/GetTranslationTask", "getTranslationEngineResult"));
        }
        List<String> querys = AndroidString.getAndroidStringValues(needToTranslatedString);
        List<String> result = null;
        switch (translationEngineType) {
            case Bing: {
                String accessToken = BingTranslationApi.getAccessToken();
                if (accessToken == null) {
                    this.errorMsg = BingIdInvalid;
                    return null;
                }
                result = BingTranslationApi.getTranslatedStringArrays2(accessToken, querys, sourceLanguageCode, targetLanguageCode);
                if (result != null && !result.isEmpty() || querys.isEmpty()) break;
                this.errorMsg = BingQuotaExceeded;
                return null;
            }
            case Google: {
                result = GoogleTranslationApi.getTranslationJSON(querys, targetLanguageCode, sourceLanguageCode);
                if (result == null) {
                    this.errorMsg = GoogleErrorUnknown;
                    return null;
                }
                if (!result.isEmpty() || querys.isEmpty()) break;
                this.errorMsg = GoogleDailyLimitError;
                return null;
            }
        }
        ArrayList<AndroidString> translatedAndroidStrings = new ArrayList<AndroidString>();
        for (int i = 0; i < needToTranslatedString.size(); ++i) {
            translatedAndroidStrings.add(new AndroidString(needToTranslatedString.get(i).getKey(), result.get(i)));
        }
        return translatedAndroidStrings;
    }

    private List<List<AndroidString>> splitAndroidString(List<AndroidString> origin, TranslationEngineType engineType) {
        ArrayList<List<AndroidString>> splited = new ArrayList<List<AndroidString>>();
        int splitFragment = 50;
        switch (engineType) {
            case Bing: {
                splitFragment = 50;
                break;
            }
            case Google: {
                splitFragment = 50;
            }
        }
        if (origin.size() <= splitFragment) {
            splited.add(origin);
        } else {
            int count = origin.size() % splitFragment == 0 ? origin.size() / splitFragment : origin.size() / splitFragment + 1;
            for (int i = 1; i <= count; ++i) {
                int end = i * splitFragment;
                if (end > origin.size()) {
                    end = origin.size();
                }
                splited.add(origin.subList((i - 1) * splitFragment, end));
            }
        }
        return splited;
    }

    private List<AndroidString> filterAndroidString(List<AndroidString> origin, SupportedLanguages language, boolean override) {
        ArrayList<AndroidString> result = new ArrayList<AndroidString>();
        VirtualFile targetStringFile = LocalFileSystem.getInstance().findFileByPath(this.getValueResourcePath(language));
        List<Object> targetAndroidStrings = new ArrayList();
        if (targetStringFile != null) {
            try {
                targetAndroidStrings = AndroidString.getAndroidStringsList(targetStringFile.contentsToByteArray());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        String rulesString = PropertiesComponent.getInstance().getValue("SettingFilterRules");
        ArrayList<FilterRule> filterRules = new ArrayList<FilterRule>();
        if (rulesString == null) {
            filterRules.add(FilterRule.DefaultFilterRule);
        } else {
            filterRules = SerializeUtil.deserializeFilterRuleList(rulesString);
        }
        for (AndroidString androidString : origin) {
            if (FilterRule.inFilterRule(androidString.getKey(), filterRules) || !override && !targetAndroidStrings.isEmpty() && GetTranslationTask.isAndroidStringListContainsKey(targetAndroidStrings, androidString.getKey())) continue;
            result.add(androidString);
        }
        return result;
    }

    private static List<AndroidString> getTargetAndroidStrings(List<AndroidString> sourceAndroidStrings, List<AndroidString> translatedAndroidStrings, String fileName, boolean override) {
        if (translatedAndroidStrings == null) {
            translatedAndroidStrings = new ArrayList<AndroidString>();
        }
        VirtualFile existenceFile = LocalFileSystem.getInstance().findFileByPath(fileName);
        ArrayList<AndroidString> existenceAndroidStrings = null;
        if (existenceFile != null && !override) {
            try {
                existenceAndroidStrings = AndroidString.getAndroidStringsList(existenceFile.contentsToByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            existenceAndroidStrings = new ArrayList();
        }
        Log.i("sourceAndroidStrings: " + sourceAndroidStrings, "translatedAndroidStrings: " + translatedAndroidStrings, "existenceAndroidStrings: " + existenceAndroidStrings);
        ArrayList<AndroidString> targetAndroidStrings = new ArrayList<AndroidString>();
        for (int i = 0; i < sourceAndroidStrings.size(); ++i) {
            String translatedValue;
            String existenceValue;
            AndroidString string = sourceAndroidStrings.get(i);
            AndroidString resultString = new AndroidString(string);
            if (!override && (existenceValue = GetTranslationTask.getAndroidStringValueInList(existenceAndroidStrings, resultString.getKey())) != null) {
                resultString.setValue(existenceValue);
            }
            if ((translatedValue = GetTranslationTask.getAndroidStringValueInList(translatedAndroidStrings, resultString.getKey())) != null) {
                resultString.setValue(translatedValue);
            }
            targetAndroidStrings.add(resultString);
        }
        Log.i("targetAndroidStrings: " + targetAndroidStrings);
        return targetAndroidStrings;
    }

    private static void writeAndroidStringToLocal(final Project myProject, String filePath, List<AndroidString> fileContent) {
        File file = new File(filePath);
        boolean fileExits = true;
        try {
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                fileExits = false;
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file.getAbsoluteFile());
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(GetTranslationTask.getFileContent(fileContent));
            osw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fileExits) {
            final VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (virtualFile == null) {
                return;
            }
            virtualFile.refresh(true, false, new Runnable(){

                @Override
                public void run() {
                    GetTranslationTask.openFileInEditor(myProject, virtualFile);
                }
            });
        } else {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            GetTranslationTask.openFileInEditor(myProject, virtualFile);
        }
    }

    private static void openFileInEditor(final Project myProject, final @Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)myProject);
                editorManager.openFile(file, true);
            }
        });
    }

    private static String getFileContent(List<AndroidString> fileContent) {
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        String stringResourceHeader = "<resources>\n\n";
        String stringResourceTail = "</resources>\n";
        StringBuilder sb = new StringBuilder();
        sb.append(xmlHeader).append(stringResourceHeader);
        for (AndroidString androidString : fileContent) {
            sb.append("\t").append(androidString.toString()).append("\n");
        }
        sb.append("\n").append(stringResourceTail);
        return sb.toString();
    }

    private static boolean isAndroidStringListContainsKey(List<AndroidString> androidStrings, String key) {
        List<String> keys = AndroidString.getAndroidStringKeys(androidStrings);
        return keys.contains(key);
    }

    public static String getAndroidStringValueInList(List<AndroidString> androidStrings, String key) {
        for (AndroidString androidString : androidStrings) {
            if (!androidString.getKey().equals(key)) continue;
            return androidString.getValue();
        }
        return null;
    }
}

