/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.util.ArrayList;
import java.util.List;
import module.FilterRule;

public class SerializeUtil {
    public static String serializeFilterRuleList(List<FilterRule> rules) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rules.size(); ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(rules.get(i).getFilterRuleType().toName()).append("<>").append(rules.get(i).getFilterString());
        }
        return sb.toString();
    }

    public static List<FilterRule> deserializeFilterRuleList(String ruleString) {
        ArrayList<FilterRule> rules = new ArrayList<FilterRule>();
        String[] tokens = ruleString.split("\n");
        for (int i = 0; i < tokens.length; ++i) {
            String[] values = tokens[i].split("<>");
            if (values.length != 2) continue;
            rules.add(new FilterRule(FilterRule.FilterRuleType.fromName(values[0]), values[1]));
        }
        return rules;
    }
}

